/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.pqc.crypto.lms;

import java.util.HashMap;
import java.util.Map;
import sqldelight.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import sqldelight.org.bouncycastle.asn1.ASN1Primitive;
import sqldelight.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import sqldelight.org.bouncycastle.crypto.Digest;
import sqldelight.org.bouncycastle.crypto.Xof;
import sqldelight.org.bouncycastle.crypto.digests.SHA256Digest;
import sqldelight.org.bouncycastle.crypto.digests.SHA512Digest;
import sqldelight.org.bouncycastle.crypto.digests.SHAKEDigest;

class DigestUtil {
    private static Map<String, ASN1ObjectIdentifier> nameToOid = new HashMap();
    private static Map<ASN1ObjectIdentifier, String> oidToName = new HashMap();

    DigestUtil() {
    }

    static Digest getDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)NISTObjectIdentifiers.id_sha256)) {
            return new SHA256Digest();
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)NISTObjectIdentifiers.id_sha512)) {
            return new SHA512Digest();
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)NISTObjectIdentifiers.id_shake128)) {
            return new SHAKEDigest(128);
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)NISTObjectIdentifiers.id_shake256)) {
            return new SHAKEDigest(256);
        }
        throw new IllegalArgumentException("unrecognized digest OID: " + aSN1ObjectIdentifier);
    }

    static String getDigestName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = (String)oidToName.get(aSN1ObjectIdentifier);
        if (string != null) {
            return string;
        }
        throw new IllegalArgumentException("unrecognized digest oid: " + aSN1ObjectIdentifier);
    }

    static ASN1ObjectIdentifier getDigestOID(String string) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)nameToOid.get(string);
        if (aSN1ObjectIdentifier != null) {
            return aSN1ObjectIdentifier;
        }
        throw new IllegalArgumentException("unrecognized digest name: " + string);
    }

    public static int getDigestSize(Digest digest) {
        if (digest instanceof Xof) {
            return digest.getDigestSize() * 2;
        }
        return digest.getDigestSize();
    }

    static {
        nameToOid.put("SHA-256", NISTObjectIdentifiers.id_sha256);
        nameToOid.put("SHA-512", NISTObjectIdentifiers.id_sha512);
        nameToOid.put("SHAKE128", NISTObjectIdentifiers.id_shake128);
        nameToOid.put("SHAKE256", NISTObjectIdentifiers.id_shake256);
        oidToName.put(NISTObjectIdentifiers.id_sha256, "SHA-256");
        oidToName.put(NISTObjectIdentifiers.id_sha512, "SHA-512");
        oidToName.put(NISTObjectIdentifiers.id_shake128, "SHAKE128");
        oidToName.put(NISTObjectIdentifiers.id_shake256, "SHAKE256");
    }
}

