/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.pqc.crypto.qtesla;

import sqldelight.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import sqldelight.org.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import sqldelight.org.bouncycastle.util.Arrays;

public final class QTESLAPrivateKeyParameters
extends AsymmetricKeyParameter {
    private int securityCategory;
    private byte[] privateKey;

    public QTESLAPrivateKeyParameters(int n, byte[] byArray) {
        super(true);
        if (byArray.length != QTESLASecurityCategory.getPrivateSize((int)n)) {
            throw new IllegalArgumentException("invalid key size for security category");
        }
        this.securityCategory = n;
        this.privateKey = Arrays.clone((byte[])byArray);
    }

    public int getSecurityCategory() {
        return this.securityCategory;
    }

    public byte[] getSecret() {
        return Arrays.clone((byte[])this.privateKey);
    }
}

