/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.pqc.crypto.qtesla;

import sqldelight.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import sqldelight.org.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import sqldelight.org.bouncycastle.util.Arrays;

public final class QTESLAPublicKeyParameters
extends AsymmetricKeyParameter {
    private int securityCategory;
    private byte[] publicKey;

    public QTESLAPublicKeyParameters(int n, byte[] byArray) {
        super(false);
        if (byArray.length != QTESLASecurityCategory.getPublicSize((int)n)) {
            throw new IllegalArgumentException("invalid key size for security category");
        }
        this.securityCategory = n;
        this.publicKey = Arrays.clone((byte[])byArray);
    }

    public int getSecurityCategory() {
        return this.securityCategory;
    }

    public byte[] getPublicData() {
        return Arrays.clone((byte[])this.publicKey);
    }
}

