/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.pqc.crypto.xmss;

import sqldelight.org.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import sqldelight.org.bouncycastle.pqc.crypto.xmss.XMSSUtil;

final class WOTSPlusPrivateKeyParameters {
    private final byte[][] privateKey;

    protected WOTSPlusPrivateKeyParameters(WOTSPlusParameters wOTSPlusParameters, byte[][] byArray) {
        if (wOTSPlusParameters == null) {
            throw new NullPointerException("params == null");
        }
        if (byArray == null) {
            throw new NullPointerException("privateKey == null");
        }
        if (XMSSUtil.hasNullPointer((byte[][])byArray)) {
            throw new NullPointerException("privateKey byte array == null");
        }
        if (byArray.length != wOTSPlusParameters.getLen()) {
            throw new IllegalArgumentException("wrong privateKey format");
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i].length == wOTSPlusParameters.getTreeDigestSize()) continue;
            throw new IllegalArgumentException("wrong privateKey format");
        }
        this.privateKey = XMSSUtil.cloneArray((byte[][])byArray);
    }

    protected byte[][] toByteArray() {
        return XMSSUtil.cloneArray((byte[][])this.privateKey);
    }
}

