/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import sqldelight.org.bouncycastle.pqc.crypto.xmss.BDS;
import sqldelight.org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import sqldelight.org.bouncycastle.pqc.crypto.xmss.XMSSKeyParameters;
import sqldelight.org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import sqldelight.org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import sqldelight.org.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import sqldelight.org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import sqldelight.org.bouncycastle.util.Arrays;
import sqldelight.org.bouncycastle.util.Encodable;
import sqldelight.org.bouncycastle.util.Pack;

/*
 * Exception performing whole class analysis ignored.
 */
public final class XMSSPrivateKeyParameters
extends XMSSKeyParameters
implements XMSSStoreableObjectInterface,
Encodable {
    private final XMSSParameters params;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private volatile BDS bdsState;

    private XMSSPrivateKeyParameters(Builder builder) {
        super(true, Builder.access$000((Builder)builder).getTreeDigest());
        this.params = Builder.access$000((Builder)builder);
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n = this.params.getTreeDigestSize();
        byte[] byArray = Builder.access$100((Builder)builder);
        if (byArray != null) {
            int n2 = this.params.getHeight();
            int n3 = 4;
            int n4 = n;
            int n5 = n;
            int n6 = n;
            int n7 = n;
            int n8 = 0;
            int n9 = Pack.bigEndianToInt((byte[])byArray, (int)n8);
            if (!XMSSUtil.isIndexValid((int)n2, (long)n9)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n3), (int)n4);
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n4), (int)n5);
            this.publicSeed = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n5), (int)n6);
            this.root = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n6), (int)n7);
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n7), (int)(byArray.length - n8));
            try {
                BDS bDS = (BDS)XMSSUtil.deserialize((byte[])byArray2, BDS.class);
                if (bDS.getIndex() != n9) {
                    throw new IllegalStateException("serialized BDS has wrong index");
                }
                this.bdsState = bDS.withWOTSDigest(Builder.access$000((Builder)builder).getTreeDigestOID());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
            }
        } else {
            byte[] byArray3 = Builder.access$200((Builder)builder);
            if (byArray3 != null) {
                if (byArray3.length != n) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.secretKeySeed = byArray3;
            } else {
                this.secretKeySeed = new byte[n];
            }
            byte[] byArray4 = Builder.access$300((Builder)builder);
            if (byArray4 != null) {
                if (byArray4.length != n) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.secretKeyPRF = byArray4;
            } else {
                this.secretKeyPRF = new byte[n];
            }
            byte[] byArray5 = Builder.access$400((Builder)builder);
            if (byArray5 != null) {
                if (byArray5.length != n) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.publicSeed = byArray5;
            } else {
                this.publicSeed = new byte[n];
            }
            byte[] byArray6 = Builder.access$500((Builder)builder);
            if (byArray6 != null) {
                if (byArray6.length != n) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.root = byArray6;
            } else {
                this.root = new byte[n];
            }
            BDS bDS = Builder.access$600((Builder)builder);
            this.bdsState = bDS != null ? bDS : (Builder.access$700((Builder)builder) < (1 << this.params.getHeight()) - 2 && byArray5 != null && byArray3 != null ? new BDS(this.params, byArray5, byArray3, (OTSHashAddress)new OTSHashAddress.Builder().build(), Builder.access$700((Builder)builder)) : new BDS(this.params, (1 << this.params.getHeight()) - 1, Builder.access$700((Builder)builder)));
            if (Builder.access$800((Builder)builder) >= 0 && Builder.access$800((Builder)builder) != this.bdsState.getMaxIndex()) {
                throw new IllegalArgumentException("maxIndex set but not reflected in state");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsagesRemaining() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            return this.bdsState.getMaxIndex() - this.getIndex() + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEncoded() throws IOException {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            return this.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMSSPrivateKeyParameters rollKey() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            this.bdsState = this.bdsState.getIndex() < this.bdsState.getMaxIndex() ? this.bdsState.getNextState(this.publicSeed, this.secretKeySeed, (OTSHashAddress)new OTSHashAddress.Builder().build()) : new BDS(this.params, this.bdsState.getMaxIndex(), this.bdsState.getMaxIndex() + 1);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMSSPrivateKeyParameters getNextKey() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters2 = this.extractKeyShard(1);
            return xMSSPrivateKeyParameters2;
        }
    }

    public XMSSPrivateKeyParameters extractKeyShard(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("cannot ask for a shard with 0 keys");
        }
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            if ((long)n <= this.getUsagesRemaining()) {
                XMSSPrivateKeyParameters xMSSPrivateKeyParameters2 = new Builder(this.params).withSecretKeySeed(this.secretKeySeed).withSecretKeyPRF(this.secretKeyPRF).withPublicSeed(this.publicSeed).withRoot(this.root).withIndex(this.getIndex()).withBDSState(this.bdsState.withMaxIndex(this.bdsState.getIndex() + n - 1, this.params.getTreeDigestOID())).build();
                if ((long)n == this.getUsagesRemaining()) {
                    this.bdsState = new BDS(this.params, this.bdsState.getMaxIndex(), this.getIndex() + n);
                } else {
                    OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().build();
                    for (int i = 0; i != n; ++i) {
                        this.bdsState = this.bdsState.getNextState(this.publicSeed, this.secretKeySeed, oTSHashAddress);
                    }
                }
                return xMSSPrivateKeyParameters2;
            }
            throw new IllegalArgumentException("usageCount exceeds usages remaining");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            int n = this.params.getTreeDigestSize();
            int n2 = 4;
            int n3 = n;
            int n4 = n;
            int n5 = n;
            int n6 = n;
            int n7 = n2 + n3 + n4 + n5 + n6;
            byte[] byArray = new byte[n7];
            int n8 = 0;
            Pack.intToBigEndian((int)this.bdsState.getIndex(), (byte[])byArray, (int)n8);
            XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.secretKeySeed, (int)(n8 += n2));
            XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.secretKeyPRF, (int)(n8 += n3));
            XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.publicSeed, (int)(n8 += n4));
            XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.root, (int)(n8 += n5));
            byte[] byArray2 = null;
            try {
                byArray2 = XMSSUtil.serialize((Object)this.bdsState);
            }
            catch (IOException iOException) {
                throw new RuntimeException("error serializing bds state: " + iOException.getMessage());
            }
            return Arrays.concatenate((byte[])byArray, (byte[])byArray2);
        }
    }

    public int getIndex() {
        return this.bdsState.getIndex();
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray((byte[])this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray((byte[])this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray((byte[])this.publicSeed);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray((byte[])this.root);
    }

    BDS getBDSState() {
        return this.bdsState;
    }

    public XMSSParameters getParameters() {
        return this.params;
    }
}

