/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.pqc.jcajce.provider.qtesla;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import sqldelight.org.bouncycastle.asn1.ASN1Set;
import sqldelight.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import sqldelight.org.bouncycastle.crypto.CipherParameters;
import sqldelight.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import sqldelight.org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import sqldelight.org.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import sqldelight.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import sqldelight.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import sqldelight.org.bouncycastle.pqc.jcajce.interfaces.QTESLAKey;
import sqldelight.org.bouncycastle.pqc.jcajce.spec.QTESLAParameterSpec;
import sqldelight.org.bouncycastle.util.Arrays;

public class BCqTESLAPrivateKey
implements PrivateKey,
QTESLAKey {
    private static final long serialVersionUID = 1L;
    private transient QTESLAPrivateKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCqTESLAPrivateKey(QTESLAPrivateKeyParameters qTESLAPrivateKeyParameters) {
        this.keyParams = qTESLAPrivateKeyParameters;
    }

    public BCqTESLAPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.keyParams = (QTESLAPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
    }

    @Override
    public final String getAlgorithm() {
        return QTESLASecurityCategory.getName((int)this.keyParams.getSecurityCategory());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public QTESLAParameterSpec getParams() {
        return new QTESLAParameterSpec(this.getAlgorithm());
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)this.keyParams, (ASN1Set)this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCqTESLAPrivateKey) {
            BCqTESLAPrivateKey bCqTESLAPrivateKey = (BCqTESLAPrivateKey)object;
            return this.keyParams.getSecurityCategory() == bCqTESLAPrivateKey.keyParams.getSecurityCategory() && Arrays.areEqual((byte[])this.keyParams.getSecret(), (byte[])bCqTESLAPrivateKey.keyParams.getSecret());
        }
        return false;
    }

    public int hashCode() {
        return this.keyParams.getSecurityCategory() + 37 * Arrays.hashCode((byte[])this.keyParams.getSecret());
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance((Object)byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

