/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.pqc.jcajce.provider.qtesla;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import sqldelight.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import sqldelight.org.bouncycastle.crypto.CipherParameters;
import sqldelight.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import sqldelight.org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import sqldelight.org.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import sqldelight.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import sqldelight.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import sqldelight.org.bouncycastle.pqc.jcajce.interfaces.QTESLAKey;
import sqldelight.org.bouncycastle.pqc.jcajce.spec.QTESLAParameterSpec;
import sqldelight.org.bouncycastle.util.Arrays;

public class BCqTESLAPublicKey
implements PublicKey,
QTESLAKey {
    private static final long serialVersionUID = 1L;
    private transient QTESLAPublicKeyParameters keyParams;

    public BCqTESLAPublicKey(QTESLAPublicKeyParameters qTESLAPublicKeyParameters) {
        this.keyParams = qTESLAPublicKeyParameters;
    }

    public BCqTESLAPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.keyParams = (QTESLAPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
    }

    @Override
    public final String getAlgorithm() {
        return QTESLASecurityCategory.getName((int)this.keyParams.getSecurityCategory());
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)this.keyParams);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    public QTESLAParameterSpec getParams() {
        return new QTESLAParameterSpec(this.getAlgorithm());
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCqTESLAPublicKey) {
            BCqTESLAPublicKey bCqTESLAPublicKey = (BCqTESLAPublicKey)object;
            return this.keyParams.getSecurityCategory() == bCqTESLAPublicKey.keyParams.getSecurityCategory() && Arrays.areEqual((byte[])this.keyParams.getPublicData(), (byte[])bCqTESLAPublicKey.keyParams.getPublicData());
        }
        return false;
    }

    public int hashCode() {
        return this.keyParams.getSecurityCategory() + 37 * Arrays.hashCode((byte[])this.keyParams.getPublicData());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance((Object)byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

