/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.pqc.jcajce.provider.sphincs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import sqldelight.org.bouncycastle.asn1.ASN1Encodable;
import sqldelight.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import sqldelight.org.bouncycastle.asn1.ASN1Primitive;
import sqldelight.org.bouncycastle.asn1.ASN1Set;
import sqldelight.org.bouncycastle.asn1.DEROctetString;
import sqldelight.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import sqldelight.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import sqldelight.org.bouncycastle.crypto.CipherParameters;
import sqldelight.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import sqldelight.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import sqldelight.org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import sqldelight.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import sqldelight.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import sqldelight.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import sqldelight.org.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import sqldelight.org.bouncycastle.util.Arrays;

public class BCSphincs256PrivateKey
implements PrivateKey,
SPHINCSKey {
    private static final long serialVersionUID = 1L;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient SPHINCSPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSphincs256PrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, SPHINCSPrivateKeyParameters sPHINCSPrivateKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.params = sPHINCSPrivateKeyParameters;
    }

    public BCSphincs256PrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.treeDigest = SPHINCS256KeyParams.getInstance((Object)privateKeyInfo.getPrivateKeyAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.params = (SPHINCSPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSphincs256PrivateKey) {
            BCSphincs256PrivateKey bCSphincs256PrivateKey = (BCSphincs256PrivateKey)object;
            return this.treeDigest.equals((ASN1Primitive)bCSphincs256PrivateKey.treeDigest) && Arrays.areEqual((byte[])this.params.getKeyData(), (byte[])bCSphincs256PrivateKey.params.getKeyData());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode((byte[])this.params.getKeyData());
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo;
            if (this.params.getTreeDigest() != null) {
                privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)this.params, (ASN1Set)this.attributes);
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, (ASN1Encodable)new SPHINCS256KeyParams(new AlgorithmIdentifier(this.treeDigest)));
                privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(this.params.getKeyData()), this.attributes);
            }
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    ASN1ObjectIdentifier getTreeDigest() {
        return this.treeDigest;
    }

    public byte[] getKeyData() {
        return this.params.getKeyData();
    }

    CipherParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance((Object)byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

