/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.pqc.jcajce.provider.sphincs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import sqldelight.org.bouncycastle.asn1.ASN1Encodable;
import sqldelight.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import sqldelight.org.bouncycastle.asn1.ASN1Primitive;
import sqldelight.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import sqldelight.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import sqldelight.org.bouncycastle.crypto.CipherParameters;
import sqldelight.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import sqldelight.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import sqldelight.org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import sqldelight.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import sqldelight.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import sqldelight.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import sqldelight.org.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import sqldelight.org.bouncycastle.util.Arrays;

public class BCSphincs256PublicKey
implements PublicKey,
SPHINCSKey {
    private static final long serialVersionUID = 1L;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient SPHINCSPublicKeyParameters params;

    public BCSphincs256PublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, SPHINCSPublicKeyParameters sPHINCSPublicKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.params = sPHINCSPublicKeyParameters;
    }

    public BCSphincs256PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.treeDigest = SPHINCS256KeyParams.getInstance((Object)subjectPublicKeyInfo.getAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.params = (SPHINCSPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSphincs256PublicKey) {
            BCSphincs256PublicKey bCSphincs256PublicKey = (BCSphincs256PublicKey)object;
            return this.treeDigest.equals((ASN1Primitive)bCSphincs256PublicKey.treeDigest) && Arrays.areEqual((byte[])this.params.getKeyData(), (byte[])bCSphincs256PublicKey.params.getKeyData());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode((byte[])this.params.getKeyData());
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            if (this.params.getTreeDigest() != null) {
                subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)this.params);
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, (ASN1Encodable)new SPHINCS256KeyParams(new AlgorithmIdentifier(this.treeDigest)));
                subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, this.params.getKeyData());
            }
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    public byte[] getKeyData() {
        return this.params.getKeyData();
    }

    ASN1ObjectIdentifier getTreeDigest() {
        return this.treeDigest;
    }

    CipherParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance((Object)byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

