/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.ikv;

import sqldelight.org.jetbrains.xxh3.Xxh3;

public interface UniversalHash<T> {
    public long universalHash(T var1, long var2);

    public static final class StringHash
    implements UniversalHash<String> {
        public static final StringHash INSTANCE = new StringHash();

        @Override
        public long universalHash(String key, long index) {
            return Xxh3.seededHash(key, index);
        }
    }

    public static final class IntHash
    implements UniversalHash<Integer> {
        public static final IntHash INSTANCE = new IntHash();

        @Override
        public long universalHash(Integer key, long index) {
            return Xxh3.hashInt(key, index);
        }
    }
}

