/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.mvstore;

import java.util.Arrays;
import java.util.Comparator;
import sqldelight.io.netty.buffer.ByteBuf;
import sqldelight.io.netty.buffer.PooledByteBufAllocator;
import sqldelight.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import sqldelight.it.unimi.dsi.fastutil.longs.LongArrayList;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.integratedBinaryPacking.IntBitPacker;
import sqldelight.org.jetbrains.mvstore.DataUtil;
import sqldelight.org.jetbrains.mvstore.FileStore;
import sqldelight.org.jetbrains.mvstore.MVStoreException;

final class Chunk {
    private static final int FLAG_LIVE_MAX = 1;
    private static final int FLAG_UNUSED = 2;
    private static final int FLAG_UNUSED_AT_VERSION = 4;
    private static final int FLAG_PIN_COUNT = 8;
    private static final int FLAG_OCCUPANCY = 16;
    static final int MAX_ID = 0x3FFFFFF;
    static final int MAX_METADATA_LENGTH = 4096;
    private static final int MAX_OCCUPANCY_LENGTH = 3995;
    static final int HEADER_LENGTH = 76;
    static final int FOOTER_LENGTH = 24;
    public final int id;
    public volatile long block;
    int blockCount;
    int pageCount;
    int tocPos;
    @Nullable
    private IntOpenHashSet occupancy;
    public long maxLen;
    public long maxLenLive;
    int collectPriority;
    long layoutRootPageInfo;
    long chunkMapRootPageInfo;
    public long version;
    public long time;
    public long unused;
    long unusedAtVersion;
    public int mapId;
    long next;
    private int pinCount;

    Chunk(int id, long block, long version2) {
        this(id);
        this.block = block;
        this.version = version2;
    }

    Chunk(int id) {
        this.id = id;
        if (id <= 0) {
            throw new MVStoreException(6, "Invalid chunk id " + id);
        }
    }

    boolean isLivePage(int pageNumber) {
        return this.occupancy == null || !this.occupancy.contains(pageNumber);
    }

    int getLivePageCount() {
        return this.occupancy == null ? this.pageCount : this.pageCount - this.occupancy.size();
    }

    private Chunk(int id, ByteBuf buf, int flags) {
        if (id <= 0) {
            throw new MVStoreException(6, "Invalid chunk id " + id);
        }
        this.id = id;
        this.mapId = buf.readInt();
        this.block = buf.readLong();
        this.tocPos = buf.readInt();
        this.blockCount = buf.readInt();
        this.maxLen = buf.readLong();
        this.maxLenLive = (flags & 1) == 1 ? buf.readLong() : this.maxLen;
        this.pageCount = buf.readInt();
        this.next = buf.readLong();
        this.layoutRootPageInfo = buf.readLong();
        this.chunkMapRootPageInfo = buf.readLong();
        this.time = buf.readLong();
        this.version = buf.readLong();
        if ((flags & 2) == 2) {
            this.unused = buf.readLong();
        }
        if ((flags & 4) == 4) {
            this.unusedAtVersion = buf.readLong();
        }
        if ((flags & 8) == 8) {
            this.pinCount = buf.readInt();
        }
        if ((flags & 0x10) == 16) {
            int[] values = new int[IntBitPacker.readVar(buf)];
            DataUtil.unpackInts(values, buf);
            this.occupancy = new IntOpenHashSet(values);
        } else {
            this.occupancy = null;
        }
    }

    static Chunk readChunkHeader(ByteBuf buf, long start) {
        try {
            return new Chunk(buf.readInt(), buf, 0);
        }
        catch (Exception e) {
            throw new MVStoreException(6, "File corrupt reading chunk at position " + start, e);
        }
    }

    static Chunk readMetadata(int chunkId, ByteBuf buf) {
        try {
            byte flags = buf.readByte();
            return new Chunk(chunkId, buf, flags);
        }
        catch (Exception e) {
            throw new MVStoreException(6, "File corrupt reading chunk", e);
        }
    }

    void writeMetadata(ByteBuf buf) {
        IntOpenHashSet occupancy;
        byte flags = 0;
        int flagPosition = buf.writerIndex();
        buf.writerIndex(flagPosition + 1);
        buf.writeInt(this.mapId);
        buf.writeLong(this.block);
        buf.writeInt(this.tocPos);
        buf.writeInt(this.blockCount);
        buf.writeLong(this.maxLen);
        if (this.maxLen != this.maxLenLive) {
            flags = (byte)(flags | 1);
            buf.writeLong(this.maxLenLive);
        }
        buf.writeInt(this.pageCount);
        buf.writeLong(this.next);
        buf.writeLong(this.layoutRootPageInfo);
        buf.writeLong(this.chunkMapRootPageInfo);
        buf.writeLong(this.time);
        buf.writeLong(this.version);
        if (this.unused != 0L) {
            flags = (byte)(flags | 2);
            buf.writeLong(this.unused);
        }
        if (this.unusedAtVersion != 0L) {
            flags = (byte)(flags | 4);
            buf.writeLong(this.unusedAtVersion);
        }
        if (this.pinCount > 0) {
            flags = (byte)(flags | 8);
            buf.writeInt(this.pinCount);
        }
        if ((occupancy = this.occupancy) != null && !occupancy.isEmpty()) {
            flags = (byte)(flags | 0x10);
            int oldWriterIndex = buf.writerIndex();
            int[] values = occupancy.toIntArray();
            Arrays.sort(values);
            IntBitPacker.writeVar(buf, values.length);
            DataUtil.packInts(values, buf);
            int writtenSize = buf.writerIndex() - oldWriterIndex;
            if (writtenSize > 3995) {
                throw new IllegalStateException("Size of serialized occupancy cannot be greater than 3995 but " + writtenSize);
            }
        }
        buf.setByte(flagPosition, flags);
    }

    void writeHeader(ByteBuf buf) {
        assert (this.occupancy == null && this.maxLenLive == this.maxLen && this.unused == 0L && this.unusedAtVersion == 0L && this.pinCount == 0);
        buf.ensureWritable(76);
        buf.writeInt(this.id);
        buf.writeInt(this.mapId);
        buf.writeLong(this.block);
        buf.writeInt(this.tocPos);
        buf.writeInt(this.blockCount);
        buf.writeLong(this.maxLen);
        buf.writeInt(this.pageCount);
        buf.writeLong(this.next);
        buf.writeLong(this.layoutRootPageInfo);
        buf.writeLong(this.chunkMapRootPageInfo);
        buf.writeLong(this.time);
        buf.writeLong(this.version);
    }

    int getFillRate() {
        assert (this.maxLenLive <= this.maxLen) : this.maxLenLive + " > " + this.maxLen;
        if (this.maxLenLive <= 0L) {
            return 0;
        }
        if (this.maxLenLive == this.maxLen) {
            return 100;
        }
        return 1 + (int)(98L * this.maxLenLive / this.maxLen);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        return o instanceof Chunk && ((Chunk)o).id == this.id;
    }

    void writeFooter(@NotNull ByteBuf buf) {
        if (buf == null) {
            Chunk.$$$reportNull$$$0(0);
        }
        int start = buf.writerIndex();
        buf.writeInt(this.id);
        buf.writeLong(this.block);
        buf.writeLong(this.version);
        buf.writeInt(DataUtil.getFletcher32(buf, start, 20));
    }

    boolean isSaved() {
        return this.block != Long.MAX_VALUE;
    }

    boolean isLive() {
        return this.occupancy == null || this.pageCount != this.occupancy.size();
    }

    boolean isRewritable() {
        return this.isSaved() && this.isLive() && this.occupancy != null && !this.occupancy.isEmpty() && this.isEvacuatable();
    }

    private boolean isEvacuatable() {
        return this.pinCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ByteBuf readBufferForPage(FileStore fileStore, int offset, long pos) {
        assert (this.isSaved()) : this;
        while (true) {
            long originalBlock = this.block;
            try {
                ByteBuf buf;
                long filePos = originalBlock * 4096L;
                long maxPos = filePos + (long)this.blockCount * 4096L;
                if ((filePos += (long)offset) < 0L) {
                    throw new MVStoreException(6, "Negative position " + filePos + " (position=" + pos + ", chunk=" + this + ")");
                }
                int length = DataUtil.getPageMaxLength(pos);
                if (length == 0x200000) {
                    buf = PooledByteBufAllocator.DEFAULT.ioBuffer(128);
                    try {
                        fileStore.readFully(buf, filePos, 128);
                        length = buf.readInt();
                    }
                    finally {
                        buf.release();
                    }
                }
                if ((length = Math.min((int)(maxPos - filePos), length)) < 0) {
                    throw new MVStoreException(6, "Illegal page length " + length + " reading at " + filePos + "; max pos " + maxPos);
                }
                buf = PooledByteBufAllocator.DEFAULT.ioBuffer(length, length);
                boolean fail = true;
                try {
                    fileStore.readFully(buf, filePos, length);
                    fail = false;
                }
                finally {
                    if (fail) {
                        buf.release();
                    }
                }
                if (originalBlock == this.block) {
                    return buf;
                }
                buf.release();
                continue;
            }
            catch (MVStoreException e) {
                if (originalBlock == this.block) throw e;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LongArrayList readToC(FileStore fileStore) {
        assert (this.isSaved()) : this;
        assert (this.tocPos > 0);
        while (true) {
            long originalBlock = this.block;
            int pageCount = this.pageCount;
            int length = pageCount * 8;
            ByteBuf buf = PooledByteBufAllocator.DEFAULT.ioBuffer(length, length);
            try {
                fileStore.readFully(buf, originalBlock * 4096L + (long)this.tocPos, length);
                long[] toc = new long[pageCount];
                DataUtil.readLongArray(toc, buf, pageCount);
                if (originalBlock != this.block) continue;
                LongArrayList longArrayList = LongArrayList.wrap(toc);
                return longArrayList;
            }
            catch (MVStoreException e) {
                if (originalBlock != this.block) continue;
                throw e;
            }
            finally {
                buf.release();
                continue;
            }
            break;
        }
    }

    void accountForWrittenPage(int pageLengthOnDisk, boolean singleWriter) {
        this.maxLen += (long)pageLengthOnDisk;
        ++this.pageCount;
        this.maxLenLive += (long)pageLengthOnDisk;
        if (singleWriter) {
            ++this.pinCount;
        }
    }

    boolean accountForRemovedPage(int pageNo, int pageLength, boolean pinned, long now, long version2) {
        assert (this.isSaved()) : this;
        assert (pageNo >= 0 && pageNo < this.pageCount) : pageNo + " // " + this.pageCount;
        if (this.occupancy == null) {
            this.occupancy = new IntOpenHashSet();
        } else assert (!this.occupancy.contains(pageNo)) : pageNo + " " + this + " " + this.occupancy;
        this.occupancy.add(pageNo);
        this.maxLenLive -= (long)pageLength;
        if (pinned) {
            --this.pinCount;
        }
        if (this.unusedAtVersion < version2) {
            this.unusedAtVersion = version2;
        }
        assert (this.pinCount >= 0) : this;
        assert (this.pinCount <= this.pageCount - this.occupancy.size()) : this;
        assert (this.maxLenLive >= 0L) : this;
        assert (this.pageCount - this.occupancy.size() == 0 == (this.maxLenLive == 0L)) : this;
        if (!this.isLive()) {
            this.unused = now;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Chunk(id=" + this.id + ", mapId=" + this.mapId + ", block=" + this.block + ", blockCount=" + this.blockCount + ", pageCount=" + this.pageCount + ", occupancy=" + this.occupancy + ", tocPos=" + this.tocPos + ", maxLen=" + this.maxLen + ", maxLenLive=" + this.maxLenLive + ", collectPriority=" + this.collectPriority + ", layoutRootPageInfo=" + this.layoutRootPageInfo + ", chunkMapRootPageInfo=" + this.chunkMapRootPageInfo + ", version=" + this.version + ", time=" + this.time + ", unused=" + this.unused + ", unusedAtVersion=" + this.unusedAtVersion + ", next=" + this.next + ", pinCount=" + this.pinCount + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "sqldelight/org/jetbrains/mvstore/Chunk", "writeFooter"));
    }

    static final class PositionComparator
    implements Comparator<Chunk> {
        public static final Comparator<Chunk> INSTANCE = new PositionComparator();

        private PositionComparator() {
        }

        @Override
        public int compare(Chunk one, Chunk two) {
            return Long.compare(one.block, two.block);
        }
    }
}

