/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.mvstore;

import java.nio.ByteBuffer;
import sqldelight.io.netty.buffer.ByteBuf;
import sqldelight.io.netty.buffer.PooledByteBufAllocator;
import sqldelight.it.unimi.dsi.fastutil.longs.LongArrayList;
import sqldelight.org.jetbrains.integratedBinaryPacking.IntBitPacker;
import sqldelight.org.jetbrains.mvstore.Chunk;
import sqldelight.org.jetbrains.mvstore.CursorPos;
import sqldelight.org.jetbrains.mvstore.DataUtil;
import sqldelight.org.jetbrains.mvstore.KeyManager;
import sqldelight.org.jetbrains.mvstore.MVMap;
import sqldelight.org.jetbrains.mvstore.MVStore;
import sqldelight.org.jetbrains.mvstore.Page;
import sqldelight.org.jetbrains.mvstore.type.DataType;
import sqldelight.org.jetbrains.mvstore.type.KeyableDataType;

final class LeafPage<K, V>
extends Page<K, V> {
    private V[] values;

    LeafPage(MVMap<K, V> map, ByteBuf buf, long info, int chunkId) {
        super(map, info, buf, chunkId);
    }

    LeafPage(MVMap<K, V> map, KeyManager<K> keyManager, V[] values, int memory) {
        super(map, keyManager, memory);
        assert (values.length == keyManager.getKeyCount());
        this.values = values;
    }

    private V[] createValueStorage(int size) {
        return this.map.getValueType().createStorage(size);
    }

    @Override
    public int getNodeType() {
        return 0;
    }

    @Override
    public Page<K, V> copy(MVMap<K, V> map) {
        return new LeafPage<K, V>(map, this.keyManager, this.values, this.memory);
    }

    @Override
    public Page<K, V> getChildPage(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getChildPagePos(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V getValue(int index) {
        return this.values[index];
    }

    @Override
    public Page<K, V> split(int at, boolean left) {
        KeyManager newKeys = left ? this.keyManager.copy(0, at, this.map) : this.keyManager.copy(at, this.keyManager.getKeyCount(), this.map);
        V[] newValues = this.map.getValueType().createStorage(newKeys.getKeyCount());
        System.arraycopy(this.values, left ? 0 : at, newValues, 0, newValues.length);
        return new LeafPage(this.map, newKeys, newValues, 22 + this.map.getValueType().getMemory(newValues));
    }

    public static <K, V> LeafPage<K, V> expand(LeafPage<K, V> source, int extraKeyCount, K[] extraKeys, V[] extraValues) {
        MVMap map = source.map;
        int currentKeyCount = source.keyManager.getKeyCount();
        V[] newValues = source.createValueStorage(currentKeyCount + extraKeyCount);
        System.arraycopy(source.values, 0, newValues, 0, currentKeyCount);
        System.arraycopy(extraValues, 0, newValues, currentKeyCount, extraKeyCount);
        return new LeafPage<K, V>(map, source.keyManager.expandKeys(extraKeyCount, extraKeys, map), newValues, source.memory + map.getValueType().getMemory(extraValues));
    }

    @Override
    public long getTotalCount() {
        return this.getKeyCount();
    }

    @Override
    long getCounts(int index) {
        throw new UnsupportedOperationException();
    }

    static <K, V> LeafPage<K, V> replaceValue(LeafPage<K, V> source, int index, V value) {
        Object[] newValues = (Object[])source.values.clone();
        newValues[index] = value;
        DataType valueType = source.map.getValueType();
        return new LeafPage<K, Object>(source.map, source.keyManager, newValues, source.memory + (valueType.getMemory(value) - valueType.getMemory(source.values[index])));
    }

    static <K, V> LeafPage<K, V> add(LeafPage<K, V> source, int index, K key, V value) {
        MVMap map = source.map;
        DataType valueType = map.getValueType();
        int newKeyCount = source.keyManager.getKeyCount() + 1;
        V[] newValues = valueType.createStorage(newKeyCount);
        DataUtil.copyWithGap(source.values, newValues, source.values.length, index);
        newValues[index] = value;
        return new LeafPage(map, source.keyManager.insertKey(index, key, map), newValues, source.memory + valueType.getMemory(value));
    }

    @Override
    public Page<K, V> remove(int index) {
        int oldKeyCount = this.keyManager.getKeyCount();
        DataType valueType = this.map.getValueType();
        V[] newValues = valueType.createStorage(oldKeyCount - 1);
        DataUtil.copyExcept(this.values, newValues, oldKeyCount, index);
        return new LeafPage(this.map, this.keyManager.remove(index == oldKeyCount ? index - 1 : index, this.map), newValues, this.memory - valueType.getMemory(this.values[index]));
    }

    @Override
    public int removeAllRecursive(long version2) {
        return this.removePage(version2);
    }

    @Override
    public CursorPos<K, V> getPrependCursorPos(CursorPos<K, V> cursorPos) {
        return new CursorPos<K, V>(this, -1, cursorPos);
    }

    @Override
    public CursorPos<K, V> getAppendCursorPos(CursorPos<K, V> cursorPos) {
        int keyCount = this.getKeyCount();
        return new CursorPos<K, V>(this, ~keyCount, cursorPos);
    }

    @Override
    protected void writePayload(ByteBuf buf, int keyCount) {
        MVStore store;
        int compressionLevel;
        int dataStart = buf.writerIndex();
        int typePosition = dataStart - 1;
        this.keyManager.write(keyCount, this.map, buf);
        if (!this.map.getKeyType().isGenericCompressionApplicable()) {
            dataStart = buf.writerIndex();
        }
        this.map.getValueType().write(buf, this.values, keyCount);
        int uncompressedLength = buf.writerIndex() - dataStart;
        if (uncompressedLength > 256 && (compressionLevel = (store = this.map.getStore()).getCompressionLevel()) > 0) {
            LeafPage.compressData(buf, 0, typePosition, dataStart, store, uncompressedLength, compressionLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected KeyManager<K> readPayload(ByteBuf buf, int keyCount, boolean isCompressed, int pageLength, int pageStartReaderIndex) {
        KeyableDataType keyType = this.map.getKeyType();
        KeyManager keyManager = null;
        if (!isCompressed || !keyType.isGenericCompressionApplicable()) {
            keyManager = keyType.createManager(buf, keyCount);
        }
        if (!isCompressed) {
            this.readValues(buf, keyCount);
            return keyManager;
        }
        int sizeDiff = IntBitPacker.readVar(buf);
        int compressedStart = buf.readerIndex();
        int compressedLength = pageLength - (compressedStart - pageStartReaderIndex);
        int decompressedLength = compressedLength + sizeDiff;
        ByteBuf uncompressed = PooledByteBufAllocator.DEFAULT.buffer(decompressedLength, decompressedLength);
        try {
            ByteBuffer inNioBuf = DataUtil.getNioBuffer(buf, compressedStart, compressedLength);
            this.map.getStore().getDecompressor().decompress(inNioBuf, uncompressed.internalNioBuffer(0, decompressedLength));
            uncompressed.writerIndex(decompressedLength);
            if (keyType.isGenericCompressionApplicable()) {
                keyManager = keyType.createManager(uncompressed, keyCount);
            }
            this.readValues(uncompressed, keyCount);
            buf.readerIndex(compressedStart + compressedLength);
        }
        finally {
            uncompressed.release();
        }
        return keyManager;
    }

    private void readValues(ByteBuf buf, int keyCount) {
        DataType valueType = this.map.getValueType();
        this.values = valueType.createStorage(keyCount);
        valueType.read(buf, this.values, keyCount);
    }

    @Override
    protected int calculateMemory() {
        return 22 + this.map.getValueType().getMemory(this.values);
    }

    @Override
    void writeUnsavedRecursive(Chunk chunk, ByteBuf buf, LongArrayList toc) {
        if (!this.isSaved()) {
            this.write(chunk, buf, toc);
        }
    }

    @Override
    void releaseSavedPages() {
    }

    @Override
    public int getRawChildPageCount() {
        return 0;
    }

    @Override
    public void dump(StringBuilder buff) {
        super.dump(buff);
        int keyCount = this.getKeyCount();
        buff.append(", keyCount=").append(keyCount);
        if (keyCount == 0) {
            return;
        }
        buff.append(", content: \n");
        for (int i = 0; i < keyCount; ++i) {
            if (i > 0) {
                buff.append(' ');
            }
            buff.append(this.keyManager.getKey(i));
            if (this.values == null) continue;
            buff.append(':');
            buff.append(this.getValue(i));
        }
    }
}

