/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.mvstore;

import java.nio.ByteBuffer;
import java.util.Arrays;
import sqldelight.io.netty.buffer.ByteBuf;
import sqldelight.io.netty.buffer.PooledByteBufAllocator;
import sqldelight.it.unimi.dsi.fastutil.longs.LongArrayList;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.integratedBinaryPacking.IntBitPacker;
import sqldelight.org.jetbrains.integratedBinaryPacking.LongBitPacker;
import sqldelight.org.jetbrains.mvstore.Chunk;
import sqldelight.org.jetbrains.mvstore.CursorPos;
import sqldelight.org.jetbrains.mvstore.DataUtil;
import sqldelight.org.jetbrains.mvstore.KeyManager;
import sqldelight.org.jetbrains.mvstore.MVMap;
import sqldelight.org.jetbrains.mvstore.MVStore;
import sqldelight.org.jetbrains.mvstore.Page;

class NonLeafPage<K, V>
extends Page<K, V> {
    private static final int CHILD_METADATA_SIZE = 17;
    private Page.PageReference<K, V>[] children;
    private long totalCount;

    NonLeafPage(MVMap<K, V> map, ByteBuf buf, long info, int chunkId) {
        super(map, info, buf, chunkId);
    }

    NonLeafPage(@NotNull MVMap<K, V> map, @NotNull KeyManager<K> keyManager, int memory, Page.PageReference<K, V>[] children2, long totalCount) {
        if (map == null) {
            NonLeafPage.$$$reportNull$$$0(0);
        }
        if (keyManager == null) {
            NonLeafPage.$$$reportNull$$$0(1);
        }
        super(map, keyManager, memory);
        this.children = children2;
        this.totalCount = totalCount;
        if (MVStore.ASSERT_MODE) {
            assert (children2.length - keyManager.getKeyCount() == 1);
            assert (totalCount == this.calculateTotalCount());
        }
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    @Override
    public Page<K, V> copy(MVMap<K, V> map) {
        return new IncompleteNonLeaf<K, V>(map, this);
    }

    @Override
    public Page<K, V> getChildPage(int index) {
        Page.PageReference<K, V> ref = this.children[index];
        Page<K, V> page = ref.getPage();
        if (page == null) {
            page = this.map.getStore().readPage(this.map, ref.getPos());
            assert (ref.getPos() == page.getPosition());
            assert (ref.totalCount == page.getTotalCount());
        }
        return page;
    }

    @Override
    public long getChildPagePos(int index) {
        return this.children[index].getPos();
    }

    @Override
    public V getValue(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page<K, V> split(int at, boolean left) {
        KeyManager newKeys = left ? this.keyManager.copy(0, at, this.map) : this.keyManager.copy(at + 1, this.keyManager.getKeyCount(), this.map);
        Page.PageReference<K, V>[] newChildren = NonLeafPage.createRefStorage(newKeys.getKeyCount() + 1);
        System.arraycopy(this.children, left ? 0 : at + 1, newChildren, 0, newChildren.length);
        long totalCount = 0L;
        for (Page.PageReference child : newChildren) {
            totalCount += child.totalCount;
        }
        return new NonLeafPage(this.map, newKeys, NonLeafPage.calculateSerializedDataSize(newChildren.length), newChildren, totalCount);
    }

    @Override
    public long getTotalCount() {
        if (MVStore.ASSERT_MODE) assert (!this.isComplete() || this.totalCount == this.calculateTotalCount()) : "Total count: " + this.totalCount + " != " + this.calculateTotalCount();
        return this.totalCount;
    }

    private long calculateTotalCount() {
        long result = 0L;
        for (Page.PageReference<K, V> child : this.children) {
            result += child.totalCount;
        }
        return result;
    }

    void recalculateTotalCount() {
        this.totalCount = this.calculateTotalCount();
    }

    @Override
    long getCounts(int index) {
        return this.children[index].totalCount;
    }

    void setChild(int index, Page<K, V> c) {
        assert (c != null);
        Page.PageReference<K, V> child = this.children[index];
        if (c != child.getPage() || c.getPosition() != child.getPos()) {
            this.totalCount += c.getTotalCount() - child.totalCount;
            this.children = (Page.PageReference[])this.children.clone();
            this.children[index] = new Page.PageReference<K, V>(c);
        }
    }

    static <K, V> NonLeafPage<K, V> replaceChild(NonLeafPage<K, V> source, int index, Page<K, V> child) {
        Page.PageReference<K, V> oldChildRef = source.children[index];
        Page.PageReference<K, V>[] newChildren = source.children;
        if (child != oldChildRef.getPage() || child.getPosition() != oldChildRef.getPos()) {
            newChildren = (Page.PageReference[])newChildren.clone();
            newChildren[index] = new Page.PageReference<K, V>(child);
        }
        return new NonLeafPage<K, V>(source.map, source.keyManager, source.memory, newChildren, source.totalCount - oldChildRef.totalCount + child.getTotalCount());
    }

    static <K, V> NonLeafPage<K, V> replaceSplitChild(NonLeafPage<K, V> parentPage, int index, K key, Page<K, V> leftChildPage, Page<K, V> rightChildPage) {
        Page.PageReference<K, V> oldChildRef = parentPage.children[index];
        Page.PageReference<K, V>[] newChildren = NonLeafPage.createRefStorage(parentPage.children.length + 1);
        DataUtil.copyWithGap(parentPage.children, newChildren, parentPage.children.length, index);
        newChildren[index] = new Page.PageReference<K, V>(leftChildPage);
        newChildren[index + 1] = new Page.PageReference<K, V>(rightChildPage);
        long newTotalCount = parentPage.totalCount - oldChildRef.totalCount + leftChildPage.getTotalCount() + rightChildPage.getTotalCount();
        MVMap map = parentPage.map;
        KeyManager<K> newKeyManager = parentPage.keyManager.insertKey(index, key, map);
        return new NonLeafPage(map, newKeyManager, parentPage.memory + 17, newChildren, newTotalCount);
    }

    @Override
    public Page<K, V> remove(int index) {
        int currentChildCount = this.getRawChildPageCount();
        Page.PageReference<K, V>[] newChildren = NonLeafPage.createRefStorage(currentChildCount - 1);
        DataUtil.copyExcept(this.children, newChildren, currentChildCount, index);
        KeyManager newKeyManager = this.keyManager.remove(index == this.keyManager.getKeyCount() ? index - 1 : index, this.map);
        return new NonLeafPage(this.map, newKeyManager, this.memory - 17, newChildren, this.totalCount - this.children[index].totalCount);
    }

    @Override
    public int removeAllRecursive(long version2) {
        int unsavedMemory = this.removePage(version2);
        if (this.isPersistent()) {
            int size = this.map.getChildPageCount(this);
            for (int i = 0; i < size; ++i) {
                Page.PageReference<K, V> ref = this.children[i];
                Page<K, V> page = ref.getPage();
                if (page != null) {
                    unsavedMemory += page.removeAllRecursive(version2);
                    continue;
                }
                long pagePos = ref.getPos();
                assert (DataUtil.isPageSaved(pagePos));
                if (DataUtil.isLeafPage(pagePos)) {
                    this.map.getStore().accountForRemovedPage(pagePos, version2, this.map.isSingleWriter(), -1);
                    continue;
                }
                unsavedMemory += this.map.getStore().readPage(this.map, pagePos).removeAllRecursive(version2);
            }
        }
        return unsavedMemory;
    }

    @Override
    public CursorPos<K, V> getPrependCursorPos(CursorPos<K, V> cursorPos) {
        Page<K, V> childPage = this.getChildPage(0);
        return childPage.getPrependCursorPos(new CursorPos<K, V>(this, 0, cursorPos));
    }

    @Override
    public CursorPos<K, V> getAppendCursorPos(CursorPos<K, V> cursorPos) {
        int keyCount = this.getKeyCount();
        Page<K, V> childPage = this.getChildPage(keyCount);
        return childPage.getAppendCursorPos(new CursorPos<K, V>(this, keyCount, cursorPos));
    }

    @Override
    protected void writePayload(ByteBuf buf, int keyCount) {
        MVStore store;
        int compressionLevel;
        int dataStart = buf.writerIndex();
        int typePosition = dataStart - 1;
        for (int i = 0; i <= keyCount; ++i) {
            Page.PageReference<K, V> child = this.children[i];
            long info = child.getPos();
            buf.writeLong(info);
            if (info == 0L) continue;
            LongBitPacker.writeVar(buf, child.totalCount);
        }
        this.keyManager.write(keyCount, this.map, buf);
        if (!this.map.getKeyType().isGenericCompressionApplicable()) {
            return;
        }
        int uncompressedLength = buf.writerIndex() - dataStart;
        if (uncompressedLength > 256 && (compressionLevel = (store = this.map.getStore()).getCompressionLevel()) > 0) {
            NonLeafPage.compressData(buf, 1, typePosition, dataStart, store, uncompressedLength, compressionLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected KeyManager<K> readPayload(ByteBuf buf, int keyCount, boolean isCompressed, int pageLength, int pageStartReaderIndex) {
        this.children = NonLeafPage.createRefStorage(keyCount + 1);
        if (!isCompressed) {
            return this.doReadPayload(buf, keyCount);
        }
        int sizeDiff = IntBitPacker.readVar(buf);
        int compressedStart = buf.readerIndex();
        int compressedLength = pageLength - (compressedStart - pageStartReaderIndex);
        int decompressedLength = compressedLength + sizeDiff;
        ByteBuf uncompressed = PooledByteBufAllocator.DEFAULT.buffer(decompressedLength, decompressedLength);
        try {
            ByteBuffer inNioBuf = DataUtil.getNioBuffer(buf, compressedStart, compressedLength);
            this.map.getStore().getDecompressor().decompress(inNioBuf, uncompressed.internalNioBuffer(0, decompressedLength));
            uncompressed.writerIndex(decompressedLength);
            KeyManager<K> keyManager = this.doReadPayload(uncompressed, keyCount);
            buf.readerIndex(compressedStart + compressedLength);
            KeyManager<K> keyManager2 = keyManager;
            return keyManager2;
        }
        finally {
            uncompressed.release();
        }
    }

    private KeyManager<K> doReadPayload(ByteBuf buf, int keyCount) {
        long total = 0L;
        for (int i = 0; i <= keyCount; ++i) {
            long info = buf.readLong();
            if (info == 0L) {
                this.children[i] = Page.PageReference.empty();
                continue;
            }
            long childTotalCount = LongBitPacker.readVar(buf);
            this.children[i] = new Page.PageReference(info, childTotalCount);
            total += childTotalCount;
        }
        this.totalCount = total;
        return this.map.getKeyType().createManager(buf, keyCount);
    }

    @Override
    protected int calculateMemory() {
        return NonLeafPage.calculateSerializedDataSize(this.getRawChildPageCount());
    }

    static int calculateSerializedDataSize(int childCount) {
        return 22 + childCount * 17;
    }

    @Override
    void writeUnsavedRecursive(Chunk chunk, ByteBuf buf, LongArrayList toc) {
        if (!this.isSaved()) {
            this.writeChildrenRecursive(chunk, buf, toc);
            this.write(chunk, buf, toc);
        }
    }

    void writeChildrenRecursive(Chunk chunk, ByteBuf buf, LongArrayList toc) {
        int len = this.getRawChildPageCount();
        for (int i = 0; i < len; ++i) {
            Page.PageReference<K, V> ref = this.children[i];
            Page<K, V> p = ref.getPage();
            if (p == null) continue;
            p.writeUnsavedRecursive(chunk, buf, toc);
            ref.resetPos();
        }
    }

    @Override
    public int getUnsavedMemory() {
        if (this.isSaved()) {
            return 0;
        }
        int result = this.memory;
        for (Page.PageReference<K, V> childRef : this.children) {
            Page<K, V> childPage = childRef.getPage();
            if (childPage == null) continue;
            result += childPage.getUnsavedMemory();
        }
        return result;
    }

    @Override
    void releaseSavedPages() {
        int len = this.getRawChildPageCount();
        for (int i = 0; i < len; ++i) {
            this.children[i].clearPageReference();
        }
    }

    @Override
    public int getRawChildPageCount() {
        return this.keyManager.getKeyCount() + 1;
    }

    @Override
    public void dump(StringBuilder buff) {
        super.dump(buff);
        int keyCount = this.getKeyCount();
        for (int i = 0; i <= keyCount; ++i) {
            if (i > 0) {
                buff.append(" ");
            }
            buff.append('[').append(Long.toHexString(this.children[i].getPos())).append(']');
            if (i >= keyCount) continue;
            buff.append(' ').append(this.keyManager.getKey(i));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "map";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "keyManager";
                break;
            }
        }
        objectArray[1] = "sqldelight/org/jetbrains/mvstore/NonLeafPage";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class IncompleteNonLeaf<K, V>
    extends NonLeafPage<K, V> {
        private boolean complete;

        private IncompleteNonLeaf(MVMap<K, V> map, NonLeafPage<K, V> source) {
            super(map, source.keyManager, source.memory, IncompleteNonLeaf.constructEmptyPageRefs(source.getRawChildPageCount()), source.getTotalCount());
        }

        private static <K, V> Page.PageReference<K, V>[] constructEmptyPageRefs(int size) {
            Object[] children2 = IncompleteNonLeaf.createRefStorage(size);
            Arrays.fill(children2, Page.PageReference.empty());
            return children2;
        }

        @Override
        void writeUnsavedRecursive(Chunk chunk, ByteBuf buf, LongArrayList toc) {
            if (this.complete) {
                super.writeUnsavedRecursive(chunk, buf, toc);
            } else if (!this.isSaved()) {
                this.writeChildrenRecursive(chunk, buf, toc);
            }
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public void setComplete() {
            this.recalculateTotalCount();
            this.complete = true;
        }

        @Override
        public void dump(StringBuilder buff) {
            super.dump(buff);
            buff.append(", complete=").append(this.complete);
        }
    }
}

