/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.mvstore.type;

import sqldelight.io.netty.buffer.ByteBuf;
import sqldelight.io.netty.buffer.ByteBufUtil;
import sqldelight.io.netty.util.AsciiString;
import sqldelight.org.jetbrains.integratedBinaryPacking.IntBitPacker;
import sqldelight.org.jetbrains.mvstore.type.KeyableDataType;

public final class AsciiStringDataType
implements KeyableDataType<AsciiString> {
    public static final KeyableDataType<AsciiString> INSTANCE = new AsciiStringDataType();

    private AsciiStringDataType() {
    }

    public AsciiString[] createStorage(int size) {
        return new AsciiString[size];
    }

    @Override
    public int compare(AsciiString a, AsciiString b) {
        return a.compareTo(b);
    }

    @Override
    public int getMemory(AsciiString obj) {
        return 5 + obj.length();
    }

    @Override
    public int getFixedMemory() {
        return -1;
    }

    @Override
    public AsciiString read(ByteBuf buf) {
        int length = IntBitPacker.readVar(buf);
        int readerIndex = buf.readerIndex();
        AsciiString result = new AsciiString(ByteBufUtil.getBytes(buf, readerIndex, length, true), false);
        buf.readerIndex(readerIndex + length);
        return result;
    }

    @Override
    public void write(ByteBuf buf, AsciiString s) {
        int length = s.length();
        IntBitPacker.writeVar(buf, length);
        buf.writeBytes(s.array(), s.arrayOffset(), length);
    }
}

