/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.mvstore.type;

import java.util.Arrays;
import sqldelight.io.netty.buffer.ByteBuf;
import sqldelight.org.jetbrains.mvstore.DataUtil;
import sqldelight.org.jetbrains.mvstore.type.KeyableDataType;

public final class ByteArrayDataType
implements KeyableDataType<byte[]> {
    public static final ByteArrayDataType INSTANCE = new ByteArrayDataType();

    private ByteArrayDataType() {
    }

    @Override
    public boolean equals(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    @Override
    public int compare(byte[] a, byte[] b) {
        return Arrays.compare(a, b);
    }

    public byte[][] createStorage(int size) {
        return new byte[size][];
    }

    @Override
    public int getMemory(byte[] obj) {
        return 5 + obj.length;
    }

    @Override
    public int getFixedMemory() {
        return -1;
    }

    @Override
    public byte[] read(ByteBuf buf) {
        return DataUtil.readByteArray(buf);
    }

    @Override
    public void write(ByteBuf buf, byte[] value) {
        DataUtil.writeByteArray(buf, value);
    }
}

