/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.mvstore.type;

import java.util.Arrays;
import sqldelight.io.netty.buffer.ByteBuf;
import sqldelight.io.netty.buffer.ByteBufUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.mvstore.KeyManager;
import sqldelight.org.jetbrains.mvstore.type.ContiguousByteArrayKeyManager;
import sqldelight.org.jetbrains.mvstore.type.KeyableDataType;

public final class FixedByteArrayDataType
implements KeyableDataType<byte[]> {
    private final int length;

    public FixedByteArrayDataType(int length) {
        this.length = length;
    }

    @Override
    public boolean equals(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    @Override
    public int compare(byte[] a, byte[] b) {
        return Arrays.compare(a, b);
    }

    public byte[][] createStorage(int size) {
        return new byte[size][];
    }

    @Override
    public int getMemory(byte[] obj) {
        return this.length;
    }

    @Override
    public int getFixedMemory() {
        return this.length;
    }

    public void read(ByteBuf buf, byte[][] storage, int len) {
        int readerIndex = buf.readerIndex();
        for (int i = 0; i < len; ++i) {
            storage[i] = ByteBufUtil.getBytes(buf, readerIndex, this.length);
            readerIndex += this.length;
        }
        buf.readerIndex(readerIndex);
    }

    @Override
    public byte[] read(ByteBuf buf) {
        throw new IllegalStateException();
    }

    @Override
    public void write(ByteBuf buf, byte[] value) {
        assert (value.length == this.length);
        buf.writeBytes(value);
    }

    @Override
    @NotNull
    public KeyManager<byte[]> createManager(ByteBuf buf, int count) {
        int dataLength = count * this.length;
        byte[] data = ByteBufUtil.getBytes(buf, buf.readerIndex(), dataLength);
        buf.readerIndex(buf.readerIndex() + dataLength);
        return new ContiguousByteArrayKeyManager(data, count, this.length);
    }
}

