/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.mvstore.type;

import sqldelight.io.netty.buffer.ByteBuf;
import sqldelight.org.jetbrains.integratedBinaryPacking.IntegratedBinaryPacking;
import sqldelight.org.jetbrains.mvstore.DataUtil;
import sqldelight.org.jetbrains.mvstore.KeyManager;
import sqldelight.org.jetbrains.mvstore.MVMap;
import sqldelight.org.jetbrains.mvstore.MVStore;

final class IntKeyManager
implements KeyManager<Integer> {
    static final int[] EMPTY_ARRAY = new int[0];
    private final int[] keys;

    IntKeyManager(int[] keys) {
        if (MVStore.ASSERT_MODE) {
            for (int i = 1; i < keys.length; ++i) {
                if (keys[i] <= keys[i - 1]) {
                    throw new AssertionError((Object)(keys[i] + " <= " + keys[i - 1]));
                }
            }
        }
        this.keys = keys;
    }

    IntKeyManager(ByteBuf buf, int count) {
        if (count == 0) {
            this.keys = EMPTY_ARRAY;
            return;
        }
        this.keys = new int[count];
        DataUtil.unpackInts(this.keys, buf);
    }

    @Override
    public int getKeyCount() {
        return this.keys.length;
    }

    @Override
    public Integer getKey(int index) {
        return this.keys[index];
    }

    @Override
    public int binarySearch(Integer key, MVMap<Integer, ?> map, int initialGuess) {
        int length = this.keys.length;
        if (length == 0) {
            return -1;
        }
        int low = 0;
        int high = length - 1;
        int x = initialGuess - 1;
        if (x < 0 || x > high) {
            x = high >>> 1;
        }
        return IntKeyManager.binarySearch(key, this.keys, low, high, x);
    }

    private static int binarySearch(int key, int[] storage, int low, int high, int x) {
        while (low <= high) {
            int midVal = storage[x];
            if (key > midVal) {
                low = x + 1;
            } else if (key < midVal) {
                high = x - 1;
            } else {
                return x;
            }
            x = low + high >>> 1;
        }
        return -(low + 1);
    }

    public IntKeyManager expandKeys(int extraKeyCount, Integer[] extraKeys, MVMap<Integer, ?> map) {
        int keyCount = this.keys.length;
        int[] newKeys = new int[keyCount + extraKeyCount];
        System.arraycopy(this.keys, 0, newKeys, 0, keyCount);
        System.arraycopy(extraKeys, 0, newKeys, keyCount, extraKeyCount);
        return new IntKeyManager(newKeys);
    }

    @Override
    public KeyManager<Integer> copy(int startIndex, int endIndex, MVMap<Integer, ?> map) {
        int[] newKeys = new int[endIndex - startIndex];
        System.arraycopy(this.keys, startIndex, newKeys, 0, newKeys.length);
        return new IntKeyManager(newKeys);
    }

    @Override
    public KeyManager<Integer> insertKey(int index, Integer key, MVMap<Integer, ?> map) {
        int keyCount = this.keys.length;
        assert (index <= keyCount) : index + " > " + keyCount;
        int[] newKeys = new int[keyCount + 1];
        DataUtil.copyWithGap(this.keys, newKeys, keyCount, index);
        newKeys[index] = key;
        return new IntKeyManager(newKeys);
    }

    @Override
    public KeyManager<Integer> remove(int index, MVMap<Integer, ?> map) {
        int keyCount = this.keys.length;
        if (keyCount == 1) {
            return new IntKeyManager(EMPTY_ARRAY);
        }
        int[] newKeys = new int[keyCount - 1];
        DataUtil.copyExcept(this.keys, newKeys, keyCount, index);
        return new IntKeyManager(newKeys);
    }

    @Override
    public void write(int count, MVMap<Integer, ?> map, ByteBuf buf) {
        if (count != 0) {
            DataUtil.packInts(this.keys, buf);
        }
    }

    @Override
    public int getSerializedDataSize() {
        int count = this.keys.length;
        if (count == 0) {
            return 0;
        }
        int variableEncodingLength = count % 32;
        int result = variableEncodingLength * 5;
        if (count == variableEncodingLength) {
            return result;
        }
        return result + IntegratedBinaryPacking.estimateCompressedArrayLength(this.keys, variableEncodingLength, count, variableEncodingLength == 0 ? 0 : this.keys[variableEncodingLength - 1]);
    }
}

