/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.mvstore.type;

import sqldelight.io.netty.buffer.ByteBuf;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.integratedBinaryPacking.LongBitPacker;
import sqldelight.org.jetbrains.mvstore.KeyManager;
import sqldelight.org.jetbrains.mvstore.MVMap;
import sqldelight.org.jetbrains.mvstore.type.KeyableDataType;
import sqldelight.org.jetbrains.mvstore.type.LongKeyManager;

public final class LongDataType
implements KeyableDataType<Long> {
    public static final LongDataType INSTANCE = new LongDataType();

    private LongDataType() {
    }

    @Override
    public int getMemory(Long obj) {
        return this.getFixedMemory();
    }

    @Override
    public int getFixedMemory() {
        return 8;
    }

    @Override
    public void write(ByteBuf buff, Long data) {
        LongBitPacker.writeVar(buff, data);
    }

    @Override
    public Long read(ByteBuf buff) {
        return LongBitPacker.readVar(buff);
    }

    public Long[] createStorage(int size) {
        return new Long[size];
    }

    @Override
    public int compare(Long one, Long two) {
        return Long.compare(one, two);
    }

    @Override
    @NotNull
    public KeyManager<Long> createEmptyManager(@NotNull MVMap<Long, ?> map) {
        if (map == null) {
            LongDataType.$$$reportNull$$$0(0);
        }
        return new LongKeyManager(LongKeyManager.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public KeyManager<Long> createManager(ByteBuf buf, int count) {
        return new LongKeyManager(buf, count);
    }

    @Override
    public boolean isGenericCompressionApplicable() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "sqldelight/org/jetbrains/mvstore/type/LongDataType", "createEmptyManager"));
    }
}

