/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.xxh3;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import sqldelight.org.jetbrains.xxh3.ByteArrayAccess;
import sqldelight.org.jetbrains.xxh3.Xxh3Impl;

final class StringHash {
    private static final MethodHandle valueGetter;
    private static final boolean enableCompactStrings;

    StringHash() {
    }

    static long longHash(String s, int offset, int length, long seed) {
        byte[] value;
        int totalLength = s.length();
        try {
            value = valueGetter.invokeExact(s);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (enableCompactStrings && value.length == totalLength) {
            return Xxh3Impl.hash(value, ByteArrayAccess.INSTANCE, offset, length, seed);
        }
        byte[] data = s.substring(offset, offset + length).getBytes(StandardCharsets.UTF_8);
        return Xxh3Impl.hash(data, ByteArrayAccess.INSTANCE, 0, data.length, seed);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(String.class, MethodHandles.lookup());
            valueGetter = lookup.findGetter(String.class, "value", byte[].class);
            byte[] value = valueGetter.invokeExact("A");
            enableCompactStrings = value.length == 1;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

