/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.xxh3;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.IntUnaryOperator;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.xxh3.Access;
import sqldelight.org.jetbrains.xxh3.ByteArrayAccess;
import sqldelight.org.jetbrains.xxh3.CharSequenceAccess;
import sqldelight.org.jetbrains.xxh3.StringHash;
import sqldelight.org.jetbrains.xxh3.Xxh3Impl;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class Xxh3 {
    private static final IntUnaryOperator H2LE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? IntUnaryOperator.identity() : Integer::reverseBytes;

    public static long hash(byte[] input) {
        return Xxh3Impl.hash(input, ByteArrayAccess.INSTANCE, 0, input.length, 0L);
    }

    public static long hash(byte[] input, int offset, int length) {
        return Xxh3Impl.hash(input, ByteArrayAccess.INSTANCE, offset, length, 0L);
    }

    public static long hash(@NotNull ByteBuffer input) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(0);
        }
        return Xxh3.hash(input, input.position(), input.remaining());
    }

    public static long hash(@NotNull ByteBuffer input, int offset, int length) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(1);
        }
        if (input.hasArray()) {
            return Xxh3Impl.hash(input.array(), ByteArrayAccess.INSTANCE, input.arrayOffset() + offset, length, 0L);
        }
        return Xxh3Impl.hash(input, ByteBufferAccess.INSTANCE, offset, length, 0L);
    }

    public static int hash32(byte[] input) {
        return (int)Xxh3.hash(input);
    }

    public static long hash(String input) {
        return StringHash.longHash(input, 0, input.length(), 0L);
    }

    public static long seededHash(String input, long seed) {
        return StringHash.longHash(input, 0, input.length(), seed);
    }

    public static long seededHash(byte[] input, long seed) {
        return Xxh3Impl.hash(input, ByteArrayAccess.INSTANCE, 0, input.length, seed);
    }

    public static long hash(String input, int start, int length) {
        return StringHash.longHash(input, start, length, 0L);
    }

    public static int hash32(String input) {
        return (int)Xxh3.hash(input);
    }

    public static long hashUnencodedChars(CharSequence input) {
        return Xxh3Impl.hash(input, CharSequenceAccess.INSTANCE, 0, input.length() * 2, 0L);
    }

    public static int hashUnencodedChars32(CharSequence input) {
        return (int)Xxh3.hashUnencodedChars(input);
    }

    public static long hashRange(String input, int start, int end) {
        return StringHash.longHash(input, start, end - start, 0L);
    }

    public static long hashLongs(long[] input) {
        return Xxh3Impl.hash(input, LongArrayAccessForLongs.INSTANCE, 0, input.length * 8, 0L);
    }

    public static long hashInt(int input, long seed) {
        input = H2LE.applyAsInt(input);
        long s = seed ^ Long.reverseBytes(seed & 0xFFFFFFFFL);
        long bitFlip = -4090762196417718878L - s;
        long keyed = ((long)input & 0xFFFFFFFFL) + ((long)input << 32) ^ bitFlip;
        return Xxh3Impl.rrmxmx(keyed, 4L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "sqldelight/org/jetbrains/xxh3/Xxh3", "hash"));
    }

    private static final class LongArrayAccessForLongs
    extends Access<long[]> {
        static final LongArrayAccessForLongs INSTANCE = new LongArrayAccessForLongs();

        private LongArrayAccessForLongs() {
        }

        @Override
        public long i64(long[] input, int offset) {
            return input[offset >> 3];
        }

        @Override
        public int i32(long[] input, int offset) {
            long v = input[offset >> 3];
            return (offset & 7) == 0 ? (int)(v >> 32) : (int)v;
        }

        @Override
        protected int i8(long[] input, int offset) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ByteBufferAccess
    extends Access<ByteBuffer> {
        private static final VarHandle LONG_HANDLE = MethodHandles.byteBufferViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
        private static final VarHandle INT_HANDLE = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
        @NotNull
        static final Access<ByteBuffer> INSTANCE = new ByteBufferAccess();

        private ByteBufferAccess() {
        }

        @Override
        public long i64(ByteBuffer input, int offset) {
            return LONG_HANDLE.get(input, offset);
        }

        @Override
        public int i32(ByteBuffer input, int offset) {
            return INT_HANDLE.get(input, offset);
        }

        @Override
        public int i8(ByteBuffer input, int offset) {
            return input.get(offset);
        }
    }
}

