/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.tukaani.xz.simple;

import sqldelight.org.tukaani.xz.simple.SimpleFilter;

public final class X86
implements SimpleFilter {
    private static final boolean[] MASK_TO_ALLOWED_STATUS = new boolean[]{true, true, true, false, true, false, false, false};
    private static final int[] MASK_TO_BIT_NUMBER = new int[]{0, 1, 2, 2, 3, 3, 3, 3};
    private final boolean isEncoder;
    private int pos;
    private int prevMask = 0;

    private static boolean test86MSByte(byte by) {
        int n = by & 0xFF;
        return n == 0 || n == 255;
    }

    public X86(boolean bl, int n) {
        this.isEncoder = bl;
        this.pos = n + 5;
    }

    @Override
    public int code(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n - 1;
        int n5 = n + n2 - 5;
        for (n3 = n; n3 <= n5; ++n3) {
            if ((byArray[n3] & 0xFE) != 232) continue;
            if (((n4 = n3 - n4) & 0xFFFFFFFC) != 0) {
                this.prevMask = 0;
            } else {
                this.prevMask = this.prevMask << n4 - 1 & 7;
                if (this.prevMask != 0 && (!MASK_TO_ALLOWED_STATUS[this.prevMask] || X86.test86MSByte(byArray[n3 + 4 - MASK_TO_BIT_NUMBER[this.prevMask]]))) {
                    n4 = n3;
                    this.prevMask = this.prevMask << 1 | 1;
                    continue;
                }
            }
            n4 = n3;
            if (X86.test86MSByte(byArray[n3 + 4])) {
                int n6;
                int n7 = byArray[n3 + 1] & 0xFF | (byArray[n3 + 2] & 0xFF) << 8 | (byArray[n3 + 3] & 0xFF) << 16 | (byArray[n3 + 4] & 0xFF) << 24;
                while (true) {
                    int n8;
                    n6 = this.isEncoder ? n7 + (this.pos + n3 - n) : n7 - (this.pos + n3 - n);
                    if (this.prevMask == 0 || !X86.test86MSByte((byte)(n6 >>> 24 - (n8 = MASK_TO_BIT_NUMBER[this.prevMask] * 8)))) break;
                    n7 = n6 ^ (1 << 32 - n8) - 1;
                }
                byArray[n3 + 1] = (byte)n6;
                byArray[n3 + 2] = (byte)(n6 >>> 8);
                byArray[n3 + 3] = (byte)(n6 >>> 16);
                byArray[n3 + 4] = (byte)(~((n6 >>> 24 & 1) - 1));
                n3 += 4;
                continue;
            }
            this.prevMask = this.prevMask << 1 | 1;
        }
        this.prevMask = ((n4 = n3 - n4) & 0xFFFFFFFC) != 0 ? 0 : this.prevMask << n4 - 1;
        this.pos += (n3 -= n);
        return n3;
    }
}

