[runtime](../../index.md) / [com.squareup.sqldelight.db](../index.md) / [Closeable](./index.md)

# Closeable

`expect interface Closeable`

**Platform and version requirements:** JVM, js, native

A type that can be closed.

### Functions

| Name | Summary |
|---|---|
| [close](close.md)<br>(js, native) | `abstract fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Close any resources backed by this object. |

### Extension Functions

| Name | Summary |
|---|---|
| [use](../use.md)<br>(JVM, js, native) | `expect fun <T : `[`Closeable`](./index.md)`?, R> `[`T`](../use.md#T)`.use(body: (`[`T`](../use.md#T)`) -> `[`R`](../use.md#R)`): `[`R`](../use.md#R)<br>Run [body](../use.md#com.squareup.sqldelight.db$use(com.squareup.sqldelight.db.use.T, kotlin.Function1((com.squareup.sqldelight.db.use.T, com.squareup.sqldelight.db.use.R)))/body) on the receiver and call [Closeable.close](close.md) before returning or throwing. |

### Inheritors

| Name | Summary |
|---|---|
| [SqlCursor](../-sql-cursor/index.md) | `interface SqlCursor : `[`Closeable`](./index.md)<br>Represents a SQL result set which can be iterated through with [next](../-sql-cursor/next.md). Initially the cursor will not point to any row, and calling [next](../-sql-cursor/next.md) once will iterate to the first row. |
| [SqlDriver](../-sql-driver/index.md) | `interface SqlDriver : `[`Closeable`](./index.md)<br>Maintains connections to an underlying SQL database and provides APIs for managing transactions and executing SQL statements. |
