[runtime](../../index.md) / [com.squareup.sqldelight.db](../index.md) / [SqlPreparedStatement](./index.md)

# SqlPreparedStatement

`interface SqlPreparedStatement`

Represents a SQL statement that has been prepared by a driver to be executed.

This type is not thread safe unless otherwise specified by the driver emitting these.

Prepared statements should not be cached by client code. Drivers can implement caching by using
the integer identifier passed to [SqlDriver.execute](../-sql-driver/execute.md) or [SqlDriver.executeQuery](../-sql-driver/execute-query.md).
Client code can pass the same identifier to that method to request that the prepared statement
is cached.

### Functions

| Name | Summary |
|---|---|
| [bindBytes](bind-bytes.md) | `abstract fun bindBytes(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, bytes: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Bind [bytes](bind-bytes.md#com.squareup.sqldelight.db.SqlPreparedStatement$bindBytes(kotlin.Int, kotlin.ByteArray)/bytes) to the underlying statement at [index](bind-bytes.md#com.squareup.sqldelight.db.SqlPreparedStatement$bindBytes(kotlin.Int, kotlin.ByteArray)/index). |
| [bindDouble](bind-double.md) | `abstract fun bindDouble(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, double: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Bind [double](bind-double.md#com.squareup.sqldelight.db.SqlPreparedStatement$bindDouble(kotlin.Int, kotlin.Double)/double) to the underlying statement at [index](bind-double.md#com.squareup.sqldelight.db.SqlPreparedStatement$bindDouble(kotlin.Int, kotlin.Double)/index). |
| [bindLong](bind-long.md) | `abstract fun bindLong(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, long: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Bind [long](bind-long.md#com.squareup.sqldelight.db.SqlPreparedStatement$bindLong(kotlin.Int, kotlin.Long)/long) to the underlying statement at [index](bind-long.md#com.squareup.sqldelight.db.SqlPreparedStatement$bindLong(kotlin.Int, kotlin.Long)/index). |
| [bindString](bind-string.md) | `abstract fun bindString(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Bind [string](bind-string.md#com.squareup.sqldelight.db.SqlPreparedStatement$bindString(kotlin.Int, kotlin.String)/string) to the underlying statement at [index](bind-string.md#com.squareup.sqldelight.db.SqlPreparedStatement$bindString(kotlin.Int, kotlin.String)/index). |

### Inheritors

| Name | Summary |
|---|---|
| [StatementParameterInterceptor](../../com.squareup.sqldelight.logs/-statement-parameter-interceptor/index.md) | `class StatementParameterInterceptor : `[`SqlPreparedStatement`](./index.md) |
