[runtime](../../index.md) / [com.squareup.sqldelight](../index.md) / [TransacterImpl](./index.md)

# TransacterImpl

`abstract class TransacterImpl : `[`Transacter`](../-transacter/index.md)

A transaction-aware [SqlDriver](../../com.squareup.sqldelight.db/-sql-driver/index.md) wrapper which can begin a [Transaction](../-transacter/-transaction/index.md) on the current connection.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `TransacterImpl(driver: `[`SqlDriver`](../../com.squareup.sqldelight.db/-sql-driver/index.md)`)`<br>A transaction-aware [SqlDriver](../../com.squareup.sqldelight.db/-sql-driver/index.md) wrapper which can begin a [Transaction](../-transacter/-transaction/index.md) on the current connection. |

### Functions

| Name | Summary |
|---|---|
| [createArguments](create-arguments.md) | `fun createArguments(count: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>For internal use, creates a string in the format (?, ?, ?) where there are [count](create-arguments.md#com.squareup.sqldelight.TransacterImpl$createArguments(kotlin.Int)/count) offset. |
| [notifyQueries](notify-queries.md) | `fun notifyQueries(identifier: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, queryList: () -> `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Query`](../-query/index.md)`<*>>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>For internal use, notifies the listeners of [queryList](notify-queries.md#com.squareup.sqldelight.TransacterImpl$notifyQueries(kotlin.Int, kotlin.Function0((kotlin.collections.List((com.squareup.sqldelight.Query((kotlin.Any)))))))/queryList) that their underlying result set has changed. |
| [transaction](transaction.md) | `open fun transaction(noEnclosing: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`, body: `[`TransactionWithoutReturn`](../-transaction-without-return/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Starts a [Transaction](../-transacter/-transaction/index.md) and runs [body](../-transacter/transaction.md#com.squareup.sqldelight.Transacter$transaction(kotlin.Boolean, kotlin.Function1((com.squareup.sqldelight.TransactionWithoutReturn, kotlin.Unit)))/body) in that transaction. |
| [transactionWithResult](transaction-with-result.md) | `open fun <R> transactionWithResult(noEnclosing: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`, bodyWithReturn: `[`TransactionWithReturn`](../-transaction-with-return/index.md)`<`[`R`](transaction-with-result.md#R)`>.() -> `[`R`](transaction-with-result.md#R)`): `[`R`](transaction-with-result.md#R)<br>Starts a [Transaction](../-transacter/-transaction/index.md) and runs [body](#) in that transaction. |
