
package com.squareup.square.http.client;

import com.squareup.square.http.request.HttpRequest;

/**
 * Callback to be called before and after the HTTP call for an endpoint is made.
 */
public interface HttpCallback {

    /**
     * Callback called just before the HTTP request is sent.
     * @param request The HTTP request to be executed
     */
    public void onBeforeRequest(HttpRequest request);
    
    /**
     * Callback called just after the HTTP response is received.
     * @param context Context for the HTTP call
     */
    public void onAfterResponse(HttpContext context);
}