/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.request.MultipartFileWrapper;
import com.squareup.square.http.request.MultipartWrapper;
import com.squareup.square.utilities.JsonObject;
import com.squareup.square.utilities.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ApiHelper {
    public static ObjectMapper mapper = new ObjectMapper(){
        private static final long serialVersionUID = -174113593500315394L;
        {
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.configOverride(BigDecimal.class).setFormat(JsonFormat.Value.forShape((JsonFormat.Shape)JsonFormat.Shape.STRING));
        }
    };
    private static final Set<Object> WRAPPER_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, String.class, Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, Void.class, File.class, MultipartWrapper.class, MultipartFileWrapper.class));

    private static JsonSerializer getSerializer(JsonSerialize serializerAnnotation) {
        try {
            return (JsonSerializer)serializerAnnotation.using().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static JsonSerializer getCollectionSerializer(JsonSerialize serializerAnnotation) {
        try {
            return (JsonSerializer)serializerAnnotation.contentUsing().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String serialize(Object obj) throws JsonProcessingException {
        if (obj == null) {
            return null;
        }
        return mapper.writeValueAsString(obj);
    }

    public static String serialize(Object obj, JsonSerializer serializer) throws JsonProcessingException {
        if (obj == null || serializer == null) {
            return null;
        }
        Class<?> cls = null;
        cls = obj.getClass().getName().equals("java.util.ArrayList") ? ((ArrayList)obj).get(0).getClass() : (obj.getClass().getName().equals("java.util.LinkedHashMap") ? ((LinkedHashMap)obj).values().toArray()[0].getClass() : obj.getClass());
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(cls, serializer);
        mapper.registerModule((Module)module);
        return mapper.writeValueAsString(obj);
    }

    public static <T> T deserialize(String json, Class<T> clazz) throws IOException {
        if (ApiHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return (T)mapper.readValue(json, clazz);
    }

    public static LinkedHashMap<String, Object> deserialize(String json) throws IOException {
        if (ApiHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
        return ApiHelper.deserialize(json, typeRef);
    }

    public static <T> T deserialize(String json, TypeReference<T> typeReference) throws IOException {
        if (ApiHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return (T)mapper.readValue(json, typeReference);
    }

    public static Object deserializeAsObject(String json) {
        if (ApiHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        try {
            return ApiHelper.deserialize(json, new TypeReference<Object>(){});
        }
        catch (IOException e) {
            return json;
        }
    }

    public static <T> List<T> deserializeArray(String json, Class<T[]> classArray) throws IOException {
        if (ApiHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return Arrays.asList((Object[])mapper.readValue(json, classArray));
    }

    public static void populate(String json, ApiException obj) throws IOException {
        if (!ApiHelper.isNullOrWhiteSpace(json)) {
            mapper.readerForUpdating((Object)obj).readValue(json);
        }
    }

    public static void appendUrlWithTemplateParameters(StringBuilder queryBuilder, Map<String, AbstractMap.SimpleEntry<Object, Boolean>> parameters) {
        if (null == queryBuilder) {
            throw new IllegalArgumentException("Given value for parameter \"queryBuilder\" is invalid.");
        }
        if (null == parameters) {
            return;
        }
        for (Map.Entry<String, AbstractMap.SimpleEntry<Object, Boolean>> pair : parameters.entrySet()) {
            String replaceValue = "";
            Object element = pair.getValue().getKey();
            boolean shouldEncode = pair.getValue().getValue();
            replaceValue = null == element ? "" : (element instanceof Collection ? ApiHelper.flattenCollection("", (Collection)element, shouldEncode, "%s%s%s", '/') : (shouldEncode ? ApiHelper.tryUrlEncode(element.toString(), false) : element.toString()));
            ApiHelper.replaceAll(queryBuilder, "{" + pair.getKey() + "}", replaceValue);
        }
    }

    public static void appendUrlWithQueryParameters(StringBuilder queryBuilder, Map<String, Object> parameters) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("Given value for parameter \"queryBuilder\" is invalid.");
        }
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        boolean hasParams = queryBuilder.indexOf("?") > 0;
        queryBuilder.append(hasParams ? (char)'&' : '?');
        ApiHelper.encodeObjectAsQueryString("", parameters, queryBuilder);
    }

    public static boolean isNullOrWhiteSpace(String s) {
        if (s == null) {
            return true;
        }
        int length = s.length();
        if (length > 0) {
            int start = 0;
            int middle = length / 2;
            int end = length - 1;
            while (start <= middle) {
                if (s.charAt(start) > ' ' || s.charAt(end) > ' ') {
                    return false;
                }
                ++start;
                --end;
            }
            return true;
        }
        return false;
    }

    public static void replaceAll(StringBuilder stringBuilder, String toReplace, String replaceWith) {
        int index = stringBuilder.indexOf(toReplace);
        while (index != -1) {
            stringBuilder.replace(index, index + toReplace.length(), replaceWith);
            index += replaceWith.length();
            index = stringBuilder.indexOf(toReplace, index);
        }
    }

    public static void removeNullValues(Map<String, ?> map) {
        if (map == null) {
            return;
        }
        map.values().removeAll(Collections.singleton(null));
    }

    public static String cleanUrl(StringBuilder url) {
        Pattern pattern = Pattern.compile("^(https?://[^/]+)");
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid Url format.");
        }
        String protocol = matcher.group(1);
        String query = url.substring(protocol.length());
        query = query.replaceAll("//+", "/");
        return protocol.concat(query);
    }

    public static List<AbstractMap.SimpleEntry<String, Object>> prepareFormFields(Map<?, ?> value) {
        ArrayList<AbstractMap.SimpleEntry<String, Object>> formFields = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();
        if (value != null) {
            ApiHelper.objectToList("", value, formFields, new HashSet<Integer>());
        }
        return formFields;
    }

    private static void encodeObjectAsQueryString(String name, Object obj, StringBuilder objBuilder) {
        if (obj == null) {
            return;
        }
        ArrayList<AbstractMap.SimpleEntry<String, Object>> objectList = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();
        ApiHelper.objectToList(name, obj, objectList, new HashSet<Integer>());
        boolean hasParam = false;
        for (AbstractMap.SimpleEntry simpleEntry : objectList) {
            String accessor = (String)simpleEntry.getKey();
            Object value = simpleEntry.getValue();
            if (value == null) continue;
            hasParam = true;
            String paramKeyValPair = String.format("%s=%s&", accessor, ApiHelper.tryUrlEncode(value.toString(), false));
            objBuilder.append(paramKeyValPair);
        }
        if (hasParam) {
            objBuilder.setLength(objBuilder.length() - 1);
        }
    }

    private static String flattenCollection(String elemName, Collection<?> array, boolean encode, String fmt, char separator) {
        StringBuilder builder = new StringBuilder();
        for (Object element : array) {
            String elemValue = null;
            elemValue = element == null ? "" : element.toString();
            if (encode) {
                elemValue = ApiHelper.tryUrlEncode(elemValue, false);
            }
            builder.append(String.format(fmt, elemName, elemValue, Character.valueOf(separator)));
        }
        if (builder.length() > 1 && builder.charAt(builder.length() - 1) == separator) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String tryUrlEncode(String value, boolean spaceAsPercentEncoded) {
        try {
            String encodedUrl = URLEncoder.encode(value, "UTF-8");
            if (spaceAsPercentEncoded) {
                return encodedUrl.replace("+", "%20");
            }
            return encodedUrl;
        }
        catch (UnsupportedEncodingException ex) {
            return value;
        }
    }

    private static void objectToList(String objName, Collection<?> obj, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed) {
        Collection<?> array = obj;
        array = ApiHelper.sortByWrapperType(array);
        int index = 0;
        for (Object element : array) {
            String key = String.format("%s[%d]", objName, index++);
            ApiHelper.loadKeyValuePairForEncoding(key, element, objectList, processed);
        }
    }

    private static void objectToList(String objName, Map<?, ?> obj, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed) {
        Map<?, ?> map = obj;
        for (Map.Entry<?, ?> pair : map.entrySet()) {
            String attribName = pair.getKey().toString();
            if (objName != null && !objName.isEmpty()) {
                attribName = String.format("%s[%s]", objName, attribName);
            }
            ApiHelper.loadKeyValuePairForEncoding(attribName, pair.getValue(), objectList, processed);
        }
    }

    private static void objectToList(String objName, Object obj, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed) {
        if (obj == null) {
            return;
        }
        Class<?> clazz = obj.getClass();
        if (!ApiHelper.isWrapperType(clazz)) {
            if (processed.contains(objName.hashCode())) {
                return;
            }
            processed.add(objName.hashCode());
        }
        if (obj instanceof Collection) {
            ApiHelper.objectToList(objName, (Collection)obj, objectList, processed);
        } else if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            int index = 0;
            for (Object element : array) {
                String key = String.format("%s[%d]", objName, index++);
                ApiHelper.loadKeyValuePairForEncoding(key, element, objectList, processed);
            }
        } else if (obj instanceof Map) {
            ApiHelper.objectToList(objName, (Map)obj, objectList, processed);
        } else {
            while (clazz != null) {
                for (Method method : clazz.getDeclaredMethods()) {
                    JsonGetter getterAnnotation;
                    if (method.getParameterTypes().length != 0 || Modifier.isPrivate(method.getModifiers()) || !method.getName().startsWith("get") && !method.getName().startsWith("internalGet") || (getterAnnotation = method.getAnnotation(JsonGetter.class)) == null) continue;
                    String attribName = getterAnnotation.value();
                    if (objName != null && !objName.isEmpty()) {
                        attribName = String.format("%s[%s]", objName, attribName);
                    }
                    try {
                        method.setAccessible(true);
                        Object value = method.invoke(obj, new Object[0]);
                        JsonSerialize serializerAnnotation = method.getAnnotation(JsonSerialize.class);
                        if (serializerAnnotation != null) {
                            ApiHelper.loadKeyValuePairForEncoding(attribName, value, objectList, processed, serializerAnnotation);
                            continue;
                        }
                        ApiHelper.loadKeyValuePairForEncoding(attribName, value, objectList, processed);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                        // empty catch block
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
    }

    private static Collection<?> sortByWrapperType(Collection<?> array) {
        return array.stream().sorted(Comparator.comparing(element -> {
            if (ApiHelper.isWrapperType(element)) {
                return 1;
            }
            return -1;
        })).collect(Collectors.toList());
    }

    private static void loadKeyValuePairForEncoding(String key, Object value, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed) {
        if (value == null) {
            return;
        }
        if (ApiHelper.isWrapperType(value)) {
            objectList.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
        } else if (value.getClass().equals(JsonObject.class)) {
            ApiHelper.objectToList(key, ((JsonObject)value).getStoredObject(), objectList, processed);
        } else if (value.getClass().equals(JsonValue.class)) {
            Object storedValue = ((JsonValue)value).getStoredObject();
            if (ApiHelper.isWrapperType(storedValue)) {
                objectList.add(new AbstractMap.SimpleEntry<String, Object>(key, storedValue));
            } else {
                ApiHelper.objectToList(key, storedValue, objectList, processed);
            }
        } else if (value instanceof UUID) {
            objectList.add(new AbstractMap.SimpleEntry<String, String>(key, value.toString()));
        } else {
            ApiHelper.objectToList(key, value, objectList, processed);
        }
    }

    private static void loadKeyValuePairForEncoding(String key, Object value, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed, JsonSerialize serializerAnnotation) {
        if (value == null) {
            return;
        }
        try {
            Object obj;
            JsonSerializer serializer = ApiHelper.getSerializer(serializerAnnotation);
            if (serializer == null) {
                serializer = ApiHelper.getCollectionSerializer(serializerAnnotation);
            }
            if ((obj = ApiHelper.deserializeAsObject((value = ApiHelper.serialize(value, serializer)).toString())) instanceof List || obj instanceof Map) {
                ApiHelper.loadKeyValuePairForEncoding(key, obj, objectList, processed);
            } else {
                if (value.toString().startsWith("\"")) {
                    value = value.toString().substring(1, value.toString().length() - 1);
                }
                objectList.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private static boolean isWrapperType(Object object) {
        return WRAPPER_TYPES.contains(object.getClass()) || object.getClass().isPrimitive() || object.getClass().isEnum();
    }
}

