/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.BearerAuthCredentials;
import com.squareup.square.BearerAuthManager;
import com.squareup.square.Environment;
import com.squareup.square.Server;
import com.squareup.square.SquareClientInterface;
import com.squareup.square.api.ApplePayApi;
import com.squareup.square.api.BankAccountsApi;
import com.squareup.square.api.BookingsApi;
import com.squareup.square.api.CardsApi;
import com.squareup.square.api.CashDrawersApi;
import com.squareup.square.api.CatalogApi;
import com.squareup.square.api.CheckoutApi;
import com.squareup.square.api.CustomerCustomAttributesApi;
import com.squareup.square.api.CustomerGroupsApi;
import com.squareup.square.api.CustomerSegmentsApi;
import com.squareup.square.api.CustomersApi;
import com.squareup.square.api.DefaultApplePayApi;
import com.squareup.square.api.DefaultBankAccountsApi;
import com.squareup.square.api.DefaultBookingsApi;
import com.squareup.square.api.DefaultCardsApi;
import com.squareup.square.api.DefaultCashDrawersApi;
import com.squareup.square.api.DefaultCatalogApi;
import com.squareup.square.api.DefaultCheckoutApi;
import com.squareup.square.api.DefaultCustomerCustomAttributesApi;
import com.squareup.square.api.DefaultCustomerGroupsApi;
import com.squareup.square.api.DefaultCustomerSegmentsApi;
import com.squareup.square.api.DefaultCustomersApi;
import com.squareup.square.api.DefaultDevicesApi;
import com.squareup.square.api.DefaultDisputesApi;
import com.squareup.square.api.DefaultEmployeesApi;
import com.squareup.square.api.DefaultGiftCardActivitiesApi;
import com.squareup.square.api.DefaultGiftCardsApi;
import com.squareup.square.api.DefaultInventoryApi;
import com.squareup.square.api.DefaultInvoicesApi;
import com.squareup.square.api.DefaultLaborApi;
import com.squareup.square.api.DefaultLocationsApi;
import com.squareup.square.api.DefaultLoyaltyApi;
import com.squareup.square.api.DefaultMerchantsApi;
import com.squareup.square.api.DefaultMobileAuthorizationApi;
import com.squareup.square.api.DefaultOAuthApi;
import com.squareup.square.api.DefaultOrdersApi;
import com.squareup.square.api.DefaultPaymentsApi;
import com.squareup.square.api.DefaultPayoutsApi;
import com.squareup.square.api.DefaultRefundsApi;
import com.squareup.square.api.DefaultSitesApi;
import com.squareup.square.api.DefaultSnippetsApi;
import com.squareup.square.api.DefaultSubscriptionsApi;
import com.squareup.square.api.DefaultTeamApi;
import com.squareup.square.api.DefaultTerminalApi;
import com.squareup.square.api.DefaultTransactionsApi;
import com.squareup.square.api.DefaultV1TransactionsApi;
import com.squareup.square.api.DefaultVendorsApi;
import com.squareup.square.api.DevicesApi;
import com.squareup.square.api.DisputesApi;
import com.squareup.square.api.EmployeesApi;
import com.squareup.square.api.GiftCardActivitiesApi;
import com.squareup.square.api.GiftCardsApi;
import com.squareup.square.api.InventoryApi;
import com.squareup.square.api.InvoicesApi;
import com.squareup.square.api.LaborApi;
import com.squareup.square.api.LocationsApi;
import com.squareup.square.api.LoyaltyApi;
import com.squareup.square.api.MerchantsApi;
import com.squareup.square.api.MobileAuthorizationApi;
import com.squareup.square.api.OAuthApi;
import com.squareup.square.api.OrdersApi;
import com.squareup.square.api.PaymentsApi;
import com.squareup.square.api.PayoutsApi;
import com.squareup.square.api.RefundsApi;
import com.squareup.square.api.SitesApi;
import com.squareup.square.api.SnippetsApi;
import com.squareup.square.api.SubscriptionsApi;
import com.squareup.square.api.TeamApi;
import com.squareup.square.api.TerminalApi;
import com.squareup.square.api.TransactionsApi;
import com.squareup.square.api.V1TransactionsApi;
import com.squareup.square.api.VendorsApi;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpClientConfiguration;
import com.squareup.square.http.client.OkClient;
import com.squareup.square.http.client.ReadonlyHttpClientConfiguration;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public final class SquareClient
implements SquareClientInterface {
    private MobileAuthorizationApi mobileAuthorization;
    private OAuthApi oAuth;
    private V1TransactionsApi v1Transactions;
    private ApplePayApi applePay;
    private BankAccountsApi bankAccounts;
    private BookingsApi bookings;
    private CardsApi cards;
    private CashDrawersApi cashDrawers;
    private CatalogApi catalog;
    private CustomersApi customers;
    private CustomerCustomAttributesApi customerCustomAttributes;
    private CustomerGroupsApi customerGroups;
    private CustomerSegmentsApi customerSegments;
    private DevicesApi devices;
    private DisputesApi disputes;
    private EmployeesApi employees;
    private GiftCardsApi giftCards;
    private GiftCardActivitiesApi giftCardActivities;
    private InventoryApi inventory;
    private InvoicesApi invoices;
    private LaborApi labor;
    private LocationsApi locations;
    private CheckoutApi checkout;
    private TransactionsApi transactions;
    private LoyaltyApi loyalty;
    private MerchantsApi merchants;
    private OrdersApi orders;
    private PaymentsApi payments;
    private PayoutsApi payouts;
    private RefundsApi refunds;
    private SitesApi sites;
    private SnippetsApi snippets;
    private SubscriptionsApi subscriptions;
    private TeamApi team;
    private TerminalApi terminal;
    private VendorsApi vendors;
    private final Environment environment;
    private final String customUrl;
    private final String squareVersion;
    private final HttpClient httpClient;
    private final ReadonlyHttpClientConfiguration httpClientConfig;
    private final Headers additionalHeaders;
    private final String userAgentDetail;
    private BearerAuthManager bearerAuthManager;
    private Map<String, AuthManager> authManagers;
    private final HttpCallback httpCallback;

    private SquareClient(Environment environment, String customUrl, String squareVersion, HttpClient httpClient, ReadonlyHttpClientConfiguration httpClientConfig, Headers additionalHeaders, String userAgentDetail, String accessToken, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        this.environment = environment;
        this.customUrl = customUrl;
        this.squareVersion = squareVersion;
        this.httpClient = httpClient;
        this.httpClientConfig = httpClientConfig;
        this.additionalHeaders = additionalHeaders;
        this.userAgentDetail = userAgentDetail;
        this.httpCallback = httpCallback;
        Map<String, AuthManager> map = this.authManagers = authManagers == null ? new HashMap<String, AuthManager>() : new HashMap<String, AuthManager>(authManagers);
        if (this.authManagers.containsKey("global")) {
            this.bearerAuthManager = (BearerAuthManager)this.authManagers.get("global");
        }
        if (!this.authManagers.containsKey("global") || !this.getBearerAuthCredentials().equals(accessToken)) {
            this.bearerAuthManager = new BearerAuthManager(accessToken);
            this.authManagers.put("global", this.bearerAuthManager);
        }
        this.mobileAuthorization = new DefaultMobileAuthorizationApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.oAuth = new DefaultOAuthApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.v1Transactions = new DefaultV1TransactionsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.applePay = new DefaultApplePayApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.bankAccounts = new DefaultBankAccountsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.bookings = new DefaultBookingsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.cards = new DefaultCardsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.cashDrawers = new DefaultCashDrawersApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.catalog = new DefaultCatalogApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.customers = new DefaultCustomersApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.customerCustomAttributes = new DefaultCustomerCustomAttributesApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.customerGroups = new DefaultCustomerGroupsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.customerSegments = new DefaultCustomerSegmentsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.devices = new DefaultDevicesApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.disputes = new DefaultDisputesApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.employees = new DefaultEmployeesApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.giftCards = new DefaultGiftCardsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.giftCardActivities = new DefaultGiftCardActivitiesApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.inventory = new DefaultInventoryApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.invoices = new DefaultInvoicesApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.labor = new DefaultLaborApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.locations = new DefaultLocationsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.checkout = new DefaultCheckoutApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.transactions = new DefaultTransactionsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.loyalty = new DefaultLoyaltyApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.merchants = new DefaultMerchantsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.orders = new DefaultOrdersApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.payments = new DefaultPaymentsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.payouts = new DefaultPayoutsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.refunds = new DefaultRefundsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.sites = new DefaultSitesApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.snippets = new DefaultSnippetsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.subscriptions = new DefaultSubscriptionsApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.team = new DefaultTeamApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.terminal = new DefaultTerminalApi(this, this.httpClient, this.authManagers, this.httpCallback);
        this.vendors = new DefaultVendorsApi(this, this.httpClient, this.authManagers, this.httpCallback);
    }

    public static void shutdown() {
        OkClient.shutdown();
    }

    @Override
    public MobileAuthorizationApi getMobileAuthorizationApi() {
        return this.mobileAuthorization;
    }

    @Override
    public OAuthApi getOAuthApi() {
        return this.oAuth;
    }

    @Override
    public V1TransactionsApi getV1TransactionsApi() {
        return this.v1Transactions;
    }

    @Override
    public ApplePayApi getApplePayApi() {
        return this.applePay;
    }

    @Override
    public BankAccountsApi getBankAccountsApi() {
        return this.bankAccounts;
    }

    @Override
    public BookingsApi getBookingsApi() {
        return this.bookings;
    }

    @Override
    public CardsApi getCardsApi() {
        return this.cards;
    }

    @Override
    public CashDrawersApi getCashDrawersApi() {
        return this.cashDrawers;
    }

    @Override
    public CatalogApi getCatalogApi() {
        return this.catalog;
    }

    @Override
    public CustomersApi getCustomersApi() {
        return this.customers;
    }

    @Override
    public CustomerCustomAttributesApi getCustomerCustomAttributesApi() {
        return this.customerCustomAttributes;
    }

    @Override
    public CustomerGroupsApi getCustomerGroupsApi() {
        return this.customerGroups;
    }

    @Override
    public CustomerSegmentsApi getCustomerSegmentsApi() {
        return this.customerSegments;
    }

    @Override
    public DevicesApi getDevicesApi() {
        return this.devices;
    }

    @Override
    public DisputesApi getDisputesApi() {
        return this.disputes;
    }

    @Override
    public EmployeesApi getEmployeesApi() {
        return this.employees;
    }

    @Override
    public GiftCardsApi getGiftCardsApi() {
        return this.giftCards;
    }

    @Override
    public GiftCardActivitiesApi getGiftCardActivitiesApi() {
        return this.giftCardActivities;
    }

    @Override
    public InventoryApi getInventoryApi() {
        return this.inventory;
    }

    @Override
    public InvoicesApi getInvoicesApi() {
        return this.invoices;
    }

    @Override
    public LaborApi getLaborApi() {
        return this.labor;
    }

    @Override
    public LocationsApi getLocationsApi() {
        return this.locations;
    }

    @Override
    public CheckoutApi getCheckoutApi() {
        return this.checkout;
    }

    @Override
    public TransactionsApi getTransactionsApi() {
        return this.transactions;
    }

    @Override
    public LoyaltyApi getLoyaltyApi() {
        return this.loyalty;
    }

    @Override
    public MerchantsApi getMerchantsApi() {
        return this.merchants;
    }

    @Override
    public OrdersApi getOrdersApi() {
        return this.orders;
    }

    @Override
    public PaymentsApi getPaymentsApi() {
        return this.payments;
    }

    @Override
    public PayoutsApi getPayoutsApi() {
        return this.payouts;
    }

    @Override
    public RefundsApi getRefundsApi() {
        return this.refunds;
    }

    @Override
    public SitesApi getSitesApi() {
        return this.sites;
    }

    @Override
    public SnippetsApi getSnippetsApi() {
        return this.snippets;
    }

    @Override
    public SubscriptionsApi getSubscriptionsApi() {
        return this.subscriptions;
    }

    @Override
    public TeamApi getTeamApi() {
        return this.team;
    }

    @Override
    public TerminalApi getTerminalApi() {
        return this.terminal;
    }

    @Override
    public VendorsApi getVendorsApi() {
        return this.vendors;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public String getCustomUrl() {
        return this.customUrl;
    }

    @Override
    public String getSquareVersion() {
        return this.squareVersion;
    }

    private HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public ReadonlyHttpClientConfiguration getHttpClientConfig() {
        return this.httpClientConfig;
    }

    @Override
    public Headers getAdditionalHeaders() {
        return new Headers(this.additionalHeaders);
    }

    @Override
    public String getUserAgentDetail() {
        return this.userAgentDetail;
    }

    private BearerAuthCredentials getBearerAuthCredentials() {
        return this.bearerAuthManager;
    }

    @Override
    public String getAccessToken() {
        return this.getBearerAuthCredentials().getAccessToken();
    }

    @Override
    public String getSdkVersion() {
        return "20.0.0.20220512";
    }

    @Override
    @Deprecated
    public long timeout() {
        return this.httpClientConfig.getTimeout();
    }

    @Override
    public String getBaseUri(Server server) {
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> parameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        parameters.put("custom_url", new AbstractMap.SimpleEntry<String, Boolean>(this.customUrl, false));
        StringBuilder baseUrl = new StringBuilder(SquareClient.environmentMapper(this.environment, server));
        ApiHelper.appendUrlWithTemplateParameters(baseUrl, parameters);
        return baseUrl.toString();
    }

    @Override
    public String getBaseUri() {
        return this.getBaseUri(Server.ENUM_DEFAULT);
    }

    private static String environmentMapper(Environment environment, Server server) {
        if (environment.equals((Object)Environment.PRODUCTION) && server.equals((Object)Server.ENUM_DEFAULT)) {
            return "https://connect.squareup.com";
        }
        if (environment.equals((Object)Environment.SANDBOX) && server.equals((Object)Server.ENUM_DEFAULT)) {
            return "https://connect.squareupsandbox.com";
        }
        if (environment.equals((Object)Environment.CUSTOM) && server.equals((Object)Server.ENUM_DEFAULT)) {
            return "{custom_url}";
        }
        return "https://connect.squareup.com";
    }

    public String toString() {
        return "SquareClient [environment=" + (Object)((Object)this.environment) + ", customUrl=" + this.customUrl + ", squareVersion=" + this.squareVersion + ", httpClientConfig=" + this.httpClientConfig + ", additionalHeaders=" + this.additionalHeaders + ", userAgentDetail=" + this.userAgentDetail + ", authManagers=" + this.authManagers + "]";
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.environment = this.getEnvironment();
        builder.customUrl = this.getCustomUrl();
        builder.squareVersion = this.getSquareVersion();
        builder.httpClient = this.getHttpClient();
        builder.additionalHeaders = this.getAdditionalHeaders();
        builder.userAgentDetail = this.getUserAgentDetail();
        builder.accessToken = this.getBearerAuthCredentials().getAccessToken();
        builder.authManagers = this.authManagers;
        builder.httpCallback = this.httpCallback;
        builder.httpClientConfig(configBldr -> {
            configBldr = ((HttpClientConfiguration)this.httpClientConfig).newBuilder();
        });
        return builder;
    }

    public static class Builder {
        private Environment environment = Environment.PRODUCTION;
        private String customUrl = "https://connect.squareup.com";
        private String squareVersion = "2022-05-12";
        private HttpClient httpClient;
        private Headers additionalHeaders = new Headers();
        private String userAgentDetail = null;
        private String accessToken = "";
        private Map<String, AuthManager> authManagers = null;
        private HttpCallback httpCallback = null;
        private HttpClientConfiguration.Builder httpClientConfigBuilder = new HttpClientConfiguration.Builder();

        public Builder accessToken(String accessToken) {
            if (accessToken == null) {
                throw new NullPointerException("AccessToken cannot be null.");
            }
            this.accessToken = accessToken;
            return this;
        }

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder customUrl(String customUrl) {
            this.customUrl = customUrl;
            return this;
        }

        public Builder squareVersion(String squareVersion) {
            if (squareVersion == null) {
                throw new NullPointerException("squareVersion cannot be null");
            }
            this.squareVersion = squareVersion;
            return this;
        }

        public Builder additionalHeaders(Headers additionalHeaders) {
            if (additionalHeaders == null) {
                throw new NullPointerException("additionalHeaders cannot be null");
            }
            this.additionalHeaders = additionalHeaders;
            return this;
        }

        public Builder userAgentDetail(String userAgentDetail) {
            if (userAgentDetail != null && userAgentDetail.length() > 128) {
                throw new IllegalArgumentException("The length of user-agent detail should not exceed 128 characters.");
            }
            this.userAgentDetail = userAgentDetail;
            return this;
        }

        @Deprecated
        public Builder timeout(long timeout) {
            this.httpClientConfigBuilder.timeout(timeout);
            return this;
        }

        public Builder httpCallback(HttpCallback httpCallback) {
            this.httpCallback = httpCallback;
            return this;
        }

        public Builder httpClientConfig(Consumer<HttpClientConfiguration.Builder> action) {
            action.accept(this.httpClientConfigBuilder);
            return this;
        }

        public SquareClient build() {
            HttpClientConfiguration httpClientConfig = this.httpClientConfigBuilder.build();
            this.httpClient = new OkClient(httpClientConfig);
            return new SquareClient(this.environment, this.customUrl, this.squareVersion, this.httpClient, httpClientConfig, this.additionalHeaders, this.userAgentDetail, this.accessToken, this.authManagers, this.httpCallback);
        }
    }
}

