/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public abstract class BaseApi {
    protected String internalUserAgent;
    private static String userAgent = "Square-Java-SDK/20.0.0.20220512 ({api-version}) {engine}/{engine-version} ({os-info}) {detail}";
    protected final Configuration config;
    protected final HttpCallback httpCallback;
    protected Map<String, AuthManager> authManagers;
    private HttpClient httpClient;

    protected BaseApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        this(config, httpClient, authManagers, null);
    }

    protected BaseApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        this.config = config;
        this.httpClient = httpClient;
        this.authManagers = authManagers;
        this.httpCallback = httpCallback;
        this.updateUserAgent();
    }

    public HttpCallback getHttpCallback() {
        return this.httpCallback;
    }

    public HttpClient getClientInstance() {
        return this.httpClient;
    }

    protected void validateResponse(HttpResponse response, HttpContext context) throws ApiException {
        int responseCode = response.getStatusCode();
        if (responseCode < 200 || responseCode > 208) {
            throw new ApiException("HTTP Response Not OK", context);
        }
    }

    public <T> CompletableFuture<T> makeHttpCallAsync(RequestSupplier requestSupplier, RequestExecutor requestExecutor, ResponseHandler<T> responseHandler) {
        HttpRequest request;
        try {
            request = requestSupplier.supply();
        }
        catch (Exception e) {
            CompletableFuture futureResponse = new CompletableFuture();
            futureResponse.completeExceptionally(e);
            return futureResponse;
        }
        return requestExecutor.execute(request).thenApplyAsync(response -> {
            HttpContext context = new HttpContext(request, (HttpResponse)response);
            try {
                return responseHandler.handle(context);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    private void updateUserAgent() {
        String engineVersion = System.getProperty("java.runtime.version");
        String osName = System.getProperty("os.name") + "-" + System.getProperty("os.version");
        userAgent = userAgent.replace("{engine}", "JRE");
        userAgent = userAgent.replace("{engine-version}", engineVersion != null ? engineVersion : "");
        userAgent = userAgent.replace("{os-info}", osName != null ? osName : "");
        this.internalUserAgent = userAgent.replace("{api-version}", this.config.getSquareVersion() != null ? this.config.getSquareVersion() : "");
        this.internalUserAgent = this.internalUserAgent.replace("{detail}", this.config.getUserAgentDetail() != null ? ApiHelper.tryUrlEncode(this.config.getUserAgentDetail(), true) : "");
    }

    protected static interface ResponseHandler<T> {
        public T handle(HttpContext var1) throws ApiException, IOException;
    }

    protected static interface RequestExecutor {
        public CompletableFuture<HttpResponse> execute(HttpRequest var1);
    }

    protected static interface RequestSupplier {
        public HttpRequest supply() throws ApiException, IOException;
    }
}

