/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BankAccountsApi;
import com.squareup.square.api.BaseApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.GetBankAccountByV1IdResponse;
import com.squareup.square.models.GetBankAccountResponse;
import com.squareup.square.models.ListBankAccountsResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultBankAccountsApi
extends BaseApi
implements BankAccountsApi {
    public DefaultBankAccountsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultBankAccountsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListBankAccountsResponse listBankAccounts(String cursor, Integer limit, String locationId) throws ApiException, IOException {
        HttpRequest request = this.buildListBankAccountsRequest(cursor, limit, locationId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListBankAccountsResponse(context);
    }

    @Override
    public CompletableFuture<ListBankAccountsResponse> listBankAccountsAsync(String cursor, Integer limit, String locationId) {
        return this.makeHttpCallAsync(() -> this.buildListBankAccountsRequest(cursor, limit, locationId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListBankAccountsResponse(context));
    }

    private HttpRequest buildListBankAccountsRequest(String cursor, Integer limit, String locationId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bank-accounts");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("cursor", cursor);
        queryParameters.put("limit", limit);
        queryParameters.put("location_id", locationId);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListBankAccountsResponse handleListBankAccountsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListBankAccountsResponse result = ApiHelper.deserialize(responseBody, ListBankAccountsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public GetBankAccountByV1IdResponse getBankAccountByV1Id(String v1BankAccountId) throws ApiException, IOException {
        HttpRequest request = this.buildGetBankAccountByV1IdRequest(v1BankAccountId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetBankAccountByV1IdResponse(context);
    }

    @Override
    public CompletableFuture<GetBankAccountByV1IdResponse> getBankAccountByV1IdAsync(String v1BankAccountId) {
        return this.makeHttpCallAsync(() -> this.buildGetBankAccountByV1IdRequest(v1BankAccountId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetBankAccountByV1IdResponse(context));
    }

    private HttpRequest buildGetBankAccountByV1IdRequest(String v1BankAccountId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bank-accounts/by-v1-id/{v1_bank_account_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("v1_bank_account_id", new AbstractMap.SimpleEntry<String, Boolean>(v1BankAccountId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private GetBankAccountByV1IdResponse handleGetBankAccountByV1IdResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        GetBankAccountByV1IdResponse result = ApiHelper.deserialize(responseBody, GetBankAccountByV1IdResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public GetBankAccountResponse getBankAccount(String bankAccountId) throws ApiException, IOException {
        HttpRequest request = this.buildGetBankAccountRequest(bankAccountId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetBankAccountResponse(context);
    }

    @Override
    public CompletableFuture<GetBankAccountResponse> getBankAccountAsync(String bankAccountId) {
        return this.makeHttpCallAsync(() -> this.buildGetBankAccountRequest(bankAccountId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetBankAccountResponse(context));
    }

    private HttpRequest buildGetBankAccountRequest(String bankAccountId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bank-accounts/{bank_account_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("bank_account_id", new AbstractMap.SimpleEntry<String, Boolean>(bankAccountId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private GetBankAccountResponse handleGetBankAccountResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        GetBankAccountResponse result = ApiHelper.deserialize(responseBody, GetBankAccountResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

