/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.BookingsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.CancelBookingRequest;
import com.squareup.square.models.CancelBookingResponse;
import com.squareup.square.models.CreateBookingRequest;
import com.squareup.square.models.CreateBookingResponse;
import com.squareup.square.models.ListBookingsResponse;
import com.squareup.square.models.ListTeamMemberBookingProfilesResponse;
import com.squareup.square.models.RetrieveBookingResponse;
import com.squareup.square.models.RetrieveBusinessBookingProfileResponse;
import com.squareup.square.models.RetrieveTeamMemberBookingProfileResponse;
import com.squareup.square.models.SearchAvailabilityRequest;
import com.squareup.square.models.SearchAvailabilityResponse;
import com.squareup.square.models.UpdateBookingRequest;
import com.squareup.square.models.UpdateBookingResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultBookingsApi
extends BaseApi
implements BookingsApi {
    public DefaultBookingsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultBookingsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListBookingsResponse listBookings(Integer limit, String cursor, String teamMemberId, String locationId, String startAtMin, String startAtMax) throws ApiException, IOException {
        HttpRequest request = this.buildListBookingsRequest(limit, cursor, teamMemberId, locationId, startAtMin, startAtMax);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListBookingsResponse(context);
    }

    @Override
    public CompletableFuture<ListBookingsResponse> listBookingsAsync(Integer limit, String cursor, String teamMemberId, String locationId, String startAtMin, String startAtMax) {
        return this.makeHttpCallAsync(() -> this.buildListBookingsRequest(limit, cursor, teamMemberId, locationId, startAtMin, startAtMax), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListBookingsResponse(context));
    }

    private HttpRequest buildListBookingsRequest(Integer limit, String cursor, String teamMemberId, String locationId, String startAtMin, String startAtMax) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bookings");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("limit", limit);
        queryParameters.put("cursor", cursor);
        queryParameters.put("team_member_id", teamMemberId);
        queryParameters.put("location_id", locationId);
        queryParameters.put("start_at_min", startAtMin);
        queryParameters.put("start_at_max", startAtMax);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListBookingsResponse handleListBookingsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListBookingsResponse result = ApiHelper.deserialize(responseBody, ListBookingsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateBookingResponse createBooking(CreateBookingRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateBookingRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateBookingResponse(context);
    }

    @Override
    public CompletableFuture<CreateBookingResponse> createBookingAsync(CreateBookingRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateBookingRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateBookingResponse(context));
    }

    private HttpRequest buildCreateBookingRequest(CreateBookingRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bookings");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateBookingResponse handleCreateBookingResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateBookingResponse result = ApiHelper.deserialize(responseBody, CreateBookingResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchAvailabilityResponse searchAvailability(SearchAvailabilityRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchAvailabilityRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchAvailabilityResponse(context);
    }

    @Override
    public CompletableFuture<SearchAvailabilityResponse> searchAvailabilityAsync(SearchAvailabilityRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchAvailabilityRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchAvailabilityResponse(context));
    }

    private HttpRequest buildSearchAvailabilityRequest(SearchAvailabilityRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bookings/availability/search");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchAvailabilityResponse handleSearchAvailabilityResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchAvailabilityResponse result = ApiHelper.deserialize(responseBody, SearchAvailabilityResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveBusinessBookingProfileResponse retrieveBusinessBookingProfile() throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveBusinessBookingProfileRequest();
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveBusinessBookingProfileResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveBusinessBookingProfileResponse> retrieveBusinessBookingProfileAsync() {
        return this.makeHttpCallAsync(() -> this.buildRetrieveBusinessBookingProfileRequest(), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveBusinessBookingProfileResponse(context));
    }

    private HttpRequest buildRetrieveBusinessBookingProfileRequest() {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bookings/business-booking-profile");
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveBusinessBookingProfileResponse handleRetrieveBusinessBookingProfileResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveBusinessBookingProfileResponse result = ApiHelper.deserialize(responseBody, RetrieveBusinessBookingProfileResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public ListTeamMemberBookingProfilesResponse listTeamMemberBookingProfiles(Boolean bookableOnly, Integer limit, String cursor, String locationId) throws ApiException, IOException {
        HttpRequest request = this.buildListTeamMemberBookingProfilesRequest(bookableOnly, limit, cursor, locationId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListTeamMemberBookingProfilesResponse(context);
    }

    @Override
    public CompletableFuture<ListTeamMemberBookingProfilesResponse> listTeamMemberBookingProfilesAsync(Boolean bookableOnly, Integer limit, String cursor, String locationId) {
        return this.makeHttpCallAsync(() -> this.buildListTeamMemberBookingProfilesRequest(bookableOnly, limit, cursor, locationId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListTeamMemberBookingProfilesResponse(context));
    }

    private HttpRequest buildListTeamMemberBookingProfilesRequest(Boolean bookableOnly, Integer limit, String cursor, String locationId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bookings/team-member-booking-profiles");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("bookable_only", bookableOnly != null ? bookableOnly : false);
        queryParameters.put("limit", limit);
        queryParameters.put("cursor", cursor);
        queryParameters.put("location_id", locationId);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListTeamMemberBookingProfilesResponse handleListTeamMemberBookingProfilesResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListTeamMemberBookingProfilesResponse result = ApiHelper.deserialize(responseBody, ListTeamMemberBookingProfilesResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveTeamMemberBookingProfileResponse retrieveTeamMemberBookingProfile(String teamMemberId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveTeamMemberBookingProfileRequest(teamMemberId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveTeamMemberBookingProfileResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveTeamMemberBookingProfileResponse> retrieveTeamMemberBookingProfileAsync(String teamMemberId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveTeamMemberBookingProfileRequest(teamMemberId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveTeamMemberBookingProfileResponse(context));
    }

    private HttpRequest buildRetrieveTeamMemberBookingProfileRequest(String teamMemberId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bookings/team-member-booking-profiles/{team_member_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("team_member_id", new AbstractMap.SimpleEntry<String, Boolean>(teamMemberId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveTeamMemberBookingProfileResponse handleRetrieveTeamMemberBookingProfileResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveTeamMemberBookingProfileResponse result = ApiHelper.deserialize(responseBody, RetrieveTeamMemberBookingProfileResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveBookingResponse retrieveBooking(String bookingId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveBookingRequest(bookingId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveBookingResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveBookingResponse> retrieveBookingAsync(String bookingId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveBookingRequest(bookingId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveBookingResponse(context));
    }

    private HttpRequest buildRetrieveBookingRequest(String bookingId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bookings/{booking_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("booking_id", new AbstractMap.SimpleEntry<String, Boolean>(bookingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveBookingResponse handleRetrieveBookingResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveBookingResponse result = ApiHelper.deserialize(responseBody, RetrieveBookingResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdateBookingResponse updateBooking(String bookingId, UpdateBookingRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateBookingRequest(bookingId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateBookingResponse(context);
    }

    @Override
    public CompletableFuture<UpdateBookingResponse> updateBookingAsync(String bookingId, UpdateBookingRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateBookingRequest(bookingId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateBookingResponse(context));
    }

    private HttpRequest buildUpdateBookingRequest(String bookingId, UpdateBookingRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bookings/{booking_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("booking_id", new AbstractMap.SimpleEntry<String, Boolean>(bookingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpdateBookingResponse handleUpdateBookingResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdateBookingResponse result = ApiHelper.deserialize(responseBody, UpdateBookingResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CancelBookingResponse cancelBooking(String bookingId, CancelBookingRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCancelBookingRequest(bookingId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCancelBookingResponse(context);
    }

    @Override
    public CompletableFuture<CancelBookingResponse> cancelBookingAsync(String bookingId, CancelBookingRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCancelBookingRequest(bookingId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCancelBookingResponse(context));
    }

    private HttpRequest buildCancelBookingRequest(String bookingId, CancelBookingRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/bookings/{booking_id}/cancel");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("booking_id", new AbstractMap.SimpleEntry<String, Boolean>(bookingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CancelBookingResponse handleCancelBookingResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CancelBookingResponse result = ApiHelper.deserialize(responseBody, CancelBookingResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

