/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CashDrawersApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.ListCashDrawerShiftEventsResponse;
import com.squareup.square.models.ListCashDrawerShiftsResponse;
import com.squareup.square.models.RetrieveCashDrawerShiftResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultCashDrawersApi
extends BaseApi
implements CashDrawersApi {
    public DefaultCashDrawersApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultCashDrawersApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListCashDrawerShiftsResponse listCashDrawerShifts(String locationId, String sortOrder, String beginTime, String endTime, Integer limit, String cursor) throws ApiException, IOException {
        HttpRequest request = this.buildListCashDrawerShiftsRequest(locationId, sortOrder, beginTime, endTime, limit, cursor);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListCashDrawerShiftsResponse(context);
    }

    @Override
    public CompletableFuture<ListCashDrawerShiftsResponse> listCashDrawerShiftsAsync(String locationId, String sortOrder, String beginTime, String endTime, Integer limit, String cursor) {
        return this.makeHttpCallAsync(() -> this.buildListCashDrawerShiftsRequest(locationId, sortOrder, beginTime, endTime, limit, cursor), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListCashDrawerShiftsResponse(context));
    }

    private HttpRequest buildListCashDrawerShiftsRequest(String locationId, String sortOrder, String beginTime, String endTime, Integer limit, String cursor) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/cash-drawers/shifts");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("location_id", locationId);
        queryParameters.put("sort_order", sortOrder);
        queryParameters.put("begin_time", beginTime);
        queryParameters.put("end_time", endTime);
        queryParameters.put("limit", limit);
        queryParameters.put("cursor", cursor);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListCashDrawerShiftsResponse handleListCashDrawerShiftsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListCashDrawerShiftsResponse result = ApiHelper.deserialize(responseBody, ListCashDrawerShiftsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveCashDrawerShiftResponse retrieveCashDrawerShift(String locationId, String shiftId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveCashDrawerShiftRequest(locationId, shiftId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveCashDrawerShiftResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveCashDrawerShiftResponse> retrieveCashDrawerShiftAsync(String locationId, String shiftId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveCashDrawerShiftRequest(locationId, shiftId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveCashDrawerShiftResponse(context));
    }

    private HttpRequest buildRetrieveCashDrawerShiftRequest(String locationId, String shiftId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/cash-drawers/shifts/{shift_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("shift_id", new AbstractMap.SimpleEntry<String, Boolean>(shiftId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("location_id", locationId);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveCashDrawerShiftResponse handleRetrieveCashDrawerShiftResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveCashDrawerShiftResponse result = ApiHelper.deserialize(responseBody, RetrieveCashDrawerShiftResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public ListCashDrawerShiftEventsResponse listCashDrawerShiftEvents(String locationId, String shiftId, Integer limit, String cursor) throws ApiException, IOException {
        HttpRequest request = this.buildListCashDrawerShiftEventsRequest(locationId, shiftId, limit, cursor);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListCashDrawerShiftEventsResponse(context);
    }

    @Override
    public CompletableFuture<ListCashDrawerShiftEventsResponse> listCashDrawerShiftEventsAsync(String locationId, String shiftId, Integer limit, String cursor) {
        return this.makeHttpCallAsync(() -> this.buildListCashDrawerShiftEventsRequest(locationId, shiftId, limit, cursor), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListCashDrawerShiftEventsResponse(context));
    }

    private HttpRequest buildListCashDrawerShiftEventsRequest(String locationId, String shiftId, Integer limit, String cursor) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/cash-drawers/shifts/{shift_id}/events");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("shift_id", new AbstractMap.SimpleEntry<String, Boolean>(shiftId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("location_id", locationId);
        queryParameters.put("limit", limit);
        queryParameters.put("cursor", cursor);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListCashDrawerShiftEventsResponse handleListCashDrawerShiftEventsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListCashDrawerShiftEventsResponse result = ApiHelper.deserialize(responseBody, ListCashDrawerShiftEventsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

