/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CatalogApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.request.MultipartFileWrapper;
import com.squareup.square.http.request.MultipartWrapper;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.BatchDeleteCatalogObjectsRequest;
import com.squareup.square.models.BatchDeleteCatalogObjectsResponse;
import com.squareup.square.models.BatchRetrieveCatalogObjectsRequest;
import com.squareup.square.models.BatchRetrieveCatalogObjectsResponse;
import com.squareup.square.models.BatchUpsertCatalogObjectsRequest;
import com.squareup.square.models.BatchUpsertCatalogObjectsResponse;
import com.squareup.square.models.CatalogInfoResponse;
import com.squareup.square.models.CreateCatalogImageRequest;
import com.squareup.square.models.CreateCatalogImageResponse;
import com.squareup.square.models.DeleteCatalogObjectResponse;
import com.squareup.square.models.ListCatalogResponse;
import com.squareup.square.models.RetrieveCatalogObjectResponse;
import com.squareup.square.models.SearchCatalogItemsRequest;
import com.squareup.square.models.SearchCatalogItemsResponse;
import com.squareup.square.models.SearchCatalogObjectsRequest;
import com.squareup.square.models.SearchCatalogObjectsResponse;
import com.squareup.square.models.UpdateCatalogImageRequest;
import com.squareup.square.models.UpdateCatalogImageResponse;
import com.squareup.square.models.UpdateItemModifierListsRequest;
import com.squareup.square.models.UpdateItemModifierListsResponse;
import com.squareup.square.models.UpdateItemTaxesRequest;
import com.squareup.square.models.UpdateItemTaxesResponse;
import com.squareup.square.models.UpsertCatalogObjectRequest;
import com.squareup.square.models.UpsertCatalogObjectResponse;
import com.squareup.square.utilities.FileWrapper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultCatalogApi
extends BaseApi
implements CatalogApi {
    public DefaultCatalogApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultCatalogApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public BatchDeleteCatalogObjectsResponse batchDeleteCatalogObjects(BatchDeleteCatalogObjectsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildBatchDeleteCatalogObjectsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleBatchDeleteCatalogObjectsResponse(context);
    }

    @Override
    public CompletableFuture<BatchDeleteCatalogObjectsResponse> batchDeleteCatalogObjectsAsync(BatchDeleteCatalogObjectsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildBatchDeleteCatalogObjectsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleBatchDeleteCatalogObjectsResponse(context));
    }

    private HttpRequest buildBatchDeleteCatalogObjectsRequest(BatchDeleteCatalogObjectsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/batch-delete");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BatchDeleteCatalogObjectsResponse handleBatchDeleteCatalogObjectsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BatchDeleteCatalogObjectsResponse result = ApiHelper.deserialize(responseBody, BatchDeleteCatalogObjectsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public BatchRetrieveCatalogObjectsResponse batchRetrieveCatalogObjects(BatchRetrieveCatalogObjectsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildBatchRetrieveCatalogObjectsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleBatchRetrieveCatalogObjectsResponse(context);
    }

    @Override
    public CompletableFuture<BatchRetrieveCatalogObjectsResponse> batchRetrieveCatalogObjectsAsync(BatchRetrieveCatalogObjectsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildBatchRetrieveCatalogObjectsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleBatchRetrieveCatalogObjectsResponse(context));
    }

    private HttpRequest buildBatchRetrieveCatalogObjectsRequest(BatchRetrieveCatalogObjectsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/batch-retrieve");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BatchRetrieveCatalogObjectsResponse handleBatchRetrieveCatalogObjectsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BatchRetrieveCatalogObjectsResponse result = ApiHelper.deserialize(responseBody, BatchRetrieveCatalogObjectsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public BatchUpsertCatalogObjectsResponse batchUpsertCatalogObjects(BatchUpsertCatalogObjectsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildBatchUpsertCatalogObjectsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleBatchUpsertCatalogObjectsResponse(context);
    }

    @Override
    public CompletableFuture<BatchUpsertCatalogObjectsResponse> batchUpsertCatalogObjectsAsync(BatchUpsertCatalogObjectsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildBatchUpsertCatalogObjectsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleBatchUpsertCatalogObjectsResponse(context));
    }

    private HttpRequest buildBatchUpsertCatalogObjectsRequest(BatchUpsertCatalogObjectsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/batch-upsert");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BatchUpsertCatalogObjectsResponse handleBatchUpsertCatalogObjectsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BatchUpsertCatalogObjectsResponse result = ApiHelper.deserialize(responseBody, BatchUpsertCatalogObjectsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateCatalogImageResponse createCatalogImage(CreateCatalogImageRequest request, FileWrapper imageFile) throws ApiException, IOException {
        HttpRequest internalRequest = this.buildCreateCatalogImageRequest(request, imageFile);
        ((AuthManager)this.authManagers.get("global")).apply(internalRequest);
        HttpResponse response = this.getClientInstance().execute(internalRequest, false);
        HttpContext context = new HttpContext(internalRequest, response);
        return this.handleCreateCatalogImageResponse(context);
    }

    @Override
    public CompletableFuture<CreateCatalogImageResponse> createCatalogImageAsync(CreateCatalogImageRequest request, FileWrapper imageFile) {
        return this.makeHttpCallAsync(() -> this.buildCreateCatalogImageRequest(request, imageFile), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(internalRequest -> this.getClientInstance().executeAsync((HttpRequest)internalRequest, false)), context -> this.handleCreateCatalogImageResponse(context));
    }

    private HttpRequest buildCreateCatalogImageRequest(CreateCatalogImageRequest request, FileWrapper imageFile) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/images");
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        Headers requestHeaders = new Headers();
        requestHeaders.add("Content-Type", "application/json; charset=utf-8");
        MultipartWrapper requestWrapper = new MultipartWrapper(ApiHelper.serialize(request), requestHeaders);
        Headers imageFileHeaders = new Headers();
        imageFileHeaders.add("Content-Type", "image/jpeg");
        MultipartFileWrapper imageFileWrapper = new MultipartFileWrapper(imageFile, imageFileHeaders);
        HashMap<String, Object> formParameters = new HashMap<String, Object>();
        formParameters.put("request", requestWrapper);
        formParameters.put("image_file", imageFileWrapper);
        HttpRequest internalRequest = this.getClientInstance().post(queryBuilder, headers, null, ApiHelper.prepareFormFields(formParameters));
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(internalRequest);
        }
        return internalRequest;
    }

    private CreateCatalogImageResponse handleCreateCatalogImageResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateCatalogImageResponse result = ApiHelper.deserialize(responseBody, CreateCatalogImageResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdateCatalogImageResponse updateCatalogImage(String imageId, UpdateCatalogImageRequest request, FileWrapper imageFile) throws ApiException, IOException {
        HttpRequest internalRequest = this.buildUpdateCatalogImageRequest(imageId, request, imageFile);
        ((AuthManager)this.authManagers.get("global")).apply(internalRequest);
        HttpResponse response = this.getClientInstance().execute(internalRequest, false);
        HttpContext context = new HttpContext(internalRequest, response);
        return this.handleUpdateCatalogImageResponse(context);
    }

    @Override
    public CompletableFuture<UpdateCatalogImageResponse> updateCatalogImageAsync(String imageId, UpdateCatalogImageRequest request, FileWrapper imageFile) {
        return this.makeHttpCallAsync(() -> this.buildUpdateCatalogImageRequest(imageId, request, imageFile), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(internalRequest -> this.getClientInstance().executeAsync((HttpRequest)internalRequest, false)), context -> this.handleUpdateCatalogImageResponse(context));
    }

    private HttpRequest buildUpdateCatalogImageRequest(String imageId, UpdateCatalogImageRequest request, FileWrapper imageFile) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/images/{image_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("image_id", new AbstractMap.SimpleEntry<String, Boolean>(imageId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        Headers requestHeaders = new Headers();
        requestHeaders.add("Content-Type", "application/json; charset=utf-8");
        MultipartWrapper requestWrapper = new MultipartWrapper(ApiHelper.serialize(request), requestHeaders);
        Headers imageFileHeaders = new Headers();
        imageFileHeaders.add("Content-Type", "image/jpeg");
        MultipartFileWrapper imageFileWrapper = new MultipartFileWrapper(imageFile, imageFileHeaders);
        HashMap<String, Object> formParameters = new HashMap<String, Object>();
        formParameters.put("request", requestWrapper);
        formParameters.put("image_file", imageFileWrapper);
        HttpRequest internalRequest = this.getClientInstance().put(queryBuilder, headers, null, ApiHelper.prepareFormFields(formParameters));
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(internalRequest);
        }
        return internalRequest;
    }

    private UpdateCatalogImageResponse handleUpdateCatalogImageResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdateCatalogImageResponse result = ApiHelper.deserialize(responseBody, UpdateCatalogImageResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CatalogInfoResponse catalogInfo() throws ApiException, IOException {
        HttpRequest request = this.buildCatalogInfoRequest();
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCatalogInfoResponse(context);
    }

    @Override
    public CompletableFuture<CatalogInfoResponse> catalogInfoAsync() {
        return this.makeHttpCallAsync(() -> this.buildCatalogInfoRequest(), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCatalogInfoResponse(context));
    }

    private HttpRequest buildCatalogInfoRequest() {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/info");
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CatalogInfoResponse handleCatalogInfoResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CatalogInfoResponse result = ApiHelper.deserialize(responseBody, CatalogInfoResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public ListCatalogResponse listCatalog(String cursor, String types, Long catalogVersion) throws ApiException, IOException {
        HttpRequest request = this.buildListCatalogRequest(cursor, types, catalogVersion);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListCatalogResponse(context);
    }

    @Override
    public CompletableFuture<ListCatalogResponse> listCatalogAsync(String cursor, String types, Long catalogVersion) {
        return this.makeHttpCallAsync(() -> this.buildListCatalogRequest(cursor, types, catalogVersion), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListCatalogResponse(context));
    }

    private HttpRequest buildListCatalogRequest(String cursor, String types, Long catalogVersion) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/list");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("cursor", cursor);
        queryParameters.put("types", types);
        queryParameters.put("catalog_version", catalogVersion);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListCatalogResponse handleListCatalogResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListCatalogResponse result = ApiHelper.deserialize(responseBody, ListCatalogResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpsertCatalogObjectResponse upsertCatalogObject(UpsertCatalogObjectRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpsertCatalogObjectRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpsertCatalogObjectResponse(context);
    }

    @Override
    public CompletableFuture<UpsertCatalogObjectResponse> upsertCatalogObjectAsync(UpsertCatalogObjectRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpsertCatalogObjectRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpsertCatalogObjectResponse(context));
    }

    private HttpRequest buildUpsertCatalogObjectRequest(UpsertCatalogObjectRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/object");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpsertCatalogObjectResponse handleUpsertCatalogObjectResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpsertCatalogObjectResponse result = ApiHelper.deserialize(responseBody, UpsertCatalogObjectResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public DeleteCatalogObjectResponse deleteCatalogObject(String objectId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteCatalogObjectRequest(objectId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteCatalogObjectResponse(context);
    }

    @Override
    public CompletableFuture<DeleteCatalogObjectResponse> deleteCatalogObjectAsync(String objectId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteCatalogObjectRequest(objectId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteCatalogObjectResponse(context));
    }

    private HttpRequest buildDeleteCatalogObjectRequest(String objectId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/object/{object_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("object_id", new AbstractMap.SimpleEntry<String, Boolean>(objectId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private DeleteCatalogObjectResponse handleDeleteCatalogObjectResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        DeleteCatalogObjectResponse result = ApiHelper.deserialize(responseBody, DeleteCatalogObjectResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveCatalogObjectResponse retrieveCatalogObject(String objectId, Boolean includeRelatedObjects, Long catalogVersion) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveCatalogObjectRequest(objectId, includeRelatedObjects, catalogVersion);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveCatalogObjectResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveCatalogObjectResponse> retrieveCatalogObjectAsync(String objectId, Boolean includeRelatedObjects, Long catalogVersion) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveCatalogObjectRequest(objectId, includeRelatedObjects, catalogVersion), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveCatalogObjectResponse(context));
    }

    private HttpRequest buildRetrieveCatalogObjectRequest(String objectId, Boolean includeRelatedObjects, Long catalogVersion) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/object/{object_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("object_id", new AbstractMap.SimpleEntry<String, Boolean>(objectId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("include_related_objects", includeRelatedObjects != null ? includeRelatedObjects : false);
        queryParameters.put("catalog_version", catalogVersion);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveCatalogObjectResponse handleRetrieveCatalogObjectResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveCatalogObjectResponse result = ApiHelper.deserialize(responseBody, RetrieveCatalogObjectResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchCatalogObjectsResponse searchCatalogObjects(SearchCatalogObjectsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchCatalogObjectsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchCatalogObjectsResponse(context);
    }

    @Override
    public CompletableFuture<SearchCatalogObjectsResponse> searchCatalogObjectsAsync(SearchCatalogObjectsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchCatalogObjectsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchCatalogObjectsResponse(context));
    }

    private HttpRequest buildSearchCatalogObjectsRequest(SearchCatalogObjectsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/search");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchCatalogObjectsResponse handleSearchCatalogObjectsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchCatalogObjectsResponse result = ApiHelper.deserialize(responseBody, SearchCatalogObjectsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchCatalogItemsResponse searchCatalogItems(SearchCatalogItemsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchCatalogItemsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchCatalogItemsResponse(context);
    }

    @Override
    public CompletableFuture<SearchCatalogItemsResponse> searchCatalogItemsAsync(SearchCatalogItemsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchCatalogItemsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchCatalogItemsResponse(context));
    }

    private HttpRequest buildSearchCatalogItemsRequest(SearchCatalogItemsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/search-catalog-items");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchCatalogItemsResponse handleSearchCatalogItemsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchCatalogItemsResponse result = ApiHelper.deserialize(responseBody, SearchCatalogItemsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdateItemModifierListsResponse updateItemModifierLists(UpdateItemModifierListsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateItemModifierListsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateItemModifierListsResponse(context);
    }

    @Override
    public CompletableFuture<UpdateItemModifierListsResponse> updateItemModifierListsAsync(UpdateItemModifierListsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateItemModifierListsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateItemModifierListsResponse(context));
    }

    private HttpRequest buildUpdateItemModifierListsRequest(UpdateItemModifierListsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/update-item-modifier-lists");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpdateItemModifierListsResponse handleUpdateItemModifierListsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdateItemModifierListsResponse result = ApiHelper.deserialize(responseBody, UpdateItemModifierListsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdateItemTaxesResponse updateItemTaxes(UpdateItemTaxesRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateItemTaxesRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateItemTaxesResponse(context);
    }

    @Override
    public CompletableFuture<UpdateItemTaxesResponse> updateItemTaxesAsync(UpdateItemTaxesRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateItemTaxesRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateItemTaxesResponse(context));
    }

    private HttpRequest buildUpdateItemTaxesRequest(UpdateItemTaxesRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/catalog/update-item-taxes");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpdateItemTaxesResponse handleUpdateItemTaxesResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdateItemTaxesResponse result = ApiHelper.deserialize(responseBody, UpdateItemTaxesResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

