/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CustomerCustomAttributesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.BulkUpsertCustomerCustomAttributesRequest;
import com.squareup.square.models.BulkUpsertCustomerCustomAttributesResponse;
import com.squareup.square.models.CreateCustomerCustomAttributeDefinitionRequest;
import com.squareup.square.models.CreateCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteCustomerCustomAttributeResponse;
import com.squareup.square.models.ListCustomerCustomAttributeDefinitionsResponse;
import com.squareup.square.models.ListCustomerCustomAttributesResponse;
import com.squareup.square.models.RetrieveCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.models.RetrieveCustomerCustomAttributeResponse;
import com.squareup.square.models.UpdateCustomerCustomAttributeDefinitionRequest;
import com.squareup.square.models.UpdateCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.models.UpsertCustomerCustomAttributeRequest;
import com.squareup.square.models.UpsertCustomerCustomAttributeResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultCustomerCustomAttributesApi
extends BaseApi
implements CustomerCustomAttributesApi {
    public DefaultCustomerCustomAttributesApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultCustomerCustomAttributesApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListCustomerCustomAttributeDefinitionsResponse listCustomerCustomAttributeDefinitions(Integer limit, String cursor) throws ApiException, IOException {
        HttpRequest request = this.buildListCustomerCustomAttributeDefinitionsRequest(limit, cursor);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListCustomerCustomAttributeDefinitionsResponse(context);
    }

    @Override
    public CompletableFuture<ListCustomerCustomAttributeDefinitionsResponse> listCustomerCustomAttributeDefinitionsAsync(Integer limit, String cursor) {
        return this.makeHttpCallAsync(() -> this.buildListCustomerCustomAttributeDefinitionsRequest(limit, cursor), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListCustomerCustomAttributeDefinitionsResponse(context));
    }

    private HttpRequest buildListCustomerCustomAttributeDefinitionsRequest(Integer limit, String cursor) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/custom-attribute-definitions");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("limit", limit);
        queryParameters.put("cursor", cursor);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListCustomerCustomAttributeDefinitionsResponse handleListCustomerCustomAttributeDefinitionsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListCustomerCustomAttributeDefinitionsResponse result = ApiHelper.deserialize(responseBody, ListCustomerCustomAttributeDefinitionsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateCustomerCustomAttributeDefinitionResponse createCustomerCustomAttributeDefinition(CreateCustomerCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateCustomerCustomAttributeDefinitionRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateCustomerCustomAttributeDefinitionResponse(context);
    }

    @Override
    public CompletableFuture<CreateCustomerCustomAttributeDefinitionResponse> createCustomerCustomAttributeDefinitionAsync(CreateCustomerCustomAttributeDefinitionRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateCustomerCustomAttributeDefinitionRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateCustomerCustomAttributeDefinitionResponse(context));
    }

    private HttpRequest buildCreateCustomerCustomAttributeDefinitionRequest(CreateCustomerCustomAttributeDefinitionRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/custom-attribute-definitions");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateCustomerCustomAttributeDefinitionResponse handleCreateCustomerCustomAttributeDefinitionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateCustomerCustomAttributeDefinitionResponse result = ApiHelper.deserialize(responseBody, CreateCustomerCustomAttributeDefinitionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public DeleteCustomerCustomAttributeDefinitionResponse deleteCustomerCustomAttributeDefinition(String key) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteCustomerCustomAttributeDefinitionRequest(key);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteCustomerCustomAttributeDefinitionResponse(context);
    }

    @Override
    public CompletableFuture<DeleteCustomerCustomAttributeDefinitionResponse> deleteCustomerCustomAttributeDefinitionAsync(String key) {
        return this.makeHttpCallAsync(() -> this.buildDeleteCustomerCustomAttributeDefinitionRequest(key), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteCustomerCustomAttributeDefinitionResponse(context));
    }

    private HttpRequest buildDeleteCustomerCustomAttributeDefinitionRequest(String key) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/custom-attribute-definitions/{key}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("key", new AbstractMap.SimpleEntry<String, Boolean>(key, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private DeleteCustomerCustomAttributeDefinitionResponse handleDeleteCustomerCustomAttributeDefinitionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        DeleteCustomerCustomAttributeDefinitionResponse result = ApiHelper.deserialize(responseBody, DeleteCustomerCustomAttributeDefinitionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveCustomerCustomAttributeDefinitionResponse retrieveCustomerCustomAttributeDefinition(String key, Integer version) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveCustomerCustomAttributeDefinitionRequest(key, version);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveCustomerCustomAttributeDefinitionResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveCustomerCustomAttributeDefinitionResponse> retrieveCustomerCustomAttributeDefinitionAsync(String key, Integer version) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveCustomerCustomAttributeDefinitionRequest(key, version), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveCustomerCustomAttributeDefinitionResponse(context));
    }

    private HttpRequest buildRetrieveCustomerCustomAttributeDefinitionRequest(String key, Integer version) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/custom-attribute-definitions/{key}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("key", new AbstractMap.SimpleEntry<String, Boolean>(key, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("version", version);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveCustomerCustomAttributeDefinitionResponse handleRetrieveCustomerCustomAttributeDefinitionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveCustomerCustomAttributeDefinitionResponse result = ApiHelper.deserialize(responseBody, RetrieveCustomerCustomAttributeDefinitionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdateCustomerCustomAttributeDefinitionResponse updateCustomerCustomAttributeDefinition(String key, UpdateCustomerCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateCustomerCustomAttributeDefinitionRequest(key, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateCustomerCustomAttributeDefinitionResponse(context);
    }

    @Override
    public CompletableFuture<UpdateCustomerCustomAttributeDefinitionResponse> updateCustomerCustomAttributeDefinitionAsync(String key, UpdateCustomerCustomAttributeDefinitionRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateCustomerCustomAttributeDefinitionRequest(key, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateCustomerCustomAttributeDefinitionResponse(context));
    }

    private HttpRequest buildUpdateCustomerCustomAttributeDefinitionRequest(String key, UpdateCustomerCustomAttributeDefinitionRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/custom-attribute-definitions/{key}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("key", new AbstractMap.SimpleEntry<String, Boolean>(key, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpdateCustomerCustomAttributeDefinitionResponse handleUpdateCustomerCustomAttributeDefinitionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdateCustomerCustomAttributeDefinitionResponse result = ApiHelper.deserialize(responseBody, UpdateCustomerCustomAttributeDefinitionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public BulkUpsertCustomerCustomAttributesResponse bulkUpsertCustomerCustomAttributes(BulkUpsertCustomerCustomAttributesRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildBulkUpsertCustomerCustomAttributesRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleBulkUpsertCustomerCustomAttributesResponse(context);
    }

    @Override
    public CompletableFuture<BulkUpsertCustomerCustomAttributesResponse> bulkUpsertCustomerCustomAttributesAsync(BulkUpsertCustomerCustomAttributesRequest body) {
        return this.makeHttpCallAsync(() -> this.buildBulkUpsertCustomerCustomAttributesRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleBulkUpsertCustomerCustomAttributesResponse(context));
    }

    private HttpRequest buildBulkUpsertCustomerCustomAttributesRequest(BulkUpsertCustomerCustomAttributesRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/custom-attributes/bulk-upsert");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BulkUpsertCustomerCustomAttributesResponse handleBulkUpsertCustomerCustomAttributesResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BulkUpsertCustomerCustomAttributesResponse result = ApiHelper.deserialize(responseBody, BulkUpsertCustomerCustomAttributesResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public ListCustomerCustomAttributesResponse listCustomerCustomAttributes(String customerId, Integer limit, String cursor, Boolean withDefinitions) throws ApiException, IOException {
        HttpRequest request = this.buildListCustomerCustomAttributesRequest(customerId, limit, cursor, withDefinitions);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListCustomerCustomAttributesResponse(context);
    }

    @Override
    public CompletableFuture<ListCustomerCustomAttributesResponse> listCustomerCustomAttributesAsync(String customerId, Integer limit, String cursor, Boolean withDefinitions) {
        return this.makeHttpCallAsync(() -> this.buildListCustomerCustomAttributesRequest(customerId, limit, cursor, withDefinitions), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListCustomerCustomAttributesResponse(context));
    }

    private HttpRequest buildListCustomerCustomAttributesRequest(String customerId, Integer limit, String cursor, Boolean withDefinitions) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/{customer_id}/custom-attributes");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("customer_id", new AbstractMap.SimpleEntry<String, Boolean>(customerId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("limit", limit);
        queryParameters.put("cursor", cursor);
        queryParameters.put("with_definitions", withDefinitions != null ? withDefinitions : false);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListCustomerCustomAttributesResponse handleListCustomerCustomAttributesResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListCustomerCustomAttributesResponse result = ApiHelper.deserialize(responseBody, ListCustomerCustomAttributesResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public DeleteCustomerCustomAttributeResponse deleteCustomerCustomAttribute(String customerId, String key) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteCustomerCustomAttributeRequest(customerId, key);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteCustomerCustomAttributeResponse(context);
    }

    @Override
    public CompletableFuture<DeleteCustomerCustomAttributeResponse> deleteCustomerCustomAttributeAsync(String customerId, String key) {
        return this.makeHttpCallAsync(() -> this.buildDeleteCustomerCustomAttributeRequest(customerId, key), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteCustomerCustomAttributeResponse(context));
    }

    private HttpRequest buildDeleteCustomerCustomAttributeRequest(String customerId, String key) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/{customer_id}/custom-attributes/{key}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("customer_id", new AbstractMap.SimpleEntry<String, Boolean>(customerId, true));
        templateParameters.put("key", new AbstractMap.SimpleEntry<String, Boolean>(key, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private DeleteCustomerCustomAttributeResponse handleDeleteCustomerCustomAttributeResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        DeleteCustomerCustomAttributeResponse result = ApiHelper.deserialize(responseBody, DeleteCustomerCustomAttributeResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveCustomerCustomAttributeResponse retrieveCustomerCustomAttribute(String customerId, String key, Boolean withDefinition, Integer version) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveCustomerCustomAttributeRequest(customerId, key, withDefinition, version);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveCustomerCustomAttributeResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveCustomerCustomAttributeResponse> retrieveCustomerCustomAttributeAsync(String customerId, String key, Boolean withDefinition, Integer version) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveCustomerCustomAttributeRequest(customerId, key, withDefinition, version), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveCustomerCustomAttributeResponse(context));
    }

    private HttpRequest buildRetrieveCustomerCustomAttributeRequest(String customerId, String key, Boolean withDefinition, Integer version) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/{customer_id}/custom-attributes/{key}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("customer_id", new AbstractMap.SimpleEntry<String, Boolean>(customerId, true));
        templateParameters.put("key", new AbstractMap.SimpleEntry<String, Boolean>(key, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("with_definition", withDefinition != null ? withDefinition : false);
        queryParameters.put("version", version);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveCustomerCustomAttributeResponse handleRetrieveCustomerCustomAttributeResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveCustomerCustomAttributeResponse result = ApiHelper.deserialize(responseBody, RetrieveCustomerCustomAttributeResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpsertCustomerCustomAttributeResponse upsertCustomerCustomAttribute(String customerId, String key, UpsertCustomerCustomAttributeRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpsertCustomerCustomAttributeRequest(customerId, key, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpsertCustomerCustomAttributeResponse(context);
    }

    @Override
    public CompletableFuture<UpsertCustomerCustomAttributeResponse> upsertCustomerCustomAttributeAsync(String customerId, String key, UpsertCustomerCustomAttributeRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpsertCustomerCustomAttributeRequest(customerId, key, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpsertCustomerCustomAttributeResponse(context));
    }

    private HttpRequest buildUpsertCustomerCustomAttributeRequest(String customerId, String key, UpsertCustomerCustomAttributeRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/{customer_id}/custom-attributes/{key}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("customer_id", new AbstractMap.SimpleEntry<String, Boolean>(customerId, true));
        templateParameters.put("key", new AbstractMap.SimpleEntry<String, Boolean>(key, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpsertCustomerCustomAttributeResponse handleUpsertCustomerCustomAttributeResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpsertCustomerCustomAttributeResponse result = ApiHelper.deserialize(responseBody, UpsertCustomerCustomAttributeResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

