/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CustomerGroupsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.CreateCustomerGroupRequest;
import com.squareup.square.models.CreateCustomerGroupResponse;
import com.squareup.square.models.DeleteCustomerGroupResponse;
import com.squareup.square.models.ListCustomerGroupsResponse;
import com.squareup.square.models.RetrieveCustomerGroupResponse;
import com.squareup.square.models.UpdateCustomerGroupRequest;
import com.squareup.square.models.UpdateCustomerGroupResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultCustomerGroupsApi
extends BaseApi
implements CustomerGroupsApi {
    public DefaultCustomerGroupsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultCustomerGroupsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListCustomerGroupsResponse listCustomerGroups(String cursor, Integer limit) throws ApiException, IOException {
        HttpRequest request = this.buildListCustomerGroupsRequest(cursor, limit);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListCustomerGroupsResponse(context);
    }

    @Override
    public CompletableFuture<ListCustomerGroupsResponse> listCustomerGroupsAsync(String cursor, Integer limit) {
        return this.makeHttpCallAsync(() -> this.buildListCustomerGroupsRequest(cursor, limit), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListCustomerGroupsResponse(context));
    }

    private HttpRequest buildListCustomerGroupsRequest(String cursor, Integer limit) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/groups");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("cursor", cursor);
        queryParameters.put("limit", limit);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListCustomerGroupsResponse handleListCustomerGroupsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListCustomerGroupsResponse result = ApiHelper.deserialize(responseBody, ListCustomerGroupsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateCustomerGroupResponse createCustomerGroup(CreateCustomerGroupRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateCustomerGroupRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateCustomerGroupResponse(context);
    }

    @Override
    public CompletableFuture<CreateCustomerGroupResponse> createCustomerGroupAsync(CreateCustomerGroupRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateCustomerGroupRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateCustomerGroupResponse(context));
    }

    private HttpRequest buildCreateCustomerGroupRequest(CreateCustomerGroupRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/groups");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateCustomerGroupResponse handleCreateCustomerGroupResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateCustomerGroupResponse result = ApiHelper.deserialize(responseBody, CreateCustomerGroupResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public DeleteCustomerGroupResponse deleteCustomerGroup(String groupId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteCustomerGroupRequest(groupId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteCustomerGroupResponse(context);
    }

    @Override
    public CompletableFuture<DeleteCustomerGroupResponse> deleteCustomerGroupAsync(String groupId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteCustomerGroupRequest(groupId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteCustomerGroupResponse(context));
    }

    private HttpRequest buildDeleteCustomerGroupRequest(String groupId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/groups/{group_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("group_id", new AbstractMap.SimpleEntry<String, Boolean>(groupId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private DeleteCustomerGroupResponse handleDeleteCustomerGroupResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        DeleteCustomerGroupResponse result = ApiHelper.deserialize(responseBody, DeleteCustomerGroupResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveCustomerGroupResponse retrieveCustomerGroup(String groupId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveCustomerGroupRequest(groupId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveCustomerGroupResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveCustomerGroupResponse> retrieveCustomerGroupAsync(String groupId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveCustomerGroupRequest(groupId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveCustomerGroupResponse(context));
    }

    private HttpRequest buildRetrieveCustomerGroupRequest(String groupId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/groups/{group_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("group_id", new AbstractMap.SimpleEntry<String, Boolean>(groupId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveCustomerGroupResponse handleRetrieveCustomerGroupResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveCustomerGroupResponse result = ApiHelper.deserialize(responseBody, RetrieveCustomerGroupResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdateCustomerGroupResponse updateCustomerGroup(String groupId, UpdateCustomerGroupRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateCustomerGroupRequest(groupId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateCustomerGroupResponse(context);
    }

    @Override
    public CompletableFuture<UpdateCustomerGroupResponse> updateCustomerGroupAsync(String groupId, UpdateCustomerGroupRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateCustomerGroupRequest(groupId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateCustomerGroupResponse(context));
    }

    private HttpRequest buildUpdateCustomerGroupRequest(String groupId, UpdateCustomerGroupRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/groups/{group_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("group_id", new AbstractMap.SimpleEntry<String, Boolean>(groupId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpdateCustomerGroupResponse handleUpdateCustomerGroupResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdateCustomerGroupResponse result = ApiHelper.deserialize(responseBody, UpdateCustomerGroupResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

