/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CustomersApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.AddGroupToCustomerResponse;
import com.squareup.square.models.CreateCustomerCardRequest;
import com.squareup.square.models.CreateCustomerCardResponse;
import com.squareup.square.models.CreateCustomerRequest;
import com.squareup.square.models.CreateCustomerResponse;
import com.squareup.square.models.DeleteCustomerCardResponse;
import com.squareup.square.models.DeleteCustomerResponse;
import com.squareup.square.models.ListCustomersResponse;
import com.squareup.square.models.RemoveGroupFromCustomerResponse;
import com.squareup.square.models.RetrieveCustomerResponse;
import com.squareup.square.models.SearchCustomersRequest;
import com.squareup.square.models.SearchCustomersResponse;
import com.squareup.square.models.UpdateCustomerRequest;
import com.squareup.square.models.UpdateCustomerResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultCustomersApi
extends BaseApi
implements CustomersApi {
    public DefaultCustomersApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultCustomersApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListCustomersResponse listCustomers(String cursor, Integer limit, String sortField, String sortOrder) throws ApiException, IOException {
        HttpRequest request = this.buildListCustomersRequest(cursor, limit, sortField, sortOrder);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListCustomersResponse(context);
    }

    @Override
    public CompletableFuture<ListCustomersResponse> listCustomersAsync(String cursor, Integer limit, String sortField, String sortOrder) {
        return this.makeHttpCallAsync(() -> this.buildListCustomersRequest(cursor, limit, sortField, sortOrder), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListCustomersResponse(context));
    }

    private HttpRequest buildListCustomersRequest(String cursor, Integer limit, String sortField, String sortOrder) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("cursor", cursor);
        queryParameters.put("limit", limit);
        queryParameters.put("sort_field", sortField);
        queryParameters.put("sort_order", sortOrder);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListCustomersResponse handleListCustomersResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListCustomersResponse result = ApiHelper.deserialize(responseBody, ListCustomersResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateCustomerResponse createCustomer(CreateCustomerRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateCustomerRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateCustomerResponse(context);
    }

    @Override
    public CompletableFuture<CreateCustomerResponse> createCustomerAsync(CreateCustomerRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateCustomerRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateCustomerResponse(context));
    }

    private HttpRequest buildCreateCustomerRequest(CreateCustomerRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateCustomerResponse handleCreateCustomerResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateCustomerResponse result = ApiHelper.deserialize(responseBody, CreateCustomerResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchCustomersResponse searchCustomers(SearchCustomersRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchCustomersRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchCustomersResponse(context);
    }

    @Override
    public CompletableFuture<SearchCustomersResponse> searchCustomersAsync(SearchCustomersRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchCustomersRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchCustomersResponse(context));
    }

    private HttpRequest buildSearchCustomersRequest(SearchCustomersRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/search");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchCustomersResponse handleSearchCustomersResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchCustomersResponse result = ApiHelper.deserialize(responseBody, SearchCustomersResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public DeleteCustomerResponse deleteCustomer(String customerId, Long version) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteCustomerRequest(customerId, version);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteCustomerResponse(context);
    }

    @Override
    public CompletableFuture<DeleteCustomerResponse> deleteCustomerAsync(String customerId, Long version) {
        return this.makeHttpCallAsync(() -> this.buildDeleteCustomerRequest(customerId, version), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteCustomerResponse(context));
    }

    private HttpRequest buildDeleteCustomerRequest(String customerId, Long version) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/{customer_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("customer_id", new AbstractMap.SimpleEntry<String, Boolean>(customerId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("version", version);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private DeleteCustomerResponse handleDeleteCustomerResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        DeleteCustomerResponse result = ApiHelper.deserialize(responseBody, DeleteCustomerResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveCustomerResponse retrieveCustomer(String customerId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveCustomerRequest(customerId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveCustomerResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveCustomerResponse> retrieveCustomerAsync(String customerId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveCustomerRequest(customerId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveCustomerResponse(context));
    }

    private HttpRequest buildRetrieveCustomerRequest(String customerId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/{customer_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("customer_id", new AbstractMap.SimpleEntry<String, Boolean>(customerId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveCustomerResponse handleRetrieveCustomerResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveCustomerResponse result = ApiHelper.deserialize(responseBody, RetrieveCustomerResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdateCustomerResponse updateCustomer(String customerId, UpdateCustomerRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateCustomerRequest(customerId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateCustomerResponse(context);
    }

    @Override
    public CompletableFuture<UpdateCustomerResponse> updateCustomerAsync(String customerId, UpdateCustomerRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateCustomerRequest(customerId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateCustomerResponse(context));
    }

    private HttpRequest buildUpdateCustomerRequest(String customerId, UpdateCustomerRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/{customer_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("customer_id", new AbstractMap.SimpleEntry<String, Boolean>(customerId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpdateCustomerResponse handleUpdateCustomerResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdateCustomerResponse result = ApiHelper.deserialize(responseBody, UpdateCustomerResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public CreateCustomerCardResponse createCustomerCard(String customerId, CreateCustomerCardRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateCustomerCardRequest(customerId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateCustomerCardResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<CreateCustomerCardResponse> createCustomerCardAsync(String customerId, CreateCustomerCardRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateCustomerCardRequest(customerId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateCustomerCardResponse(context));
    }

    private HttpRequest buildCreateCustomerCardRequest(String customerId, CreateCustomerCardRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/{customer_id}/cards");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("customer_id", new AbstractMap.SimpleEntry<String, Boolean>(customerId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateCustomerCardResponse handleCreateCustomerCardResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateCustomerCardResponse result = ApiHelper.deserialize(responseBody, CreateCustomerCardResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public DeleteCustomerCardResponse deleteCustomerCard(String customerId, String cardId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteCustomerCardRequest(customerId, cardId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteCustomerCardResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<DeleteCustomerCardResponse> deleteCustomerCardAsync(String customerId, String cardId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteCustomerCardRequest(customerId, cardId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteCustomerCardResponse(context));
    }

    private HttpRequest buildDeleteCustomerCardRequest(String customerId, String cardId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/{customer_id}/cards/{card_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("customer_id", new AbstractMap.SimpleEntry<String, Boolean>(customerId, true));
        templateParameters.put("card_id", new AbstractMap.SimpleEntry<String, Boolean>(cardId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private DeleteCustomerCardResponse handleDeleteCustomerCardResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        DeleteCustomerCardResponse result = ApiHelper.deserialize(responseBody, DeleteCustomerCardResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RemoveGroupFromCustomerResponse removeGroupFromCustomer(String customerId, String groupId) throws ApiException, IOException {
        HttpRequest request = this.buildRemoveGroupFromCustomerRequest(customerId, groupId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRemoveGroupFromCustomerResponse(context);
    }

    @Override
    public CompletableFuture<RemoveGroupFromCustomerResponse> removeGroupFromCustomerAsync(String customerId, String groupId) {
        return this.makeHttpCallAsync(() -> this.buildRemoveGroupFromCustomerRequest(customerId, groupId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRemoveGroupFromCustomerResponse(context));
    }

    private HttpRequest buildRemoveGroupFromCustomerRequest(String customerId, String groupId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/{customer_id}/groups/{group_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("customer_id", new AbstractMap.SimpleEntry<String, Boolean>(customerId, true));
        templateParameters.put("group_id", new AbstractMap.SimpleEntry<String, Boolean>(groupId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RemoveGroupFromCustomerResponse handleRemoveGroupFromCustomerResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RemoveGroupFromCustomerResponse result = ApiHelper.deserialize(responseBody, RemoveGroupFromCustomerResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public AddGroupToCustomerResponse addGroupToCustomer(String customerId, String groupId) throws ApiException, IOException {
        HttpRequest request = this.buildAddGroupToCustomerRequest(customerId, groupId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleAddGroupToCustomerResponse(context);
    }

    @Override
    public CompletableFuture<AddGroupToCustomerResponse> addGroupToCustomerAsync(String customerId, String groupId) {
        return this.makeHttpCallAsync(() -> this.buildAddGroupToCustomerRequest(customerId, groupId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleAddGroupToCustomerResponse(context));
    }

    private HttpRequest buildAddGroupToCustomerRequest(String customerId, String groupId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/customers/{customer_id}/groups/{group_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("customer_id", new AbstractMap.SimpleEntry<String, Boolean>(customerId, true));
        templateParameters.put("group_id", new AbstractMap.SimpleEntry<String, Boolean>(groupId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().put(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private AddGroupToCustomerResponse handleAddGroupToCustomerResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        AddGroupToCustomerResponse result = ApiHelper.deserialize(responseBody, AddGroupToCustomerResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

