/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.DisputesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.request.MultipartFileWrapper;
import com.squareup.square.http.request.MultipartWrapper;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.AcceptDisputeResponse;
import com.squareup.square.models.CreateDisputeEvidenceFileRequest;
import com.squareup.square.models.CreateDisputeEvidenceFileResponse;
import com.squareup.square.models.CreateDisputeEvidenceTextRequest;
import com.squareup.square.models.CreateDisputeEvidenceTextResponse;
import com.squareup.square.models.DeleteDisputeEvidenceResponse;
import com.squareup.square.models.ListDisputeEvidenceResponse;
import com.squareup.square.models.ListDisputesResponse;
import com.squareup.square.models.RetrieveDisputeEvidenceResponse;
import com.squareup.square.models.RetrieveDisputeResponse;
import com.squareup.square.models.SubmitEvidenceResponse;
import com.squareup.square.utilities.FileWrapper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultDisputesApi
extends BaseApi
implements DisputesApi {
    public DefaultDisputesApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultDisputesApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListDisputesResponse listDisputes(String cursor, String states, String locationId) throws ApiException, IOException {
        HttpRequest request = this.buildListDisputesRequest(cursor, states, locationId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListDisputesResponse(context);
    }

    @Override
    public CompletableFuture<ListDisputesResponse> listDisputesAsync(String cursor, String states, String locationId) {
        return this.makeHttpCallAsync(() -> this.buildListDisputesRequest(cursor, states, locationId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListDisputesResponse(context));
    }

    private HttpRequest buildListDisputesRequest(String cursor, String states, String locationId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/disputes");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("cursor", cursor);
        queryParameters.put("states", states);
        queryParameters.put("location_id", locationId);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListDisputesResponse handleListDisputesResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListDisputesResponse result = ApiHelper.deserialize(responseBody, ListDisputesResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveDisputeResponse retrieveDispute(String disputeId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveDisputeRequest(disputeId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveDisputeResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveDisputeResponse> retrieveDisputeAsync(String disputeId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveDisputeRequest(disputeId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveDisputeResponse(context));
    }

    private HttpRequest buildRetrieveDisputeRequest(String disputeId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/disputes/{dispute_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("dispute_id", new AbstractMap.SimpleEntry<String, Boolean>(disputeId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveDisputeResponse handleRetrieveDisputeResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveDisputeResponse result = ApiHelper.deserialize(responseBody, RetrieveDisputeResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public AcceptDisputeResponse acceptDispute(String disputeId) throws ApiException, IOException {
        HttpRequest request = this.buildAcceptDisputeRequest(disputeId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleAcceptDisputeResponse(context);
    }

    @Override
    public CompletableFuture<AcceptDisputeResponse> acceptDisputeAsync(String disputeId) {
        return this.makeHttpCallAsync(() -> this.buildAcceptDisputeRequest(disputeId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleAcceptDisputeResponse(context));
    }

    private HttpRequest buildAcceptDisputeRequest(String disputeId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/disputes/{dispute_id}/accept");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("dispute_id", new AbstractMap.SimpleEntry<String, Boolean>(disputeId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().post(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private AcceptDisputeResponse handleAcceptDisputeResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        AcceptDisputeResponse result = ApiHelper.deserialize(responseBody, AcceptDisputeResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public ListDisputeEvidenceResponse listDisputeEvidence(String disputeId, String cursor) throws ApiException, IOException {
        HttpRequest request = this.buildListDisputeEvidenceRequest(disputeId, cursor);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListDisputeEvidenceResponse(context);
    }

    @Override
    public CompletableFuture<ListDisputeEvidenceResponse> listDisputeEvidenceAsync(String disputeId, String cursor) {
        return this.makeHttpCallAsync(() -> this.buildListDisputeEvidenceRequest(disputeId, cursor), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListDisputeEvidenceResponse(context));
    }

    private HttpRequest buildListDisputeEvidenceRequest(String disputeId, String cursor) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/disputes/{dispute_id}/evidence");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("dispute_id", new AbstractMap.SimpleEntry<String, Boolean>(disputeId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("cursor", cursor);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListDisputeEvidenceResponse handleListDisputeEvidenceResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListDisputeEvidenceResponse result = ApiHelper.deserialize(responseBody, ListDisputeEvidenceResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateDisputeEvidenceFileResponse createDisputeEvidenceFile(String disputeId, CreateDisputeEvidenceFileRequest request, FileWrapper imageFile) throws ApiException, IOException {
        HttpRequest internalRequest = this.buildCreateDisputeEvidenceFileRequest(disputeId, request, imageFile);
        ((AuthManager)this.authManagers.get("global")).apply(internalRequest);
        HttpResponse response = this.getClientInstance().execute(internalRequest, false);
        HttpContext context = new HttpContext(internalRequest, response);
        return this.handleCreateDisputeEvidenceFileResponse(context);
    }

    @Override
    public CompletableFuture<CreateDisputeEvidenceFileResponse> createDisputeEvidenceFileAsync(String disputeId, CreateDisputeEvidenceFileRequest request, FileWrapper imageFile) {
        return this.makeHttpCallAsync(() -> this.buildCreateDisputeEvidenceFileRequest(disputeId, request, imageFile), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(internalRequest -> this.getClientInstance().executeAsync((HttpRequest)internalRequest, false)), context -> this.handleCreateDisputeEvidenceFileResponse(context));
    }

    private HttpRequest buildCreateDisputeEvidenceFileRequest(String disputeId, CreateDisputeEvidenceFileRequest request, FileWrapper imageFile) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/disputes/{dispute_id}/evidence-files");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("dispute_id", new AbstractMap.SimpleEntry<String, Boolean>(disputeId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        Headers requestHeaders = new Headers();
        requestHeaders.add("Content-Type", "application/json; charset=utf-8");
        MultipartWrapper requestWrapper = new MultipartWrapper(ApiHelper.serialize(request), requestHeaders);
        Headers imageFileHeaders = new Headers();
        imageFileHeaders.add("Content-Type", "image/jpeg");
        MultipartFileWrapper imageFileWrapper = new MultipartFileWrapper(imageFile, imageFileHeaders);
        HashMap<String, Object> formParameters = new HashMap<String, Object>();
        formParameters.put("request", requestWrapper);
        formParameters.put("image_file", imageFileWrapper);
        HttpRequest internalRequest = this.getClientInstance().post(queryBuilder, headers, null, ApiHelper.prepareFormFields(formParameters));
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(internalRequest);
        }
        return internalRequest;
    }

    private CreateDisputeEvidenceFileResponse handleCreateDisputeEvidenceFileResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateDisputeEvidenceFileResponse result = ApiHelper.deserialize(responseBody, CreateDisputeEvidenceFileResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateDisputeEvidenceTextResponse createDisputeEvidenceText(String disputeId, CreateDisputeEvidenceTextRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateDisputeEvidenceTextRequest(disputeId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateDisputeEvidenceTextResponse(context);
    }

    @Override
    public CompletableFuture<CreateDisputeEvidenceTextResponse> createDisputeEvidenceTextAsync(String disputeId, CreateDisputeEvidenceTextRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateDisputeEvidenceTextRequest(disputeId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateDisputeEvidenceTextResponse(context));
    }

    private HttpRequest buildCreateDisputeEvidenceTextRequest(String disputeId, CreateDisputeEvidenceTextRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/disputes/{dispute_id}/evidence-text");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("dispute_id", new AbstractMap.SimpleEntry<String, Boolean>(disputeId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateDisputeEvidenceTextResponse handleCreateDisputeEvidenceTextResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateDisputeEvidenceTextResponse result = ApiHelper.deserialize(responseBody, CreateDisputeEvidenceTextResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public DeleteDisputeEvidenceResponse deleteDisputeEvidence(String disputeId, String evidenceId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteDisputeEvidenceRequest(disputeId, evidenceId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteDisputeEvidenceResponse(context);
    }

    @Override
    public CompletableFuture<DeleteDisputeEvidenceResponse> deleteDisputeEvidenceAsync(String disputeId, String evidenceId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteDisputeEvidenceRequest(disputeId, evidenceId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteDisputeEvidenceResponse(context));
    }

    private HttpRequest buildDeleteDisputeEvidenceRequest(String disputeId, String evidenceId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/disputes/{dispute_id}/evidence/{evidence_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("dispute_id", new AbstractMap.SimpleEntry<String, Boolean>(disputeId, true));
        templateParameters.put("evidence_id", new AbstractMap.SimpleEntry<String, Boolean>(evidenceId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private DeleteDisputeEvidenceResponse handleDeleteDisputeEvidenceResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        DeleteDisputeEvidenceResponse result = ApiHelper.deserialize(responseBody, DeleteDisputeEvidenceResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveDisputeEvidenceResponse retrieveDisputeEvidence(String disputeId, String evidenceId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveDisputeEvidenceRequest(disputeId, evidenceId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveDisputeEvidenceResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveDisputeEvidenceResponse> retrieveDisputeEvidenceAsync(String disputeId, String evidenceId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveDisputeEvidenceRequest(disputeId, evidenceId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveDisputeEvidenceResponse(context));
    }

    private HttpRequest buildRetrieveDisputeEvidenceRequest(String disputeId, String evidenceId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/disputes/{dispute_id}/evidence/{evidence_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("dispute_id", new AbstractMap.SimpleEntry<String, Boolean>(disputeId, true));
        templateParameters.put("evidence_id", new AbstractMap.SimpleEntry<String, Boolean>(evidenceId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveDisputeEvidenceResponse handleRetrieveDisputeEvidenceResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveDisputeEvidenceResponse result = ApiHelper.deserialize(responseBody, RetrieveDisputeEvidenceResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SubmitEvidenceResponse submitEvidence(String disputeId) throws ApiException, IOException {
        HttpRequest request = this.buildSubmitEvidenceRequest(disputeId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSubmitEvidenceResponse(context);
    }

    @Override
    public CompletableFuture<SubmitEvidenceResponse> submitEvidenceAsync(String disputeId) {
        return this.makeHttpCallAsync(() -> this.buildSubmitEvidenceRequest(disputeId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSubmitEvidenceResponse(context));
    }

    private HttpRequest buildSubmitEvidenceRequest(String disputeId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/disputes/{dispute_id}/submit-evidence");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("dispute_id", new AbstractMap.SimpleEntry<String, Boolean>(disputeId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().post(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SubmitEvidenceResponse handleSubmitEvidenceResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SubmitEvidenceResponse result = ApiHelper.deserialize(responseBody, SubmitEvidenceResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

