/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.GiftCardActivitiesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.CreateGiftCardActivityRequest;
import com.squareup.square.models.CreateGiftCardActivityResponse;
import com.squareup.square.models.ListGiftCardActivitiesResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultGiftCardActivitiesApi
extends BaseApi
implements GiftCardActivitiesApi {
    public DefaultGiftCardActivitiesApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultGiftCardActivitiesApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListGiftCardActivitiesResponse listGiftCardActivities(String giftCardId, String type, String locationId, String beginTime, String endTime, Integer limit, String cursor, String sortOrder) throws ApiException, IOException {
        HttpRequest request = this.buildListGiftCardActivitiesRequest(giftCardId, type, locationId, beginTime, endTime, limit, cursor, sortOrder);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListGiftCardActivitiesResponse(context);
    }

    @Override
    public CompletableFuture<ListGiftCardActivitiesResponse> listGiftCardActivitiesAsync(String giftCardId, String type, String locationId, String beginTime, String endTime, Integer limit, String cursor, String sortOrder) {
        return this.makeHttpCallAsync(() -> this.buildListGiftCardActivitiesRequest(giftCardId, type, locationId, beginTime, endTime, limit, cursor, sortOrder), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListGiftCardActivitiesResponse(context));
    }

    private HttpRequest buildListGiftCardActivitiesRequest(String giftCardId, String type, String locationId, String beginTime, String endTime, Integer limit, String cursor, String sortOrder) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/gift-cards/activities");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("gift_card_id", giftCardId);
        queryParameters.put("type", type);
        queryParameters.put("location_id", locationId);
        queryParameters.put("begin_time", beginTime);
        queryParameters.put("end_time", endTime);
        queryParameters.put("limit", limit);
        queryParameters.put("cursor", cursor);
        queryParameters.put("sort_order", sortOrder);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListGiftCardActivitiesResponse handleListGiftCardActivitiesResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListGiftCardActivitiesResponse result = ApiHelper.deserialize(responseBody, ListGiftCardActivitiesResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateGiftCardActivityResponse createGiftCardActivity(CreateGiftCardActivityRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateGiftCardActivityRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateGiftCardActivityResponse(context);
    }

    @Override
    public CompletableFuture<CreateGiftCardActivityResponse> createGiftCardActivityAsync(CreateGiftCardActivityRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateGiftCardActivityRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateGiftCardActivityResponse(context));
    }

    private HttpRequest buildCreateGiftCardActivityRequest(CreateGiftCardActivityRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/gift-cards/activities");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateGiftCardActivityResponse handleCreateGiftCardActivityResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateGiftCardActivityResponse result = ApiHelper.deserialize(responseBody, CreateGiftCardActivityResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

