/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.GiftCardsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.CreateGiftCardRequest;
import com.squareup.square.models.CreateGiftCardResponse;
import com.squareup.square.models.LinkCustomerToGiftCardRequest;
import com.squareup.square.models.LinkCustomerToGiftCardResponse;
import com.squareup.square.models.ListGiftCardsResponse;
import com.squareup.square.models.RetrieveGiftCardFromGANRequest;
import com.squareup.square.models.RetrieveGiftCardFromGANResponse;
import com.squareup.square.models.RetrieveGiftCardFromNonceRequest;
import com.squareup.square.models.RetrieveGiftCardFromNonceResponse;
import com.squareup.square.models.RetrieveGiftCardResponse;
import com.squareup.square.models.UnlinkCustomerFromGiftCardRequest;
import com.squareup.square.models.UnlinkCustomerFromGiftCardResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultGiftCardsApi
extends BaseApi
implements GiftCardsApi {
    public DefaultGiftCardsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultGiftCardsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListGiftCardsResponse listGiftCards(String type, String state, Integer limit, String cursor, String customerId) throws ApiException, IOException {
        HttpRequest request = this.buildListGiftCardsRequest(type, state, limit, cursor, customerId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListGiftCardsResponse(context);
    }

    @Override
    public CompletableFuture<ListGiftCardsResponse> listGiftCardsAsync(String type, String state, Integer limit, String cursor, String customerId) {
        return this.makeHttpCallAsync(() -> this.buildListGiftCardsRequest(type, state, limit, cursor, customerId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListGiftCardsResponse(context));
    }

    private HttpRequest buildListGiftCardsRequest(String type, String state, Integer limit, String cursor, String customerId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/gift-cards");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("type", type);
        queryParameters.put("state", state);
        queryParameters.put("limit", limit);
        queryParameters.put("cursor", cursor);
        queryParameters.put("customer_id", customerId);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListGiftCardsResponse handleListGiftCardsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListGiftCardsResponse result = ApiHelper.deserialize(responseBody, ListGiftCardsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateGiftCardResponse createGiftCard(CreateGiftCardRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateGiftCardRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateGiftCardResponse(context);
    }

    @Override
    public CompletableFuture<CreateGiftCardResponse> createGiftCardAsync(CreateGiftCardRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateGiftCardRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateGiftCardResponse(context));
    }

    private HttpRequest buildCreateGiftCardRequest(CreateGiftCardRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/gift-cards");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateGiftCardResponse handleCreateGiftCardResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateGiftCardResponse result = ApiHelper.deserialize(responseBody, CreateGiftCardResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveGiftCardFromGANResponse retrieveGiftCardFromGAN(RetrieveGiftCardFromGANRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveGiftCardFromGANRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveGiftCardFromGANResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveGiftCardFromGANResponse> retrieveGiftCardFromGANAsync(RetrieveGiftCardFromGANRequest body) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveGiftCardFromGANRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveGiftCardFromGANResponse(context));
    }

    private HttpRequest buildRetrieveGiftCardFromGANRequest(RetrieveGiftCardFromGANRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/gift-cards/from-gan");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveGiftCardFromGANResponse handleRetrieveGiftCardFromGANResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveGiftCardFromGANResponse result = ApiHelper.deserialize(responseBody, RetrieveGiftCardFromGANResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveGiftCardFromNonceResponse retrieveGiftCardFromNonce(RetrieveGiftCardFromNonceRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveGiftCardFromNonceRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveGiftCardFromNonceResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveGiftCardFromNonceResponse> retrieveGiftCardFromNonceAsync(RetrieveGiftCardFromNonceRequest body) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveGiftCardFromNonceRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveGiftCardFromNonceResponse(context));
    }

    private HttpRequest buildRetrieveGiftCardFromNonceRequest(RetrieveGiftCardFromNonceRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/gift-cards/from-nonce");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveGiftCardFromNonceResponse handleRetrieveGiftCardFromNonceResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveGiftCardFromNonceResponse result = ApiHelper.deserialize(responseBody, RetrieveGiftCardFromNonceResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public LinkCustomerToGiftCardResponse linkCustomerToGiftCard(String giftCardId, LinkCustomerToGiftCardRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildLinkCustomerToGiftCardRequest(giftCardId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleLinkCustomerToGiftCardResponse(context);
    }

    @Override
    public CompletableFuture<LinkCustomerToGiftCardResponse> linkCustomerToGiftCardAsync(String giftCardId, LinkCustomerToGiftCardRequest body) {
        return this.makeHttpCallAsync(() -> this.buildLinkCustomerToGiftCardRequest(giftCardId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleLinkCustomerToGiftCardResponse(context));
    }

    private HttpRequest buildLinkCustomerToGiftCardRequest(String giftCardId, LinkCustomerToGiftCardRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/gift-cards/{gift_card_id}/link-customer");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("gift_card_id", new AbstractMap.SimpleEntry<String, Boolean>(giftCardId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private LinkCustomerToGiftCardResponse handleLinkCustomerToGiftCardResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        LinkCustomerToGiftCardResponse result = ApiHelper.deserialize(responseBody, LinkCustomerToGiftCardResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UnlinkCustomerFromGiftCardResponse unlinkCustomerFromGiftCard(String giftCardId, UnlinkCustomerFromGiftCardRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUnlinkCustomerFromGiftCardRequest(giftCardId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUnlinkCustomerFromGiftCardResponse(context);
    }

    @Override
    public CompletableFuture<UnlinkCustomerFromGiftCardResponse> unlinkCustomerFromGiftCardAsync(String giftCardId, UnlinkCustomerFromGiftCardRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUnlinkCustomerFromGiftCardRequest(giftCardId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUnlinkCustomerFromGiftCardResponse(context));
    }

    private HttpRequest buildUnlinkCustomerFromGiftCardRequest(String giftCardId, UnlinkCustomerFromGiftCardRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/gift-cards/{gift_card_id}/unlink-customer");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("gift_card_id", new AbstractMap.SimpleEntry<String, Boolean>(giftCardId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UnlinkCustomerFromGiftCardResponse handleUnlinkCustomerFromGiftCardResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UnlinkCustomerFromGiftCardResponse result = ApiHelper.deserialize(responseBody, UnlinkCustomerFromGiftCardResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveGiftCardResponse retrieveGiftCard(String id) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveGiftCardRequest(id);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveGiftCardResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveGiftCardResponse> retrieveGiftCardAsync(String id) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveGiftCardRequest(id), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveGiftCardResponse(context));
    }

    private HttpRequest buildRetrieveGiftCardRequest(String id) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/gift-cards/{id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("id", new AbstractMap.SimpleEntry<String, Boolean>(id, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveGiftCardResponse handleRetrieveGiftCardResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveGiftCardResponse result = ApiHelper.deserialize(responseBody, RetrieveGiftCardResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

