/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.InventoryApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.BatchChangeInventoryRequest;
import com.squareup.square.models.BatchChangeInventoryResponse;
import com.squareup.square.models.BatchRetrieveInventoryChangesRequest;
import com.squareup.square.models.BatchRetrieveInventoryChangesResponse;
import com.squareup.square.models.BatchRetrieveInventoryCountsRequest;
import com.squareup.square.models.BatchRetrieveInventoryCountsResponse;
import com.squareup.square.models.RetrieveInventoryAdjustmentResponse;
import com.squareup.square.models.RetrieveInventoryChangesResponse;
import com.squareup.square.models.RetrieveInventoryCountResponse;
import com.squareup.square.models.RetrieveInventoryPhysicalCountResponse;
import com.squareup.square.models.RetrieveInventoryTransferResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultInventoryApi
extends BaseApi
implements InventoryApi {
    public DefaultInventoryApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultInventoryApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    @Deprecated
    public RetrieveInventoryAdjustmentResponse deprecatedRetrieveInventoryAdjustment(String adjustmentId) throws ApiException, IOException {
        HttpRequest request = this.buildDeprecatedRetrieveInventoryAdjustmentRequest(adjustmentId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeprecatedRetrieveInventoryAdjustmentResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<RetrieveInventoryAdjustmentResponse> deprecatedRetrieveInventoryAdjustmentAsync(String adjustmentId) {
        return this.makeHttpCallAsync(() -> this.buildDeprecatedRetrieveInventoryAdjustmentRequest(adjustmentId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeprecatedRetrieveInventoryAdjustmentResponse(context));
    }

    private HttpRequest buildDeprecatedRetrieveInventoryAdjustmentRequest(String adjustmentId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/adjustment/{adjustment_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("adjustment_id", new AbstractMap.SimpleEntry<String, Boolean>(adjustmentId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveInventoryAdjustmentResponse handleDeprecatedRetrieveInventoryAdjustmentResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveInventoryAdjustmentResponse result = ApiHelper.deserialize(responseBody, RetrieveInventoryAdjustmentResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveInventoryAdjustmentResponse retrieveInventoryAdjustment(String adjustmentId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveInventoryAdjustmentRequest(adjustmentId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveInventoryAdjustmentResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveInventoryAdjustmentResponse> retrieveInventoryAdjustmentAsync(String adjustmentId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveInventoryAdjustmentRequest(adjustmentId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveInventoryAdjustmentResponse(context));
    }

    private HttpRequest buildRetrieveInventoryAdjustmentRequest(String adjustmentId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/adjustments/{adjustment_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("adjustment_id", new AbstractMap.SimpleEntry<String, Boolean>(adjustmentId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveInventoryAdjustmentResponse handleRetrieveInventoryAdjustmentResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveInventoryAdjustmentResponse result = ApiHelper.deserialize(responseBody, RetrieveInventoryAdjustmentResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public BatchChangeInventoryResponse deprecatedBatchChangeInventory(BatchChangeInventoryRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildDeprecatedBatchChangeInventoryRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeprecatedBatchChangeInventoryResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<BatchChangeInventoryResponse> deprecatedBatchChangeInventoryAsync(BatchChangeInventoryRequest body) {
        return this.makeHttpCallAsync(() -> this.buildDeprecatedBatchChangeInventoryRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeprecatedBatchChangeInventoryResponse(context));
    }

    private HttpRequest buildDeprecatedBatchChangeInventoryRequest(BatchChangeInventoryRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/batch-change");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BatchChangeInventoryResponse handleDeprecatedBatchChangeInventoryResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BatchChangeInventoryResponse result = ApiHelper.deserialize(responseBody, BatchChangeInventoryResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public BatchRetrieveInventoryChangesResponse deprecatedBatchRetrieveInventoryChanges(BatchRetrieveInventoryChangesRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildDeprecatedBatchRetrieveInventoryChangesRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeprecatedBatchRetrieveInventoryChangesResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<BatchRetrieveInventoryChangesResponse> deprecatedBatchRetrieveInventoryChangesAsync(BatchRetrieveInventoryChangesRequest body) {
        return this.makeHttpCallAsync(() -> this.buildDeprecatedBatchRetrieveInventoryChangesRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeprecatedBatchRetrieveInventoryChangesResponse(context));
    }

    private HttpRequest buildDeprecatedBatchRetrieveInventoryChangesRequest(BatchRetrieveInventoryChangesRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/batch-retrieve-changes");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BatchRetrieveInventoryChangesResponse handleDeprecatedBatchRetrieveInventoryChangesResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BatchRetrieveInventoryChangesResponse result = ApiHelper.deserialize(responseBody, BatchRetrieveInventoryChangesResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public BatchRetrieveInventoryCountsResponse deprecatedBatchRetrieveInventoryCounts(BatchRetrieveInventoryCountsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildDeprecatedBatchRetrieveInventoryCountsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeprecatedBatchRetrieveInventoryCountsResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<BatchRetrieveInventoryCountsResponse> deprecatedBatchRetrieveInventoryCountsAsync(BatchRetrieveInventoryCountsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildDeprecatedBatchRetrieveInventoryCountsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeprecatedBatchRetrieveInventoryCountsResponse(context));
    }

    private HttpRequest buildDeprecatedBatchRetrieveInventoryCountsRequest(BatchRetrieveInventoryCountsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/batch-retrieve-counts");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BatchRetrieveInventoryCountsResponse handleDeprecatedBatchRetrieveInventoryCountsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BatchRetrieveInventoryCountsResponse result = ApiHelper.deserialize(responseBody, BatchRetrieveInventoryCountsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public BatchChangeInventoryResponse batchChangeInventory(BatchChangeInventoryRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildBatchChangeInventoryRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleBatchChangeInventoryResponse(context);
    }

    @Override
    public CompletableFuture<BatchChangeInventoryResponse> batchChangeInventoryAsync(BatchChangeInventoryRequest body) {
        return this.makeHttpCallAsync(() -> this.buildBatchChangeInventoryRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleBatchChangeInventoryResponse(context));
    }

    private HttpRequest buildBatchChangeInventoryRequest(BatchChangeInventoryRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/changes/batch-create");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BatchChangeInventoryResponse handleBatchChangeInventoryResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BatchChangeInventoryResponse result = ApiHelper.deserialize(responseBody, BatchChangeInventoryResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public BatchRetrieveInventoryChangesResponse batchRetrieveInventoryChanges(BatchRetrieveInventoryChangesRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildBatchRetrieveInventoryChangesRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleBatchRetrieveInventoryChangesResponse(context);
    }

    @Override
    public CompletableFuture<BatchRetrieveInventoryChangesResponse> batchRetrieveInventoryChangesAsync(BatchRetrieveInventoryChangesRequest body) {
        return this.makeHttpCallAsync(() -> this.buildBatchRetrieveInventoryChangesRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleBatchRetrieveInventoryChangesResponse(context));
    }

    private HttpRequest buildBatchRetrieveInventoryChangesRequest(BatchRetrieveInventoryChangesRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/changes/batch-retrieve");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BatchRetrieveInventoryChangesResponse handleBatchRetrieveInventoryChangesResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BatchRetrieveInventoryChangesResponse result = ApiHelper.deserialize(responseBody, BatchRetrieveInventoryChangesResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public BatchRetrieveInventoryCountsResponse batchRetrieveInventoryCounts(BatchRetrieveInventoryCountsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildBatchRetrieveInventoryCountsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleBatchRetrieveInventoryCountsResponse(context);
    }

    @Override
    public CompletableFuture<BatchRetrieveInventoryCountsResponse> batchRetrieveInventoryCountsAsync(BatchRetrieveInventoryCountsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildBatchRetrieveInventoryCountsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleBatchRetrieveInventoryCountsResponse(context));
    }

    private HttpRequest buildBatchRetrieveInventoryCountsRequest(BatchRetrieveInventoryCountsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/counts/batch-retrieve");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BatchRetrieveInventoryCountsResponse handleBatchRetrieveInventoryCountsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BatchRetrieveInventoryCountsResponse result = ApiHelper.deserialize(responseBody, BatchRetrieveInventoryCountsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public RetrieveInventoryPhysicalCountResponse deprecatedRetrieveInventoryPhysicalCount(String physicalCountId) throws ApiException, IOException {
        HttpRequest request = this.buildDeprecatedRetrieveInventoryPhysicalCountRequest(physicalCountId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeprecatedRetrieveInventoryPhysicalCountResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<RetrieveInventoryPhysicalCountResponse> deprecatedRetrieveInventoryPhysicalCountAsync(String physicalCountId) {
        return this.makeHttpCallAsync(() -> this.buildDeprecatedRetrieveInventoryPhysicalCountRequest(physicalCountId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeprecatedRetrieveInventoryPhysicalCountResponse(context));
    }

    private HttpRequest buildDeprecatedRetrieveInventoryPhysicalCountRequest(String physicalCountId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/physical-count/{physical_count_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("physical_count_id", new AbstractMap.SimpleEntry<String, Boolean>(physicalCountId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveInventoryPhysicalCountResponse handleDeprecatedRetrieveInventoryPhysicalCountResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveInventoryPhysicalCountResponse result = ApiHelper.deserialize(responseBody, RetrieveInventoryPhysicalCountResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveInventoryPhysicalCountResponse retrieveInventoryPhysicalCount(String physicalCountId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveInventoryPhysicalCountRequest(physicalCountId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveInventoryPhysicalCountResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveInventoryPhysicalCountResponse> retrieveInventoryPhysicalCountAsync(String physicalCountId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveInventoryPhysicalCountRequest(physicalCountId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveInventoryPhysicalCountResponse(context));
    }

    private HttpRequest buildRetrieveInventoryPhysicalCountRequest(String physicalCountId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/physical-counts/{physical_count_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("physical_count_id", new AbstractMap.SimpleEntry<String, Boolean>(physicalCountId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveInventoryPhysicalCountResponse handleRetrieveInventoryPhysicalCountResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveInventoryPhysicalCountResponse result = ApiHelper.deserialize(responseBody, RetrieveInventoryPhysicalCountResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveInventoryTransferResponse retrieveInventoryTransfer(String transferId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveInventoryTransferRequest(transferId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveInventoryTransferResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveInventoryTransferResponse> retrieveInventoryTransferAsync(String transferId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveInventoryTransferRequest(transferId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveInventoryTransferResponse(context));
    }

    private HttpRequest buildRetrieveInventoryTransferRequest(String transferId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/transfers/{transfer_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("transfer_id", new AbstractMap.SimpleEntry<String, Boolean>(transferId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveInventoryTransferResponse handleRetrieveInventoryTransferResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveInventoryTransferResponse result = ApiHelper.deserialize(responseBody, RetrieveInventoryTransferResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveInventoryCountResponse retrieveInventoryCount(String catalogObjectId, String locationIds, String cursor) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveInventoryCountRequest(catalogObjectId, locationIds, cursor);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveInventoryCountResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveInventoryCountResponse> retrieveInventoryCountAsync(String catalogObjectId, String locationIds, String cursor) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveInventoryCountRequest(catalogObjectId, locationIds, cursor), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveInventoryCountResponse(context));
    }

    private HttpRequest buildRetrieveInventoryCountRequest(String catalogObjectId, String locationIds, String cursor) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/{catalog_object_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("catalog_object_id", new AbstractMap.SimpleEntry<String, Boolean>(catalogObjectId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("location_ids", locationIds);
        queryParameters.put("cursor", cursor);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveInventoryCountResponse handleRetrieveInventoryCountResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveInventoryCountResponse result = ApiHelper.deserialize(responseBody, RetrieveInventoryCountResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public RetrieveInventoryChangesResponse retrieveInventoryChanges(String catalogObjectId, String locationIds, String cursor) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveInventoryChangesRequest(catalogObjectId, locationIds, cursor);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveInventoryChangesResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<RetrieveInventoryChangesResponse> retrieveInventoryChangesAsync(String catalogObjectId, String locationIds, String cursor) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveInventoryChangesRequest(catalogObjectId, locationIds, cursor), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveInventoryChangesResponse(context));
    }

    private HttpRequest buildRetrieveInventoryChangesRequest(String catalogObjectId, String locationIds, String cursor) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/inventory/{catalog_object_id}/changes");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("catalog_object_id", new AbstractMap.SimpleEntry<String, Boolean>(catalogObjectId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("location_ids", locationIds);
        queryParameters.put("cursor", cursor);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveInventoryChangesResponse handleRetrieveInventoryChangesResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveInventoryChangesResponse result = ApiHelper.deserialize(responseBody, RetrieveInventoryChangesResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

