/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.LocationsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.CreateLocationRequest;
import com.squareup.square.models.CreateLocationResponse;
import com.squareup.square.models.ListLocationsResponse;
import com.squareup.square.models.RetrieveLocationResponse;
import com.squareup.square.models.UpdateLocationRequest;
import com.squareup.square.models.UpdateLocationResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultLocationsApi
extends BaseApi
implements LocationsApi {
    public DefaultLocationsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultLocationsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListLocationsResponse listLocations() throws ApiException, IOException {
        HttpRequest request = this.buildListLocationsRequest();
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListLocationsResponse(context);
    }

    @Override
    public CompletableFuture<ListLocationsResponse> listLocationsAsync() {
        return this.makeHttpCallAsync(() -> this.buildListLocationsRequest(), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListLocationsResponse(context));
    }

    private HttpRequest buildListLocationsRequest() {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/locations");
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListLocationsResponse handleListLocationsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListLocationsResponse result = ApiHelper.deserialize(responseBody, ListLocationsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateLocationResponse createLocation(CreateLocationRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateLocationRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateLocationResponse(context);
    }

    @Override
    public CompletableFuture<CreateLocationResponse> createLocationAsync(CreateLocationRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateLocationRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateLocationResponse(context));
    }

    private HttpRequest buildCreateLocationRequest(CreateLocationRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/locations");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateLocationResponse handleCreateLocationResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateLocationResponse result = ApiHelper.deserialize(responseBody, CreateLocationResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveLocationResponse retrieveLocation(String locationId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveLocationRequest(locationId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveLocationResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveLocationResponse> retrieveLocationAsync(String locationId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveLocationRequest(locationId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveLocationResponse(context));
    }

    private HttpRequest buildRetrieveLocationRequest(String locationId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/locations/{location_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveLocationResponse handleRetrieveLocationResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveLocationResponse result = ApiHelper.deserialize(responseBody, RetrieveLocationResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdateLocationResponse updateLocation(String locationId, UpdateLocationRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateLocationRequest(locationId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateLocationResponse(context);
    }

    @Override
    public CompletableFuture<UpdateLocationResponse> updateLocationAsync(String locationId, UpdateLocationRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateLocationRequest(locationId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateLocationResponse(context));
    }

    private HttpRequest buildUpdateLocationRequest(String locationId, UpdateLocationRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/locations/{location_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpdateLocationResponse handleUpdateLocationResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdateLocationResponse result = ApiHelper.deserialize(responseBody, UpdateLocationResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

