/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.LoyaltyApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.AccumulateLoyaltyPointsRequest;
import com.squareup.square.models.AccumulateLoyaltyPointsResponse;
import com.squareup.square.models.AdjustLoyaltyPointsRequest;
import com.squareup.square.models.AdjustLoyaltyPointsResponse;
import com.squareup.square.models.CalculateLoyaltyPointsRequest;
import com.squareup.square.models.CalculateLoyaltyPointsResponse;
import com.squareup.square.models.CreateLoyaltyAccountRequest;
import com.squareup.square.models.CreateLoyaltyAccountResponse;
import com.squareup.square.models.CreateLoyaltyRewardRequest;
import com.squareup.square.models.CreateLoyaltyRewardResponse;
import com.squareup.square.models.DeleteLoyaltyRewardResponse;
import com.squareup.square.models.ListLoyaltyProgramsResponse;
import com.squareup.square.models.RedeemLoyaltyRewardRequest;
import com.squareup.square.models.RedeemLoyaltyRewardResponse;
import com.squareup.square.models.RetrieveLoyaltyAccountResponse;
import com.squareup.square.models.RetrieveLoyaltyProgramResponse;
import com.squareup.square.models.RetrieveLoyaltyRewardResponse;
import com.squareup.square.models.SearchLoyaltyAccountsRequest;
import com.squareup.square.models.SearchLoyaltyAccountsResponse;
import com.squareup.square.models.SearchLoyaltyEventsRequest;
import com.squareup.square.models.SearchLoyaltyEventsResponse;
import com.squareup.square.models.SearchLoyaltyRewardsRequest;
import com.squareup.square.models.SearchLoyaltyRewardsResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultLoyaltyApi
extends BaseApi
implements LoyaltyApi {
    public DefaultLoyaltyApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultLoyaltyApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public CreateLoyaltyAccountResponse createLoyaltyAccount(CreateLoyaltyAccountRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateLoyaltyAccountRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateLoyaltyAccountResponse(context);
    }

    @Override
    public CompletableFuture<CreateLoyaltyAccountResponse> createLoyaltyAccountAsync(CreateLoyaltyAccountRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateLoyaltyAccountRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateLoyaltyAccountResponse(context));
    }

    private HttpRequest buildCreateLoyaltyAccountRequest(CreateLoyaltyAccountRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/accounts");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateLoyaltyAccountResponse handleCreateLoyaltyAccountResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateLoyaltyAccountResponse result = ApiHelper.deserialize(responseBody, CreateLoyaltyAccountResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchLoyaltyAccountsResponse searchLoyaltyAccounts(SearchLoyaltyAccountsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchLoyaltyAccountsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchLoyaltyAccountsResponse(context);
    }

    @Override
    public CompletableFuture<SearchLoyaltyAccountsResponse> searchLoyaltyAccountsAsync(SearchLoyaltyAccountsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchLoyaltyAccountsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchLoyaltyAccountsResponse(context));
    }

    private HttpRequest buildSearchLoyaltyAccountsRequest(SearchLoyaltyAccountsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/accounts/search");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchLoyaltyAccountsResponse handleSearchLoyaltyAccountsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchLoyaltyAccountsResponse result = ApiHelper.deserialize(responseBody, SearchLoyaltyAccountsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveLoyaltyAccountResponse retrieveLoyaltyAccount(String accountId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveLoyaltyAccountRequest(accountId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveLoyaltyAccountResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveLoyaltyAccountResponse> retrieveLoyaltyAccountAsync(String accountId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveLoyaltyAccountRequest(accountId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveLoyaltyAccountResponse(context));
    }

    private HttpRequest buildRetrieveLoyaltyAccountRequest(String accountId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/accounts/{account_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("account_id", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveLoyaltyAccountResponse handleRetrieveLoyaltyAccountResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveLoyaltyAccountResponse result = ApiHelper.deserialize(responseBody, RetrieveLoyaltyAccountResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public AccumulateLoyaltyPointsResponse accumulateLoyaltyPoints(String accountId, AccumulateLoyaltyPointsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildAccumulateLoyaltyPointsRequest(accountId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleAccumulateLoyaltyPointsResponse(context);
    }

    @Override
    public CompletableFuture<AccumulateLoyaltyPointsResponse> accumulateLoyaltyPointsAsync(String accountId, AccumulateLoyaltyPointsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildAccumulateLoyaltyPointsRequest(accountId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleAccumulateLoyaltyPointsResponse(context));
    }

    private HttpRequest buildAccumulateLoyaltyPointsRequest(String accountId, AccumulateLoyaltyPointsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/accounts/{account_id}/accumulate");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("account_id", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private AccumulateLoyaltyPointsResponse handleAccumulateLoyaltyPointsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        AccumulateLoyaltyPointsResponse result = ApiHelper.deserialize(responseBody, AccumulateLoyaltyPointsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public AdjustLoyaltyPointsResponse adjustLoyaltyPoints(String accountId, AdjustLoyaltyPointsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildAdjustLoyaltyPointsRequest(accountId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleAdjustLoyaltyPointsResponse(context);
    }

    @Override
    public CompletableFuture<AdjustLoyaltyPointsResponse> adjustLoyaltyPointsAsync(String accountId, AdjustLoyaltyPointsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildAdjustLoyaltyPointsRequest(accountId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleAdjustLoyaltyPointsResponse(context));
    }

    private HttpRequest buildAdjustLoyaltyPointsRequest(String accountId, AdjustLoyaltyPointsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/accounts/{account_id}/adjust");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("account_id", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private AdjustLoyaltyPointsResponse handleAdjustLoyaltyPointsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        AdjustLoyaltyPointsResponse result = ApiHelper.deserialize(responseBody, AdjustLoyaltyPointsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchLoyaltyEventsResponse searchLoyaltyEvents(SearchLoyaltyEventsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchLoyaltyEventsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchLoyaltyEventsResponse(context);
    }

    @Override
    public CompletableFuture<SearchLoyaltyEventsResponse> searchLoyaltyEventsAsync(SearchLoyaltyEventsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchLoyaltyEventsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchLoyaltyEventsResponse(context));
    }

    private HttpRequest buildSearchLoyaltyEventsRequest(SearchLoyaltyEventsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/events/search");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchLoyaltyEventsResponse handleSearchLoyaltyEventsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchLoyaltyEventsResponse result = ApiHelper.deserialize(responseBody, SearchLoyaltyEventsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public ListLoyaltyProgramsResponse listLoyaltyPrograms() throws ApiException, IOException {
        HttpRequest request = this.buildListLoyaltyProgramsRequest();
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListLoyaltyProgramsResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<ListLoyaltyProgramsResponse> listLoyaltyProgramsAsync() {
        return this.makeHttpCallAsync(() -> this.buildListLoyaltyProgramsRequest(), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListLoyaltyProgramsResponse(context));
    }

    private HttpRequest buildListLoyaltyProgramsRequest() {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/programs");
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListLoyaltyProgramsResponse handleListLoyaltyProgramsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListLoyaltyProgramsResponse result = ApiHelper.deserialize(responseBody, ListLoyaltyProgramsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveLoyaltyProgramResponse retrieveLoyaltyProgram(String programId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveLoyaltyProgramRequest(programId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveLoyaltyProgramResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveLoyaltyProgramResponse> retrieveLoyaltyProgramAsync(String programId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveLoyaltyProgramRequest(programId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveLoyaltyProgramResponse(context));
    }

    private HttpRequest buildRetrieveLoyaltyProgramRequest(String programId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/programs/{program_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("program_id", new AbstractMap.SimpleEntry<String, Boolean>(programId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveLoyaltyProgramResponse handleRetrieveLoyaltyProgramResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveLoyaltyProgramResponse result = ApiHelper.deserialize(responseBody, RetrieveLoyaltyProgramResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CalculateLoyaltyPointsResponse calculateLoyaltyPoints(String programId, CalculateLoyaltyPointsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCalculateLoyaltyPointsRequest(programId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCalculateLoyaltyPointsResponse(context);
    }

    @Override
    public CompletableFuture<CalculateLoyaltyPointsResponse> calculateLoyaltyPointsAsync(String programId, CalculateLoyaltyPointsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCalculateLoyaltyPointsRequest(programId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCalculateLoyaltyPointsResponse(context));
    }

    private HttpRequest buildCalculateLoyaltyPointsRequest(String programId, CalculateLoyaltyPointsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/programs/{program_id}/calculate");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("program_id", new AbstractMap.SimpleEntry<String, Boolean>(programId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CalculateLoyaltyPointsResponse handleCalculateLoyaltyPointsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CalculateLoyaltyPointsResponse result = ApiHelper.deserialize(responseBody, CalculateLoyaltyPointsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateLoyaltyRewardResponse createLoyaltyReward(CreateLoyaltyRewardRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateLoyaltyRewardRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateLoyaltyRewardResponse(context);
    }

    @Override
    public CompletableFuture<CreateLoyaltyRewardResponse> createLoyaltyRewardAsync(CreateLoyaltyRewardRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateLoyaltyRewardRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateLoyaltyRewardResponse(context));
    }

    private HttpRequest buildCreateLoyaltyRewardRequest(CreateLoyaltyRewardRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/rewards");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateLoyaltyRewardResponse handleCreateLoyaltyRewardResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateLoyaltyRewardResponse result = ApiHelper.deserialize(responseBody, CreateLoyaltyRewardResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchLoyaltyRewardsResponse searchLoyaltyRewards(SearchLoyaltyRewardsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchLoyaltyRewardsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchLoyaltyRewardsResponse(context);
    }

    @Override
    public CompletableFuture<SearchLoyaltyRewardsResponse> searchLoyaltyRewardsAsync(SearchLoyaltyRewardsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchLoyaltyRewardsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchLoyaltyRewardsResponse(context));
    }

    private HttpRequest buildSearchLoyaltyRewardsRequest(SearchLoyaltyRewardsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/rewards/search");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchLoyaltyRewardsResponse handleSearchLoyaltyRewardsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchLoyaltyRewardsResponse result = ApiHelper.deserialize(responseBody, SearchLoyaltyRewardsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public DeleteLoyaltyRewardResponse deleteLoyaltyReward(String rewardId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteLoyaltyRewardRequest(rewardId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteLoyaltyRewardResponse(context);
    }

    @Override
    public CompletableFuture<DeleteLoyaltyRewardResponse> deleteLoyaltyRewardAsync(String rewardId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteLoyaltyRewardRequest(rewardId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteLoyaltyRewardResponse(context));
    }

    private HttpRequest buildDeleteLoyaltyRewardRequest(String rewardId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/rewards/{reward_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("reward_id", new AbstractMap.SimpleEntry<String, Boolean>(rewardId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private DeleteLoyaltyRewardResponse handleDeleteLoyaltyRewardResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        DeleteLoyaltyRewardResponse result = ApiHelper.deserialize(responseBody, DeleteLoyaltyRewardResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveLoyaltyRewardResponse retrieveLoyaltyReward(String rewardId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveLoyaltyRewardRequest(rewardId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveLoyaltyRewardResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveLoyaltyRewardResponse> retrieveLoyaltyRewardAsync(String rewardId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveLoyaltyRewardRequest(rewardId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveLoyaltyRewardResponse(context));
    }

    private HttpRequest buildRetrieveLoyaltyRewardRequest(String rewardId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/rewards/{reward_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("reward_id", new AbstractMap.SimpleEntry<String, Boolean>(rewardId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveLoyaltyRewardResponse handleRetrieveLoyaltyRewardResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveLoyaltyRewardResponse result = ApiHelper.deserialize(responseBody, RetrieveLoyaltyRewardResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RedeemLoyaltyRewardResponse redeemLoyaltyReward(String rewardId, RedeemLoyaltyRewardRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildRedeemLoyaltyRewardRequest(rewardId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRedeemLoyaltyRewardResponse(context);
    }

    @Override
    public CompletableFuture<RedeemLoyaltyRewardResponse> redeemLoyaltyRewardAsync(String rewardId, RedeemLoyaltyRewardRequest body) {
        return this.makeHttpCallAsync(() -> this.buildRedeemLoyaltyRewardRequest(rewardId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRedeemLoyaltyRewardResponse(context));
    }

    private HttpRequest buildRedeemLoyaltyRewardRequest(String rewardId, RedeemLoyaltyRewardRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/loyalty/rewards/{reward_id}/redeem");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("reward_id", new AbstractMap.SimpleEntry<String, Boolean>(rewardId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RedeemLoyaltyRewardResponse handleRedeemLoyaltyRewardResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RedeemLoyaltyRewardResponse result = ApiHelper.deserialize(responseBody, RedeemLoyaltyRewardResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

