/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.OAuthApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.ObtainTokenRequest;
import com.squareup.square.models.ObtainTokenResponse;
import com.squareup.square.models.RenewTokenRequest;
import com.squareup.square.models.RenewTokenResponse;
import com.squareup.square.models.RevokeTokenRequest;
import com.squareup.square.models.RevokeTokenResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultOAuthApi
extends BaseApi
implements OAuthApi {
    public DefaultOAuthApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultOAuthApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    @Deprecated
    public RenewTokenResponse renewToken(String clientId, RenewTokenRequest body, String authorization) throws ApiException, IOException {
        HttpRequest request = this.buildRenewTokenRequest(clientId, body, authorization);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRenewTokenResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<RenewTokenResponse> renewTokenAsync(String clientId, RenewTokenRequest body, String authorization) {
        return this.makeHttpCallAsync(() -> this.buildRenewTokenRequest(clientId, body, authorization), request -> this.getClientInstance().executeAsync(request, false), context -> this.handleRenewTokenResponse(context));
    }

    private HttpRequest buildRenewTokenRequest(String clientId, RenewTokenRequest body, String authorization) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/oauth2/clients/{client_id}/access-token/renew");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("client_id", new AbstractMap.SimpleEntry<String, Boolean>(clientId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Authorization", authorization);
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RenewTokenResponse handleRenewTokenResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RenewTokenResponse result = ApiHelper.deserialize(responseBody, RenewTokenResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RevokeTokenResponse revokeToken(RevokeTokenRequest body, String authorization) throws ApiException, IOException {
        HttpRequest request = this.buildRevokeTokenRequest(body, authorization);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRevokeTokenResponse(context);
    }

    @Override
    public CompletableFuture<RevokeTokenResponse> revokeTokenAsync(RevokeTokenRequest body, String authorization) {
        return this.makeHttpCallAsync(() -> this.buildRevokeTokenRequest(body, authorization), request -> this.getClientInstance().executeAsync(request, false), context -> this.handleRevokeTokenResponse(context));
    }

    private HttpRequest buildRevokeTokenRequest(RevokeTokenRequest body, String authorization) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/oauth2/revoke");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Authorization", authorization);
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RevokeTokenResponse handleRevokeTokenResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RevokeTokenResponse result = ApiHelper.deserialize(responseBody, RevokeTokenResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public ObtainTokenResponse obtainToken(ObtainTokenRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildObtainTokenRequest(body);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleObtainTokenResponse(context);
    }

    @Override
    public CompletableFuture<ObtainTokenResponse> obtainTokenAsync(ObtainTokenRequest body) {
        return this.makeHttpCallAsync(() -> this.buildObtainTokenRequest(body), request -> this.getClientInstance().executeAsync(request, false), context -> this.handleObtainTokenResponse(context));
    }

    private HttpRequest buildObtainTokenRequest(ObtainTokenRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/oauth2/token");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ObtainTokenResponse handleObtainTokenResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ObtainTokenResponse result = ApiHelper.deserialize(responseBody, ObtainTokenResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

