/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.PaymentsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.CancelPaymentByIdempotencyKeyRequest;
import com.squareup.square.models.CancelPaymentByIdempotencyKeyResponse;
import com.squareup.square.models.CancelPaymentResponse;
import com.squareup.square.models.CompletePaymentRequest;
import com.squareup.square.models.CompletePaymentResponse;
import com.squareup.square.models.CreatePaymentRequest;
import com.squareup.square.models.CreatePaymentResponse;
import com.squareup.square.models.GetPaymentResponse;
import com.squareup.square.models.ListPaymentsResponse;
import com.squareup.square.models.UpdatePaymentRequest;
import com.squareup.square.models.UpdatePaymentResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultPaymentsApi
extends BaseApi
implements PaymentsApi {
    public DefaultPaymentsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultPaymentsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListPaymentsResponse listPayments(String beginTime, String endTime, String sortOrder, String cursor, String locationId, Long total, String last4, String cardBrand, Integer limit) throws ApiException, IOException {
        HttpRequest request = this.buildListPaymentsRequest(beginTime, endTime, sortOrder, cursor, locationId, total, last4, cardBrand, limit);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListPaymentsResponse(context);
    }

    @Override
    public CompletableFuture<ListPaymentsResponse> listPaymentsAsync(String beginTime, String endTime, String sortOrder, String cursor, String locationId, Long total, String last4, String cardBrand, Integer limit) {
        return this.makeHttpCallAsync(() -> this.buildListPaymentsRequest(beginTime, endTime, sortOrder, cursor, locationId, total, last4, cardBrand, limit), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListPaymentsResponse(context));
    }

    private HttpRequest buildListPaymentsRequest(String beginTime, String endTime, String sortOrder, String cursor, String locationId, Long total, String last4, String cardBrand, Integer limit) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/payments");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("begin_time", beginTime);
        queryParameters.put("end_time", endTime);
        queryParameters.put("sort_order", sortOrder);
        queryParameters.put("cursor", cursor);
        queryParameters.put("location_id", locationId);
        queryParameters.put("total", total);
        queryParameters.put("last_4", last4);
        queryParameters.put("card_brand", cardBrand);
        queryParameters.put("limit", limit);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListPaymentsResponse handleListPaymentsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListPaymentsResponse result = ApiHelper.deserialize(responseBody, ListPaymentsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreatePaymentResponse createPayment(CreatePaymentRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreatePaymentRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreatePaymentResponse(context);
    }

    @Override
    public CompletableFuture<CreatePaymentResponse> createPaymentAsync(CreatePaymentRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreatePaymentRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreatePaymentResponse(context));
    }

    private HttpRequest buildCreatePaymentRequest(CreatePaymentRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/payments");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreatePaymentResponse handleCreatePaymentResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreatePaymentResponse result = ApiHelper.deserialize(responseBody, CreatePaymentResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CancelPaymentByIdempotencyKeyResponse cancelPaymentByIdempotencyKey(CancelPaymentByIdempotencyKeyRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCancelPaymentByIdempotencyKeyRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCancelPaymentByIdempotencyKeyResponse(context);
    }

    @Override
    public CompletableFuture<CancelPaymentByIdempotencyKeyResponse> cancelPaymentByIdempotencyKeyAsync(CancelPaymentByIdempotencyKeyRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCancelPaymentByIdempotencyKeyRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCancelPaymentByIdempotencyKeyResponse(context));
    }

    private HttpRequest buildCancelPaymentByIdempotencyKeyRequest(CancelPaymentByIdempotencyKeyRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/payments/cancel");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CancelPaymentByIdempotencyKeyResponse handleCancelPaymentByIdempotencyKeyResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CancelPaymentByIdempotencyKeyResponse result = ApiHelper.deserialize(responseBody, CancelPaymentByIdempotencyKeyResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public GetPaymentResponse getPayment(String paymentId) throws ApiException, IOException {
        HttpRequest request = this.buildGetPaymentRequest(paymentId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetPaymentResponse(context);
    }

    @Override
    public CompletableFuture<GetPaymentResponse> getPaymentAsync(String paymentId) {
        return this.makeHttpCallAsync(() -> this.buildGetPaymentRequest(paymentId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetPaymentResponse(context));
    }

    private HttpRequest buildGetPaymentRequest(String paymentId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/payments/{payment_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("payment_id", new AbstractMap.SimpleEntry<String, Boolean>(paymentId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private GetPaymentResponse handleGetPaymentResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        GetPaymentResponse result = ApiHelper.deserialize(responseBody, GetPaymentResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdatePaymentResponse updatePayment(String paymentId, UpdatePaymentRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdatePaymentRequest(paymentId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdatePaymentResponse(context);
    }

    @Override
    public CompletableFuture<UpdatePaymentResponse> updatePaymentAsync(String paymentId, UpdatePaymentRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdatePaymentRequest(paymentId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdatePaymentResponse(context));
    }

    private HttpRequest buildUpdatePaymentRequest(String paymentId, UpdatePaymentRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/payments/{payment_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("payment_id", new AbstractMap.SimpleEntry<String, Boolean>(paymentId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpdatePaymentResponse handleUpdatePaymentResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdatePaymentResponse result = ApiHelper.deserialize(responseBody, UpdatePaymentResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CancelPaymentResponse cancelPayment(String paymentId) throws ApiException, IOException {
        HttpRequest request = this.buildCancelPaymentRequest(paymentId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCancelPaymentResponse(context);
    }

    @Override
    public CompletableFuture<CancelPaymentResponse> cancelPaymentAsync(String paymentId) {
        return this.makeHttpCallAsync(() -> this.buildCancelPaymentRequest(paymentId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCancelPaymentResponse(context));
    }

    private HttpRequest buildCancelPaymentRequest(String paymentId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/payments/{payment_id}/cancel");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("payment_id", new AbstractMap.SimpleEntry<String, Boolean>(paymentId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().post(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CancelPaymentResponse handleCancelPaymentResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CancelPaymentResponse result = ApiHelper.deserialize(responseBody, CancelPaymentResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CompletePaymentResponse completePayment(String paymentId, CompletePaymentRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCompletePaymentRequest(paymentId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCompletePaymentResponse(context);
    }

    @Override
    public CompletableFuture<CompletePaymentResponse> completePaymentAsync(String paymentId, CompletePaymentRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCompletePaymentRequest(paymentId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCompletePaymentResponse(context));
    }

    private HttpRequest buildCompletePaymentRequest(String paymentId, CompletePaymentRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/payments/{payment_id}/complete");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("payment_id", new AbstractMap.SimpleEntry<String, Boolean>(paymentId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CompletePaymentResponse handleCompletePaymentResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CompletePaymentResponse result = ApiHelper.deserialize(responseBody, CompletePaymentResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

