/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.PayoutsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.GetPayoutResponse;
import com.squareup.square.models.ListPayoutEntriesResponse;
import com.squareup.square.models.ListPayoutsResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultPayoutsApi
extends BaseApi
implements PayoutsApi {
    public DefaultPayoutsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultPayoutsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListPayoutsResponse listPayouts(String locationId, String status, String beginTime, String endTime, String sortOrder, String cursor, Integer limit) throws ApiException, IOException {
        HttpRequest request = this.buildListPayoutsRequest(locationId, status, beginTime, endTime, sortOrder, cursor, limit);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListPayoutsResponse(context);
    }

    @Override
    public CompletableFuture<ListPayoutsResponse> listPayoutsAsync(String locationId, String status, String beginTime, String endTime, String sortOrder, String cursor, Integer limit) {
        return this.makeHttpCallAsync(() -> this.buildListPayoutsRequest(locationId, status, beginTime, endTime, sortOrder, cursor, limit), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListPayoutsResponse(context));
    }

    private HttpRequest buildListPayoutsRequest(String locationId, String status, String beginTime, String endTime, String sortOrder, String cursor, Integer limit) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/payouts");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("location_id", locationId);
        queryParameters.put("status", status);
        queryParameters.put("begin_time", beginTime);
        queryParameters.put("end_time", endTime);
        queryParameters.put("sort_order", sortOrder);
        queryParameters.put("cursor", cursor);
        queryParameters.put("limit", limit);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListPayoutsResponse handleListPayoutsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListPayoutsResponse result = ApiHelper.deserialize(responseBody, ListPayoutsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public GetPayoutResponse getPayout(String payoutId) throws ApiException, IOException {
        HttpRequest request = this.buildGetPayoutRequest(payoutId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetPayoutResponse(context);
    }

    @Override
    public CompletableFuture<GetPayoutResponse> getPayoutAsync(String payoutId) {
        return this.makeHttpCallAsync(() -> this.buildGetPayoutRequest(payoutId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetPayoutResponse(context));
    }

    private HttpRequest buildGetPayoutRequest(String payoutId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/payouts/{payout_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("payout_id", new AbstractMap.SimpleEntry<String, Boolean>(payoutId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private GetPayoutResponse handleGetPayoutResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        GetPayoutResponse result = ApiHelper.deserialize(responseBody, GetPayoutResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public ListPayoutEntriesResponse listPayoutEntries(String payoutId, String sortOrder, String cursor, Integer limit) throws ApiException, IOException {
        HttpRequest request = this.buildListPayoutEntriesRequest(payoutId, sortOrder, cursor, limit);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListPayoutEntriesResponse(context);
    }

    @Override
    public CompletableFuture<ListPayoutEntriesResponse> listPayoutEntriesAsync(String payoutId, String sortOrder, String cursor, Integer limit) {
        return this.makeHttpCallAsync(() -> this.buildListPayoutEntriesRequest(payoutId, sortOrder, cursor, limit), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListPayoutEntriesResponse(context));
    }

    private HttpRequest buildListPayoutEntriesRequest(String payoutId, String sortOrder, String cursor, Integer limit) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/payouts/{payout_id}/payout-entries");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("payout_id", new AbstractMap.SimpleEntry<String, Boolean>(payoutId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("sort_order", sortOrder);
        queryParameters.put("cursor", cursor);
        queryParameters.put("limit", limit);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListPayoutEntriesResponse handleListPayoutEntriesResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListPayoutEntriesResponse result = ApiHelper.deserialize(responseBody, ListPayoutEntriesResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

