/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.RefundsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.GetPaymentRefundResponse;
import com.squareup.square.models.ListPaymentRefundsResponse;
import com.squareup.square.models.RefundPaymentRequest;
import com.squareup.square.models.RefundPaymentResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultRefundsApi
extends BaseApi
implements RefundsApi {
    public DefaultRefundsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultRefundsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public ListPaymentRefundsResponse listPaymentRefunds(String beginTime, String endTime, String sortOrder, String cursor, String locationId, String status, String sourceType, Integer limit) throws ApiException, IOException {
        HttpRequest request = this.buildListPaymentRefundsRequest(beginTime, endTime, sortOrder, cursor, locationId, status, sourceType, limit);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListPaymentRefundsResponse(context);
    }

    @Override
    public CompletableFuture<ListPaymentRefundsResponse> listPaymentRefundsAsync(String beginTime, String endTime, String sortOrder, String cursor, String locationId, String status, String sourceType, Integer limit) {
        return this.makeHttpCallAsync(() -> this.buildListPaymentRefundsRequest(beginTime, endTime, sortOrder, cursor, locationId, status, sourceType, limit), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListPaymentRefundsResponse(context));
    }

    private HttpRequest buildListPaymentRefundsRequest(String beginTime, String endTime, String sortOrder, String cursor, String locationId, String status, String sourceType, Integer limit) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/refunds");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("begin_time", beginTime);
        queryParameters.put("end_time", endTime);
        queryParameters.put("sort_order", sortOrder);
        queryParameters.put("cursor", cursor);
        queryParameters.put("location_id", locationId);
        queryParameters.put("status", status);
        queryParameters.put("source_type", sourceType);
        queryParameters.put("limit", limit);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListPaymentRefundsResponse handleListPaymentRefundsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListPaymentRefundsResponse result = ApiHelper.deserialize(responseBody, ListPaymentRefundsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RefundPaymentResponse refundPayment(RefundPaymentRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildRefundPaymentRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRefundPaymentResponse(context);
    }

    @Override
    public CompletableFuture<RefundPaymentResponse> refundPaymentAsync(RefundPaymentRequest body) {
        return this.makeHttpCallAsync(() -> this.buildRefundPaymentRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRefundPaymentResponse(context));
    }

    private HttpRequest buildRefundPaymentRequest(RefundPaymentRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/refunds");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RefundPaymentResponse handleRefundPaymentResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RefundPaymentResponse result = ApiHelper.deserialize(responseBody, RefundPaymentResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public GetPaymentRefundResponse getPaymentRefund(String refundId) throws ApiException, IOException {
        HttpRequest request = this.buildGetPaymentRefundRequest(refundId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetPaymentRefundResponse(context);
    }

    @Override
    public CompletableFuture<GetPaymentRefundResponse> getPaymentRefundAsync(String refundId) {
        return this.makeHttpCallAsync(() -> this.buildGetPaymentRefundRequest(refundId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetPaymentRefundResponse(context));
    }

    private HttpRequest buildGetPaymentRefundRequest(String refundId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/refunds/{refund_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("refund_id", new AbstractMap.SimpleEntry<String, Boolean>(refundId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private GetPaymentRefundResponse handleGetPaymentRefundResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        GetPaymentRefundResponse result = ApiHelper.deserialize(responseBody, GetPaymentRefundResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

