/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.SnippetsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.DeleteSnippetResponse;
import com.squareup.square.models.RetrieveSnippetResponse;
import com.squareup.square.models.UpsertSnippetRequest;
import com.squareup.square.models.UpsertSnippetResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultSnippetsApi
extends BaseApi
implements SnippetsApi {
    public DefaultSnippetsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultSnippetsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public DeleteSnippetResponse deleteSnippet(String siteId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteSnippetRequest(siteId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteSnippetResponse(context);
    }

    @Override
    public CompletableFuture<DeleteSnippetResponse> deleteSnippetAsync(String siteId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteSnippetRequest(siteId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteSnippetResponse(context));
    }

    private HttpRequest buildDeleteSnippetRequest(String siteId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/sites/{site_id}/snippet");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("site_id", new AbstractMap.SimpleEntry<String, Boolean>(siteId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private DeleteSnippetResponse handleDeleteSnippetResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        DeleteSnippetResponse result = ApiHelper.deserialize(responseBody, DeleteSnippetResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveSnippetResponse retrieveSnippet(String siteId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveSnippetRequest(siteId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveSnippetResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveSnippetResponse> retrieveSnippetAsync(String siteId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveSnippetRequest(siteId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveSnippetResponse(context));
    }

    private HttpRequest buildRetrieveSnippetRequest(String siteId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/sites/{site_id}/snippet");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("site_id", new AbstractMap.SimpleEntry<String, Boolean>(siteId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveSnippetResponse handleRetrieveSnippetResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveSnippetResponse result = ApiHelper.deserialize(responseBody, RetrieveSnippetResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpsertSnippetResponse upsertSnippet(String siteId, UpsertSnippetRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpsertSnippetRequest(siteId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpsertSnippetResponse(context);
    }

    @Override
    public CompletableFuture<UpsertSnippetResponse> upsertSnippetAsync(String siteId, UpsertSnippetRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpsertSnippetRequest(siteId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpsertSnippetResponse(context));
    }

    private HttpRequest buildUpsertSnippetRequest(String siteId, UpsertSnippetRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/sites/{site_id}/snippet");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("site_id", new AbstractMap.SimpleEntry<String, Boolean>(siteId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpsertSnippetResponse handleUpsertSnippetResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpsertSnippetResponse result = ApiHelper.deserialize(responseBody, UpsertSnippetResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

