/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.SubscriptionsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.CancelSubscriptionResponse;
import com.squareup.square.models.CreateSubscriptionRequest;
import com.squareup.square.models.CreateSubscriptionResponse;
import com.squareup.square.models.DeleteSubscriptionActionResponse;
import com.squareup.square.models.ListSubscriptionEventsResponse;
import com.squareup.square.models.PauseSubscriptionRequest;
import com.squareup.square.models.PauseSubscriptionResponse;
import com.squareup.square.models.ResumeSubscriptionRequest;
import com.squareup.square.models.ResumeSubscriptionResponse;
import com.squareup.square.models.RetrieveSubscriptionResponse;
import com.squareup.square.models.SearchSubscriptionsRequest;
import com.squareup.square.models.SearchSubscriptionsResponse;
import com.squareup.square.models.SwapPlanRequest;
import com.squareup.square.models.SwapPlanResponse;
import com.squareup.square.models.UpdateSubscriptionRequest;
import com.squareup.square.models.UpdateSubscriptionResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultSubscriptionsApi
extends BaseApi
implements SubscriptionsApi {
    public DefaultSubscriptionsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultSubscriptionsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateSubscriptionRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateSubscriptionResponse(context);
    }

    @Override
    public CompletableFuture<CreateSubscriptionResponse> createSubscriptionAsync(CreateSubscriptionRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateSubscriptionRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateSubscriptionResponse(context));
    }

    private HttpRequest buildCreateSubscriptionRequest(CreateSubscriptionRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/subscriptions");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateSubscriptionResponse handleCreateSubscriptionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateSubscriptionResponse result = ApiHelper.deserialize(responseBody, CreateSubscriptionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchSubscriptionsResponse searchSubscriptions(SearchSubscriptionsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchSubscriptionsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchSubscriptionsResponse(context);
    }

    @Override
    public CompletableFuture<SearchSubscriptionsResponse> searchSubscriptionsAsync(SearchSubscriptionsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchSubscriptionsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchSubscriptionsResponse(context));
    }

    private HttpRequest buildSearchSubscriptionsRequest(SearchSubscriptionsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/subscriptions/search");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchSubscriptionsResponse handleSearchSubscriptionsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchSubscriptionsResponse result = ApiHelper.deserialize(responseBody, SearchSubscriptionsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveSubscriptionResponse retrieveSubscription(String subscriptionId, String include) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveSubscriptionRequest(subscriptionId, include);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveSubscriptionResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveSubscriptionResponse> retrieveSubscriptionAsync(String subscriptionId, String include) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveSubscriptionRequest(subscriptionId, include), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveSubscriptionResponse(context));
    }

    private HttpRequest buildRetrieveSubscriptionRequest(String subscriptionId, String include) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/subscriptions/{subscription_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("subscription_id", new AbstractMap.SimpleEntry<String, Boolean>(subscriptionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("include", include);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveSubscriptionResponse handleRetrieveSubscriptionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveSubscriptionResponse result = ApiHelper.deserialize(responseBody, RetrieveSubscriptionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdateSubscriptionResponse updateSubscription(String subscriptionId, UpdateSubscriptionRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateSubscriptionRequest(subscriptionId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateSubscriptionResponse(context);
    }

    @Override
    public CompletableFuture<UpdateSubscriptionResponse> updateSubscriptionAsync(String subscriptionId, UpdateSubscriptionRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateSubscriptionRequest(subscriptionId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateSubscriptionResponse(context));
    }

    private HttpRequest buildUpdateSubscriptionRequest(String subscriptionId, UpdateSubscriptionRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/subscriptions/{subscription_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("subscription_id", new AbstractMap.SimpleEntry<String, Boolean>(subscriptionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpdateSubscriptionResponse handleUpdateSubscriptionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdateSubscriptionResponse result = ApiHelper.deserialize(responseBody, UpdateSubscriptionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public DeleteSubscriptionActionResponse deleteSubscriptionAction(String subscriptionId, String actionId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteSubscriptionActionRequest(subscriptionId, actionId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteSubscriptionActionResponse(context);
    }

    @Override
    public CompletableFuture<DeleteSubscriptionActionResponse> deleteSubscriptionActionAsync(String subscriptionId, String actionId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteSubscriptionActionRequest(subscriptionId, actionId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteSubscriptionActionResponse(context));
    }

    private HttpRequest buildDeleteSubscriptionActionRequest(String subscriptionId, String actionId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/subscriptions/{subscription_id}/actions/{action_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("subscription_id", new AbstractMap.SimpleEntry<String, Boolean>(subscriptionId, true));
        templateParameters.put("action_id", new AbstractMap.SimpleEntry<String, Boolean>(actionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private DeleteSubscriptionActionResponse handleDeleteSubscriptionActionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        DeleteSubscriptionActionResponse result = ApiHelper.deserialize(responseBody, DeleteSubscriptionActionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CancelSubscriptionResponse cancelSubscription(String subscriptionId) throws ApiException, IOException {
        HttpRequest request = this.buildCancelSubscriptionRequest(subscriptionId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCancelSubscriptionResponse(context);
    }

    @Override
    public CompletableFuture<CancelSubscriptionResponse> cancelSubscriptionAsync(String subscriptionId) {
        return this.makeHttpCallAsync(() -> this.buildCancelSubscriptionRequest(subscriptionId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCancelSubscriptionResponse(context));
    }

    private HttpRequest buildCancelSubscriptionRequest(String subscriptionId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/subscriptions/{subscription_id}/cancel");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("subscription_id", new AbstractMap.SimpleEntry<String, Boolean>(subscriptionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().post(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CancelSubscriptionResponse handleCancelSubscriptionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CancelSubscriptionResponse result = ApiHelper.deserialize(responseBody, CancelSubscriptionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public ListSubscriptionEventsResponse listSubscriptionEvents(String subscriptionId, String cursor, Integer limit) throws ApiException, IOException {
        HttpRequest request = this.buildListSubscriptionEventsRequest(subscriptionId, cursor, limit);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListSubscriptionEventsResponse(context);
    }

    @Override
    public CompletableFuture<ListSubscriptionEventsResponse> listSubscriptionEventsAsync(String subscriptionId, String cursor, Integer limit) {
        return this.makeHttpCallAsync(() -> this.buildListSubscriptionEventsRequest(subscriptionId, cursor, limit), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListSubscriptionEventsResponse(context));
    }

    private HttpRequest buildListSubscriptionEventsRequest(String subscriptionId, String cursor, Integer limit) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/subscriptions/{subscription_id}/events");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("subscription_id", new AbstractMap.SimpleEntry<String, Boolean>(subscriptionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("cursor", cursor);
        queryParameters.put("limit", limit);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListSubscriptionEventsResponse handleListSubscriptionEventsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListSubscriptionEventsResponse result = ApiHelper.deserialize(responseBody, ListSubscriptionEventsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public PauseSubscriptionResponse pauseSubscription(String subscriptionId, PauseSubscriptionRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildPauseSubscriptionRequest(subscriptionId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handlePauseSubscriptionResponse(context);
    }

    @Override
    public CompletableFuture<PauseSubscriptionResponse> pauseSubscriptionAsync(String subscriptionId, PauseSubscriptionRequest body) {
        return this.makeHttpCallAsync(() -> this.buildPauseSubscriptionRequest(subscriptionId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handlePauseSubscriptionResponse(context));
    }

    private HttpRequest buildPauseSubscriptionRequest(String subscriptionId, PauseSubscriptionRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/subscriptions/{subscription_id}/pause");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("subscription_id", new AbstractMap.SimpleEntry<String, Boolean>(subscriptionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private PauseSubscriptionResponse handlePauseSubscriptionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        PauseSubscriptionResponse result = ApiHelper.deserialize(responseBody, PauseSubscriptionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public ResumeSubscriptionResponse resumeSubscription(String subscriptionId, ResumeSubscriptionRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildResumeSubscriptionRequest(subscriptionId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleResumeSubscriptionResponse(context);
    }

    @Override
    public CompletableFuture<ResumeSubscriptionResponse> resumeSubscriptionAsync(String subscriptionId, ResumeSubscriptionRequest body) {
        return this.makeHttpCallAsync(() -> this.buildResumeSubscriptionRequest(subscriptionId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleResumeSubscriptionResponse(context));
    }

    private HttpRequest buildResumeSubscriptionRequest(String subscriptionId, ResumeSubscriptionRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/subscriptions/{subscription_id}/resume");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("subscription_id", new AbstractMap.SimpleEntry<String, Boolean>(subscriptionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ResumeSubscriptionResponse handleResumeSubscriptionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ResumeSubscriptionResponse result = ApiHelper.deserialize(responseBody, ResumeSubscriptionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SwapPlanResponse swapPlan(String subscriptionId, SwapPlanRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSwapPlanRequest(subscriptionId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSwapPlanResponse(context);
    }

    @Override
    public CompletableFuture<SwapPlanResponse> swapPlanAsync(String subscriptionId, SwapPlanRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSwapPlanRequest(subscriptionId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSwapPlanResponse(context));
    }

    private HttpRequest buildSwapPlanRequest(String subscriptionId, SwapPlanRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/subscriptions/{subscription_id}/swap-plan");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("subscription_id", new AbstractMap.SimpleEntry<String, Boolean>(subscriptionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SwapPlanResponse handleSwapPlanResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SwapPlanResponse result = ApiHelper.deserialize(responseBody, SwapPlanResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

