/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.TeamApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.BulkCreateTeamMembersRequest;
import com.squareup.square.models.BulkCreateTeamMembersResponse;
import com.squareup.square.models.BulkUpdateTeamMembersRequest;
import com.squareup.square.models.BulkUpdateTeamMembersResponse;
import com.squareup.square.models.CreateTeamMemberRequest;
import com.squareup.square.models.CreateTeamMemberResponse;
import com.squareup.square.models.RetrieveTeamMemberResponse;
import com.squareup.square.models.RetrieveWageSettingResponse;
import com.squareup.square.models.SearchTeamMembersRequest;
import com.squareup.square.models.SearchTeamMembersResponse;
import com.squareup.square.models.UpdateTeamMemberRequest;
import com.squareup.square.models.UpdateTeamMemberResponse;
import com.squareup.square.models.UpdateWageSettingRequest;
import com.squareup.square.models.UpdateWageSettingResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultTeamApi
extends BaseApi
implements TeamApi {
    public DefaultTeamApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultTeamApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public CreateTeamMemberResponse createTeamMember(CreateTeamMemberRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateTeamMemberRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateTeamMemberResponse(context);
    }

    @Override
    public CompletableFuture<CreateTeamMemberResponse> createTeamMemberAsync(CreateTeamMemberRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateTeamMemberRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateTeamMemberResponse(context));
    }

    private HttpRequest buildCreateTeamMemberRequest(CreateTeamMemberRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/team-members");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateTeamMemberResponse handleCreateTeamMemberResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateTeamMemberResponse result = ApiHelper.deserialize(responseBody, CreateTeamMemberResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public BulkCreateTeamMembersResponse bulkCreateTeamMembers(BulkCreateTeamMembersRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildBulkCreateTeamMembersRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleBulkCreateTeamMembersResponse(context);
    }

    @Override
    public CompletableFuture<BulkCreateTeamMembersResponse> bulkCreateTeamMembersAsync(BulkCreateTeamMembersRequest body) {
        return this.makeHttpCallAsync(() -> this.buildBulkCreateTeamMembersRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleBulkCreateTeamMembersResponse(context));
    }

    private HttpRequest buildBulkCreateTeamMembersRequest(BulkCreateTeamMembersRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/team-members/bulk-create");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BulkCreateTeamMembersResponse handleBulkCreateTeamMembersResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BulkCreateTeamMembersResponse result = ApiHelper.deserialize(responseBody, BulkCreateTeamMembersResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public BulkUpdateTeamMembersResponse bulkUpdateTeamMembers(BulkUpdateTeamMembersRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildBulkUpdateTeamMembersRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleBulkUpdateTeamMembersResponse(context);
    }

    @Override
    public CompletableFuture<BulkUpdateTeamMembersResponse> bulkUpdateTeamMembersAsync(BulkUpdateTeamMembersRequest body) {
        return this.makeHttpCallAsync(() -> this.buildBulkUpdateTeamMembersRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleBulkUpdateTeamMembersResponse(context));
    }

    private HttpRequest buildBulkUpdateTeamMembersRequest(BulkUpdateTeamMembersRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/team-members/bulk-update");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private BulkUpdateTeamMembersResponse handleBulkUpdateTeamMembersResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BulkUpdateTeamMembersResponse result = ApiHelper.deserialize(responseBody, BulkUpdateTeamMembersResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchTeamMembersResponse searchTeamMembers(SearchTeamMembersRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchTeamMembersRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchTeamMembersResponse(context);
    }

    @Override
    public CompletableFuture<SearchTeamMembersResponse> searchTeamMembersAsync(SearchTeamMembersRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchTeamMembersRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchTeamMembersResponse(context));
    }

    private HttpRequest buildSearchTeamMembersRequest(SearchTeamMembersRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/team-members/search");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchTeamMembersResponse handleSearchTeamMembersResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchTeamMembersResponse result = ApiHelper.deserialize(responseBody, SearchTeamMembersResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveTeamMemberResponse retrieveTeamMember(String teamMemberId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveTeamMemberRequest(teamMemberId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveTeamMemberResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveTeamMemberResponse> retrieveTeamMemberAsync(String teamMemberId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveTeamMemberRequest(teamMemberId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveTeamMemberResponse(context));
    }

    private HttpRequest buildRetrieveTeamMemberRequest(String teamMemberId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/team-members/{team_member_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("team_member_id", new AbstractMap.SimpleEntry<String, Boolean>(teamMemberId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveTeamMemberResponse handleRetrieveTeamMemberResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveTeamMemberResponse result = ApiHelper.deserialize(responseBody, RetrieveTeamMemberResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdateTeamMemberResponse updateTeamMember(String teamMemberId, UpdateTeamMemberRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateTeamMemberRequest(teamMemberId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateTeamMemberResponse(context);
    }

    @Override
    public CompletableFuture<UpdateTeamMemberResponse> updateTeamMemberAsync(String teamMemberId, UpdateTeamMemberRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateTeamMemberRequest(teamMemberId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateTeamMemberResponse(context));
    }

    private HttpRequest buildUpdateTeamMemberRequest(String teamMemberId, UpdateTeamMemberRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/team-members/{team_member_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("team_member_id", new AbstractMap.SimpleEntry<String, Boolean>(teamMemberId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpdateTeamMemberResponse handleUpdateTeamMemberResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdateTeamMemberResponse result = ApiHelper.deserialize(responseBody, UpdateTeamMemberResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public RetrieveWageSettingResponse retrieveWageSetting(String teamMemberId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveWageSettingRequest(teamMemberId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveWageSettingResponse(context);
    }

    @Override
    public CompletableFuture<RetrieveWageSettingResponse> retrieveWageSettingAsync(String teamMemberId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveWageSettingRequest(teamMemberId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveWageSettingResponse(context));
    }

    private HttpRequest buildRetrieveWageSettingRequest(String teamMemberId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/team-members/{team_member_id}/wage-setting");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("team_member_id", new AbstractMap.SimpleEntry<String, Boolean>(teamMemberId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveWageSettingResponse handleRetrieveWageSettingResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveWageSettingResponse result = ApiHelper.deserialize(responseBody, RetrieveWageSettingResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public UpdateWageSettingResponse updateWageSetting(String teamMemberId, UpdateWageSettingRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateWageSettingRequest(teamMemberId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateWageSettingResponse(context);
    }

    @Override
    public CompletableFuture<UpdateWageSettingResponse> updateWageSettingAsync(String teamMemberId, UpdateWageSettingRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateWageSettingRequest(teamMemberId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateWageSettingResponse(context));
    }

    private HttpRequest buildUpdateWageSettingRequest(String teamMemberId, UpdateWageSettingRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/team-members/{team_member_id}/wage-setting");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("team_member_id", new AbstractMap.SimpleEntry<String, Boolean>(teamMemberId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private UpdateWageSettingResponse handleUpdateWageSettingResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        UpdateWageSettingResponse result = ApiHelper.deserialize(responseBody, UpdateWageSettingResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

