/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.TerminalApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.CancelTerminalActionResponse;
import com.squareup.square.models.CancelTerminalCheckoutResponse;
import com.squareup.square.models.CancelTerminalRefundResponse;
import com.squareup.square.models.CreateTerminalActionRequest;
import com.squareup.square.models.CreateTerminalActionResponse;
import com.squareup.square.models.CreateTerminalCheckoutRequest;
import com.squareup.square.models.CreateTerminalCheckoutResponse;
import com.squareup.square.models.CreateTerminalRefundRequest;
import com.squareup.square.models.CreateTerminalRefundResponse;
import com.squareup.square.models.GetTerminalActionResponse;
import com.squareup.square.models.GetTerminalCheckoutResponse;
import com.squareup.square.models.GetTerminalRefundResponse;
import com.squareup.square.models.SearchTerminalActionsRequest;
import com.squareup.square.models.SearchTerminalActionsResponse;
import com.squareup.square.models.SearchTerminalCheckoutsRequest;
import com.squareup.square.models.SearchTerminalCheckoutsResponse;
import com.squareup.square.models.SearchTerminalRefundsRequest;
import com.squareup.square.models.SearchTerminalRefundsResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultTerminalApi
extends BaseApi
implements TerminalApi {
    public DefaultTerminalApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultTerminalApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    public CreateTerminalActionResponse createTerminalAction(CreateTerminalActionRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateTerminalActionRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateTerminalActionResponse(context);
    }

    @Override
    public CompletableFuture<CreateTerminalActionResponse> createTerminalActionAsync(CreateTerminalActionRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateTerminalActionRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateTerminalActionResponse(context));
    }

    private HttpRequest buildCreateTerminalActionRequest(CreateTerminalActionRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/actions");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateTerminalActionResponse handleCreateTerminalActionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateTerminalActionResponse result = ApiHelper.deserialize(responseBody, CreateTerminalActionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchTerminalActionsResponse searchTerminalActions(SearchTerminalActionsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchTerminalActionsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchTerminalActionsResponse(context);
    }

    @Override
    public CompletableFuture<SearchTerminalActionsResponse> searchTerminalActionsAsync(SearchTerminalActionsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchTerminalActionsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchTerminalActionsResponse(context));
    }

    private HttpRequest buildSearchTerminalActionsRequest(SearchTerminalActionsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/actions/search");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchTerminalActionsResponse handleSearchTerminalActionsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchTerminalActionsResponse result = ApiHelper.deserialize(responseBody, SearchTerminalActionsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public GetTerminalActionResponse getTerminalAction(String actionId) throws ApiException, IOException {
        HttpRequest request = this.buildGetTerminalActionRequest(actionId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetTerminalActionResponse(context);
    }

    @Override
    public CompletableFuture<GetTerminalActionResponse> getTerminalActionAsync(String actionId) {
        return this.makeHttpCallAsync(() -> this.buildGetTerminalActionRequest(actionId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetTerminalActionResponse(context));
    }

    private HttpRequest buildGetTerminalActionRequest(String actionId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/actions/{action_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("action_id", new AbstractMap.SimpleEntry<String, Boolean>(actionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private GetTerminalActionResponse handleGetTerminalActionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        GetTerminalActionResponse result = ApiHelper.deserialize(responseBody, GetTerminalActionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CancelTerminalActionResponse cancelTerminalAction(String actionId) throws ApiException, IOException {
        HttpRequest request = this.buildCancelTerminalActionRequest(actionId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCancelTerminalActionResponse(context);
    }

    @Override
    public CompletableFuture<CancelTerminalActionResponse> cancelTerminalActionAsync(String actionId) {
        return this.makeHttpCallAsync(() -> this.buildCancelTerminalActionRequest(actionId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCancelTerminalActionResponse(context));
    }

    private HttpRequest buildCancelTerminalActionRequest(String actionId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/actions/{action_id}/cancel");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("action_id", new AbstractMap.SimpleEntry<String, Boolean>(actionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().post(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CancelTerminalActionResponse handleCancelTerminalActionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CancelTerminalActionResponse result = ApiHelper.deserialize(responseBody, CancelTerminalActionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateTerminalCheckoutResponse createTerminalCheckout(CreateTerminalCheckoutRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateTerminalCheckoutRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateTerminalCheckoutResponse(context);
    }

    @Override
    public CompletableFuture<CreateTerminalCheckoutResponse> createTerminalCheckoutAsync(CreateTerminalCheckoutRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateTerminalCheckoutRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateTerminalCheckoutResponse(context));
    }

    private HttpRequest buildCreateTerminalCheckoutRequest(CreateTerminalCheckoutRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/checkouts");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateTerminalCheckoutResponse handleCreateTerminalCheckoutResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateTerminalCheckoutResponse result = ApiHelper.deserialize(responseBody, CreateTerminalCheckoutResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchTerminalCheckoutsResponse searchTerminalCheckouts(SearchTerminalCheckoutsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchTerminalCheckoutsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchTerminalCheckoutsResponse(context);
    }

    @Override
    public CompletableFuture<SearchTerminalCheckoutsResponse> searchTerminalCheckoutsAsync(SearchTerminalCheckoutsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchTerminalCheckoutsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchTerminalCheckoutsResponse(context));
    }

    private HttpRequest buildSearchTerminalCheckoutsRequest(SearchTerminalCheckoutsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/checkouts/search");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchTerminalCheckoutsResponse handleSearchTerminalCheckoutsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchTerminalCheckoutsResponse result = ApiHelper.deserialize(responseBody, SearchTerminalCheckoutsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public GetTerminalCheckoutResponse getTerminalCheckout(String checkoutId) throws ApiException, IOException {
        HttpRequest request = this.buildGetTerminalCheckoutRequest(checkoutId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetTerminalCheckoutResponse(context);
    }

    @Override
    public CompletableFuture<GetTerminalCheckoutResponse> getTerminalCheckoutAsync(String checkoutId) {
        return this.makeHttpCallAsync(() -> this.buildGetTerminalCheckoutRequest(checkoutId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetTerminalCheckoutResponse(context));
    }

    private HttpRequest buildGetTerminalCheckoutRequest(String checkoutId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/checkouts/{checkout_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("checkout_id", new AbstractMap.SimpleEntry<String, Boolean>(checkoutId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private GetTerminalCheckoutResponse handleGetTerminalCheckoutResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        GetTerminalCheckoutResponse result = ApiHelper.deserialize(responseBody, GetTerminalCheckoutResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CancelTerminalCheckoutResponse cancelTerminalCheckout(String checkoutId) throws ApiException, IOException {
        HttpRequest request = this.buildCancelTerminalCheckoutRequest(checkoutId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCancelTerminalCheckoutResponse(context);
    }

    @Override
    public CompletableFuture<CancelTerminalCheckoutResponse> cancelTerminalCheckoutAsync(String checkoutId) {
        return this.makeHttpCallAsync(() -> this.buildCancelTerminalCheckoutRequest(checkoutId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCancelTerminalCheckoutResponse(context));
    }

    private HttpRequest buildCancelTerminalCheckoutRequest(String checkoutId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/checkouts/{checkout_id}/cancel");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("checkout_id", new AbstractMap.SimpleEntry<String, Boolean>(checkoutId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().post(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CancelTerminalCheckoutResponse handleCancelTerminalCheckoutResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CancelTerminalCheckoutResponse result = ApiHelper.deserialize(responseBody, CancelTerminalCheckoutResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CreateTerminalRefundResponse createTerminalRefund(CreateTerminalRefundRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateTerminalRefundRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateTerminalRefundResponse(context);
    }

    @Override
    public CompletableFuture<CreateTerminalRefundResponse> createTerminalRefundAsync(CreateTerminalRefundRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateTerminalRefundRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateTerminalRefundResponse(context));
    }

    private HttpRequest buildCreateTerminalRefundRequest(CreateTerminalRefundRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/refunds");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CreateTerminalRefundResponse handleCreateTerminalRefundResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateTerminalRefundResponse result = ApiHelper.deserialize(responseBody, CreateTerminalRefundResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public SearchTerminalRefundsResponse searchTerminalRefunds(SearchTerminalRefundsRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildSearchTerminalRefundsRequest(body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleSearchTerminalRefundsResponse(context);
    }

    @Override
    public CompletableFuture<SearchTerminalRefundsResponse> searchTerminalRefundsAsync(SearchTerminalRefundsRequest body) {
        return this.makeHttpCallAsync(() -> this.buildSearchTerminalRefundsRequest(body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleSearchTerminalRefundsResponse(context));
    }

    private HttpRequest buildSearchTerminalRefundsRequest(SearchTerminalRefundsRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/refunds/search");
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private SearchTerminalRefundsResponse handleSearchTerminalRefundsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        SearchTerminalRefundsResponse result = ApiHelper.deserialize(responseBody, SearchTerminalRefundsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public GetTerminalRefundResponse getTerminalRefund(String terminalRefundId) throws ApiException, IOException {
        HttpRequest request = this.buildGetTerminalRefundRequest(terminalRefundId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetTerminalRefundResponse(context);
    }

    @Override
    public CompletableFuture<GetTerminalRefundResponse> getTerminalRefundAsync(String terminalRefundId) {
        return this.makeHttpCallAsync(() -> this.buildGetTerminalRefundRequest(terminalRefundId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetTerminalRefundResponse(context));
    }

    private HttpRequest buildGetTerminalRefundRequest(String terminalRefundId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/refunds/{terminal_refund_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("terminal_refund_id", new AbstractMap.SimpleEntry<String, Boolean>(terminalRefundId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private GetTerminalRefundResponse handleGetTerminalRefundResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        GetTerminalRefundResponse result = ApiHelper.deserialize(responseBody, GetTerminalRefundResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    public CancelTerminalRefundResponse cancelTerminalRefund(String terminalRefundId) throws ApiException, IOException {
        HttpRequest request = this.buildCancelTerminalRefundRequest(terminalRefundId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCancelTerminalRefundResponse(context);
    }

    @Override
    public CompletableFuture<CancelTerminalRefundResponse> cancelTerminalRefundAsync(String terminalRefundId) {
        return this.makeHttpCallAsync(() -> this.buildCancelTerminalRefundRequest(terminalRefundId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCancelTerminalRefundResponse(context));
    }

    private HttpRequest buildCancelTerminalRefundRequest(String terminalRefundId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/terminals/refunds/{terminal_refund_id}/cancel");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("terminal_refund_id", new AbstractMap.SimpleEntry<String, Boolean>(terminalRefundId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().post(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CancelTerminalRefundResponse handleCancelTerminalRefundResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CancelTerminalRefundResponse result = ApiHelper.deserialize(responseBody, CancelTerminalRefundResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

