/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.TransactionsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.CaptureTransactionResponse;
import com.squareup.square.models.ListTransactionsResponse;
import com.squareup.square.models.RetrieveTransactionResponse;
import com.squareup.square.models.VoidTransactionResponse;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultTransactionsApi
extends BaseApi
implements TransactionsApi {
    public DefaultTransactionsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultTransactionsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    @Deprecated
    public ListTransactionsResponse listTransactions(String locationId, String beginTime, String endTime, String sortOrder, String cursor) throws ApiException, IOException {
        HttpRequest request = this.buildListTransactionsRequest(locationId, beginTime, endTime, sortOrder, cursor);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListTransactionsResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<ListTransactionsResponse> listTransactionsAsync(String locationId, String beginTime, String endTime, String sortOrder, String cursor) {
        return this.makeHttpCallAsync(() -> this.buildListTransactionsRequest(locationId, beginTime, endTime, sortOrder, cursor), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListTransactionsResponse(context));
    }

    private HttpRequest buildListTransactionsRequest(String locationId, String beginTime, String endTime, String sortOrder, String cursor) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/locations/{location_id}/transactions");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("begin_time", beginTime);
        queryParameters.put("end_time", endTime);
        queryParameters.put("sort_order", sortOrder);
        queryParameters.put("cursor", cursor);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ListTransactionsResponse handleListTransactionsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ListTransactionsResponse result = ApiHelper.deserialize(responseBody, ListTransactionsResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public RetrieveTransactionResponse retrieveTransaction(String locationId, String transactionId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveTransactionRequest(locationId, transactionId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveTransactionResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<RetrieveTransactionResponse> retrieveTransactionAsync(String locationId, String transactionId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveTransactionRequest(locationId, transactionId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveTransactionResponse(context));
    }

    private HttpRequest buildRetrieveTransactionRequest(String locationId, String transactionId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/locations/{location_id}/transactions/{transaction_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        templateParameters.put("transaction_id", new AbstractMap.SimpleEntry<String, Boolean>(transactionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private RetrieveTransactionResponse handleRetrieveTransactionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RetrieveTransactionResponse result = ApiHelper.deserialize(responseBody, RetrieveTransactionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public CaptureTransactionResponse captureTransaction(String locationId, String transactionId) throws ApiException, IOException {
        HttpRequest request = this.buildCaptureTransactionRequest(locationId, transactionId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCaptureTransactionResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<CaptureTransactionResponse> captureTransactionAsync(String locationId, String transactionId) {
        return this.makeHttpCallAsync(() -> this.buildCaptureTransactionRequest(locationId, transactionId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCaptureTransactionResponse(context));
    }

    private HttpRequest buildCaptureTransactionRequest(String locationId, String transactionId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/locations/{location_id}/transactions/{transaction_id}/capture");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        templateParameters.put("transaction_id", new AbstractMap.SimpleEntry<String, Boolean>(transactionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().post(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private CaptureTransactionResponse handleCaptureTransactionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CaptureTransactionResponse result = ApiHelper.deserialize(responseBody, CaptureTransactionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public VoidTransactionResponse voidTransaction(String locationId, String transactionId) throws ApiException, IOException {
        HttpRequest request = this.buildVoidTransactionRequest(locationId, transactionId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleVoidTransactionResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<VoidTransactionResponse> voidTransactionAsync(String locationId, String transactionId) {
        return this.makeHttpCallAsync(() -> this.buildVoidTransactionRequest(locationId, transactionId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleVoidTransactionResponse(context));
    }

    private HttpRequest buildVoidTransactionRequest(String locationId, String transactionId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v2/locations/{location_id}/transactions/{transaction_id}/void");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        templateParameters.put("transaction_id", new AbstractMap.SimpleEntry<String, Boolean>(transactionId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().post(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private VoidTransactionResponse handleVoidTransactionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        VoidTransactionResponse result = ApiHelper.deserialize(responseBody, VoidTransactionResponse.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

